/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.exceptions.PatternExhaustedException;
import com.simplj.flows.steps.NestedStep;
import com.simplj.flows.steps.PartialStep;
import com.simplj.flows.steps.Step;
import com.simplj.lambda.executable.Executable;
import com.simplj.lambda.function.Condition;
import java.util.LinkedList;
import java.util.List;

public final class ConditionalStep<I, O>
extends NestedStep<I, O> {
    private AbstractStep<I, O> defaultStep;
    private final List<ConditionBranch<I, O>> conditionalSteps = new LinkedList<ConditionBranch<I, O>>();

    ConditionalStep(String stepName, String branchName, Condition<I> cond, AbstractStep<I, O> step) {
        super(stepName);
        this.conditionalSteps.add(new ConditionBranch(branchName, cond, step));
    }

    public final PartialStep<I, O, ConditionalStep<I, O>> when(Condition<I> cond) {
        return this.when(this.name() + "::branch-" + this.branchNumber(), cond);
    }

    public final PartialStep<I, O, ConditionalStep<I, O>> when(String name, Condition<I> cond) {
        return new ConditionalWhen(name, cond);
    }

    public final Step<I, O> otherwise(Executable<I, O> defaultExecutable) {
        return this.otherwise(Step.lift(this.name() + "::default", defaultExecutable));
    }

    public final Step<I, O> otherwise(AbstractStep<I, O> defaultStep) {
        this.defaultStep = defaultStep;
        return this;
    }

    @Override
    protected final ExecutionResult<O> executeStep(ExecutionContext ctx, I input) {
        ExecutionResult<Object> res = null;
        for (ConditionBranch<I, O> cb : this.conditionalSteps) {
            ExecutionResult<Boolean> eRes = ConditionalStep.evaluate(((ConditionBranch)cb).conditionName, ((ConditionBranch)cb).condition, input, ctx);
            if (eRes.isSuccess()) {
                boolean flag = eRes.result() != null && eRes.result() != false;
                if (!flag) continue;
                res = ConditionalStep.execute(((ConditionBranch)cb).step, input, ctx);
                break;
            }
            res = ConditionalStep.error(eRes.error(), eRes.executionContext());
            break;
        }
        if (res == null) {
            res = this.defaultStep == null ? ConditionalStep.error(new PatternExhaustedException(this.name(), input), ctx) : ConditionalStep.execute(this.defaultStep, input, ctx);
        }
        return res;
    }

    private ConditionalStep<I, O> addStep(String name, Condition<I> cond, AbstractStep<I, O> step) {
        this.conditionalSteps.add(new ConditionBranch(name, cond, step));
        return this;
    }

    private int branchNumber() {
        return this.conditionalSteps.size() + 1;
    }

    private static class ConditionBranch<T, R> {
        private final String conditionName;
        private final Condition<T> condition;
        private final AbstractStep<T, R> step;

        private ConditionBranch(String name, Condition<T> condition, AbstractStep<T, R> step) {
            this.conditionName = name;
            this.condition = condition;
            this.step = step;
        }
    }

    private class ConditionalWhen
    implements PartialStep<I, O, ConditionalStep<I, O>> {
        private final String name;
        private final Condition<I> cond;

        private ConditionalWhen(String name, Condition<I> cond) {
            this.name = name;
            this.cond = cond;
        }

        @Override
        public final ConditionalStep<I, O> then(Executable<I, O> executable) {
            return this.then((AbstractStep)Step.lift(this.name + "-step", executable));
        }

        @Override
        public final ConditionalStep<I, O> then(AbstractStep<I, O> step) {
            return ConditionalStep.this.addStep(this.name, this.cond, step);
        }
    }
}

