/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.steps.ConditionalStep;
import com.simplj.flows.steps.Step;
import com.simplj.lambda.executable.Executable;
import com.simplj.lambda.function.Condition;

public final class ConditionalStepBuilder {
    private final String stepName;

    ConditionalStepBuilder(String name) {
        this.stepName = name;
    }

    public final <T> PartialConditionalStep<T> when(Condition<T> cond) {
        return this.when(this.stepName + "::branch-1", cond);
    }

    public final <T> PartialConditionalStep<T> when(String name, Condition<T> cond) {
        return new PartialConditionalStep(this.stepName, name, cond);
    }

    public static class PartialConditionalStep<T> {
        private final String name;
        private final String branchName;
        private final Condition<T> cond;

        private PartialConditionalStep(String name, String branchName, Condition<T> cond) {
            this.name = name;
            this.branchName = branchName;
            this.cond = cond;
        }

        public final <R> ConditionalStep<T, R> then(Executable<T, R> executable) {
            return this.then(Step.lift(this.branchName + "-step", executable));
        }

        public final <R> ConditionalStep<T, R> then(AbstractStep<T, R> step) {
            return new ConditionalStep<T, R>(this.name, this.branchName, this.cond, step);
        }
    }
}

