/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.steps.ParallelIteratorStep;
import com.simplj.flows.steps.SerialIteratorStep;
import com.simplj.flows.steps.Step;
import com.simplj.flows.steps.ThreadPoolFactory;
import com.simplj.lambda.executable.Executable;
import java.util.concurrent.ExecutorService;

public final class IteratorStepBuilder {
    private final String name;

    IteratorStepBuilder(String name) {
        this.name = name;
    }

    public final <T, R> SerialIteratorStep<T, R> iterate(Executable<T, R> executable) {
        return this.iterate(false, Step.lift(executable));
    }

    public final <T, R> SerialIteratorStep<T, R> iterate(boolean failFast, Executable<T, R> executable) {
        return this.iterate(failFast, Step.lift(executable));
    }

    public final <T, R> SerialIteratorStep<T, R> iterate(AbstractStep<T, R> step) {
        return this.iterate(false, step);
    }

    public final <T, R> SerialIteratorStep<T, R> iterate(boolean failFast, AbstractStep<T, R> step) {
        return new SerialIteratorStep<T, R>(this.name, step, failFast);
    }

    public final <T, R> ParallelIteratorStep<T, R> parallelIterate(Executable<T, R> executable) {
        return this.parallelIterate(Step.lift(executable), Runtime.getRuntime().availableProcessors());
    }

    public final <T, R> ParallelIteratorStep<T, R> parallelIterate(AbstractStep<T, R> step) {
        return this.parallelIterate(step, Runtime.getRuntime().availableProcessors());
    }

    public final <T, R> ParallelIteratorStep<T, R> parallelIterate(Executable<T, R> executable, int threads) {
        return this.parallelIterate(Step.lift(executable), threads);
    }

    public final <T, R> ParallelIteratorStep<T, R> parallelIterate(AbstractStep<T, R> step, int threads) {
        return new ParallelIteratorStep<T, R>(this.name, step, ThreadPoolFactory.create(threads));
    }

    public final <T, R> ParallelIteratorStep<T, R> parallelIterate(Executable<T, R> executable, ExecutorService es) {
        return this.parallelIterate(Step.lift(executable), es);
    }

    public final <T, R> ParallelIteratorStep<T, R> parallelIterate(AbstractStep<T, R> step, ExecutorService es) {
        return new ParallelIteratorStep<T, R>(this.name, step, ThreadPoolFactory.provided(es));
    }
}

