/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.steps.Step;
import com.simplj.lambda.function.Condition;
import java.util.concurrent.TimeUnit;

public final class PauseStep<T>
extends Step<T, T> {
    private final boolean timedPause;
    private final long pauseMillis;
    private final Condition<T> pauseCondition;
    private final long maxWaitTimeMillis;

    PauseStep(long duration, TimeUnit unit) {
        this("timed-pause", true, TimeUnit.MILLISECONDS.convert(duration, unit), null, 0L);
    }

    PauseStep(Condition<T> condition, long intervalInMillis, int maxWaitTimeInSeconds) {
        this("conditional-pause", false, intervalInMillis, condition, TimeUnit.SECONDS.toMillis(maxWaitTimeInSeconds));
    }

    private PauseStep(String name, boolean timedPause, long pauseMillis, Condition<T> pauseCondition, long maxWaitTimeMillis) {
        super(name);
        this.timedPause = timedPause;
        this.pauseMillis = pauseMillis;
        this.pauseCondition = pauseCondition;
        this.maxWaitTimeMillis = maxWaitTimeMillis;
    }

    @Override
    protected final ExecutionResult<T> execute(ExecutionContext ctx, T input) {
        String msg;
        long s = System.currentTimeMillis();
        if (this.timedPause) {
            msg = "Timed pause for " + this.pauseMillis + " millis";
            PauseStep.pause(this.pauseMillis);
        } else {
            msg = "Paused for condition!";
            PauseStep.conditionalPause(this.pauseCondition, input, this.maxWaitTimeMillis, this.pauseMillis);
        }
        return PauseStep.success(input, PauseStep.addFrame(ctx, PauseStep.stepFrame("pause-step", msg, System.currentTimeMillis() - s)));
    }
}

