/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.core.Input;
import com.simplj.flows.steps.Step;
import com.simplj.lambda.executable.BiExecutable;
import com.simplj.lambda.executable.Executable;
import com.simplj.lambda.function.BiCondition;
import com.simplj.lambda.function.Condition;
import com.simplj.lambda.function.Function;
import java.util.Optional;

final class RepeatableStep<I, O>
extends Step<I, O> {
    private static final ExecutionResult<Boolean> NEGATIVE = RepeatableStep.success(false, null);
    private final AbstractStep<I, O> step;
    private final BiExecutable<I, O, I> accumulator;
    private final Condition<Integer> timesCheck;
    private final BiCondition<I, O> condition;
    private final Interval interval;

    RepeatableStep(String name, AbstractStep<I, O> step, BiExecutable<I, O, I> accumulator, Condition<Integer> timesCheck, BiCondition<I, O> condition, Interval interval) {
        super(name);
        this.step = step;
        this.accumulator = Optional.ofNullable(accumulator).orElse(BiExecutable.first());
        this.timesCheck = timesCheck;
        this.condition = condition == null ? null : condition.negate();
        this.interval = interval;
    }

    @Override
    protected final ExecutionResult<O> execute(ExecutionContext ctx, I input) {
        Input inp = Input.of(input);
        long s = System.currentTimeMillis();
        ExecutionResult<O> res = this.interval == null ? this.executeWithoutInterval(input, RepeatableStep.copy(ctx, null)) : this.executeWithInterval(input, RepeatableStep.copy(ctx, null));
        long e = System.currentTimeMillis();
        return RepeatableStep.executionResult(res.result(), res.error(), RepeatableStep.addFrame(ctx, RepeatableStep.stepFrame(this.name, inp, RepeatableStep.stepFrames(res.executionContext()), res.result(), e - s)));
    }

    private ExecutionResult<O> executeWithoutInterval(I input, ExecutionContext subCtx) {
        ExecutionResult<O> res;
        ExecutionResult<I> accRes = RepeatableStep.success(input, null);
        int n = 0;
        if (this.condition == null) {
            do {
                res = RepeatableStep.execute(this.step, accRes.result(), subCtx);
            } while ((accRes = this.accumulate(this.accumulator.exec(accRes.result()), res)).isSuccess() && this.timesCheck.evaluate((Object)(++n)));
        } else {
            boolean flag;
            do {
                res = RepeatableStep.execute(this.step, accRes.result(), subCtx);
                boolean bl = flag = (accRes = this.accumulate(this.accumulator.exec(accRes.result()), res)).isSuccess() && this.satisfiesCondition(subCtx, accRes.result(), res.result());
            } while (flag && this.timesCheck.evaluate((Object)n));
        }
        return res;
    }

    private ExecutionResult<O> executeWithInterval(I input, ExecutionContext subCtx) {
        ExecutionResult<O> res;
        ExecutionResult<I> accRes = RepeatableStep.success(input, null);
        int n = 0;
        if (this.condition == null) {
            res = RepeatableStep.execute(this.step, accRes.result(), subCtx);
            accRes = this.accumulate(this.accumulator.exec(accRes.result()), res);
            ++n;
            long delay = this.interval.initialDelayMillis;
            while (accRes.isSuccess() && this.timesCheck.evaluate((Object)n)) {
                RepeatableStep.pause(delay);
                res = RepeatableStep.execute(this.step, input, RepeatableStep.addFrame(subCtx, RepeatableStep.stepFrame(this.name + "-pause", "Paused for " + delay + " millis.")));
                accRes = this.accumulate(this.accumulator.exec(accRes.result()), res);
                ++n;
                delay = (Long)this.interval.intervalF.apply((Object)delay);
            }
        } else {
            res = RepeatableStep.execute(this.step, accRes.result(), subCtx);
            boolean flag = (accRes = this.accumulate(this.accumulator.exec(accRes.result()), res)).isSuccess() && this.satisfiesCondition(subCtx, accRes.result(), res.result());
            long delay = this.interval.initialDelayMillis;
            while (flag && this.timesCheck.evaluate((Object)n)) {
                RepeatableStep.pause(delay);
                res = RepeatableStep.execute(this.step, accRes.result(), RepeatableStep.addFrame(subCtx, RepeatableStep.stepFrame(this.name + "-pause", "Paused for " + delay + " millis.")));
                accRes = this.accumulate(this.accumulator.exec(accRes.result()), res);
                flag = accRes.isSuccess() && this.satisfiesCondition(subCtx, accRes.result(), res.result());
                delay = (Long)this.interval.intervalF.apply((Object)delay);
            }
        }
        return res;
    }

    private ExecutionResult<I> accumulate(Executable<O, I> acc, ExecutionResult<O> res) {
        return res.flatmap(r -> RepeatableStep.execute(acc, res.result(), res.executionContext(), this.name + "-acc"));
    }

    private boolean satisfiesCondition(ExecutionContext subCtx, I input, O output) {
        return RepeatableStep.evaluate(this.name + "-condition", this.condition.eval(input), output, subCtx).filter((Condition<Boolean>)Condition.equal((Comparable)Boolean.valueOf(true))).isSuccess();
    }

    static final class Interval {
        private final long initialDelayMillis;
        private final Function<Long, Long> intervalF;

        Interval(long initialDelayMillis, Function<Long, Long> intervalF) {
            this.initialDelayMillis = initialDelayMillis;
            this.intervalF = intervalF;
        }
    }
}

