/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.steps.RepeatableStep;
import com.simplj.flows.steps.Step;
import com.simplj.lambda.executable.BiExecutable;
import com.simplj.lambda.executable.Executable;
import com.simplj.lambda.function.BiCondition;
import com.simplj.lambda.function.Condition;
import com.simplj.lambda.function.Function;
import java.util.concurrent.TimeUnit;

public final class RepeatableStepBuilder {
    private final String name;

    RepeatableStepBuilder(String name) {
        this.name = name;
    }

    public final <T, R> PartialRepeatableStep<T, R> repeat(Executable<T, R> executable) {
        return this.repeat(Step.lift(executable));
    }

    public final <T, R> PartialRepeatableStep<T, R> repeat(String name, Executable<T, R> executable) {
        return this.repeat(Step.lift(name, executable));
    }

    public final <T, R> PartialRepeatableStep<T, R> repeat(AbstractStep<T, R> step) {
        return new PartialRepeatableStep(this.name, step);
    }

    public final <T, R> PartialRepeatableStep<T, R> flatRepeat(Executable<T, AbstractStep<? super T, R>> executable) {
        return this.repeat(Step.flatten(executable));
    }

    public final <T, R> PartialRepeatableStep<T, R> flatRepeat(String name, Executable<T, AbstractStep<? super T, R>> executable) {
        return this.repeat(Step.flatten(name, executable));
    }

    public static final class PartialRepeatableStep<T, R> {
        private final String name;
        private final AbstractStep<T, R> step;
        private BiExecutable<T, R, T> accumulator;
        private RepeatableStep.Interval interval;

        private PartialRepeatableStep(String name, AbstractStep<T, R> step) {
            this.name = name;
            this.step = step;
        }

        public final PartialRepeatableStep<T, R> withInterval(long duration, TimeUnit unit) {
            return this.withInterval(TimeUnit.MILLISECONDS.convert(duration, unit), (Function<Long, Long>)Function.id());
        }

        public final PartialRepeatableStep<T, R> withInterval(long initialDelayMillis, Function<Long, Long> delayIncrementer) {
            this.interval = new RepeatableStep.Interval(initialDelayMillis, delayIncrementer);
            return this;
        }

        public final PartialRepeatableStep<T, R> accumulate(BiExecutable<T, R, T> f) {
            this.accumulator = f;
            return this;
        }

        public final Step<T, R> times(int n) {
            return new RepeatableStep<T, R>(this.name, this.step, this.accumulator, (Condition<Integer>)Condition.lesser((Comparable)Integer.valueOf(n)), null, this.interval);
        }

        public final Step<T, R> until(BiCondition<T, R> condition) {
            return new RepeatableStep<T, R>(this.name, this.step, this.accumulator, (Condition<Integer>)Condition.always(), condition, this.interval);
        }

        public final Step<T, R> timesOrUntil(int n, BiCondition<T, R> condition) {
            return new RepeatableStep<T, R>(this.name, this.step, this.accumulator, (Condition<Integer>)Condition.lesser((Comparable)Integer.valueOf(n)), condition, this.interval);
        }
    }
}

