/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.di.core.TypeClass;
import com.simplj.flows.RetryableFlow;
import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.core.Input;
import com.simplj.flows.exceptions.FlowConstructException;
import com.simplj.flows.steps.Step;
import com.simplj.lambda.util.Either;
import com.simplj.lambda.util.retry.RetryContext;
import java.util.HashMap;

public final class RetryableStep<I, O>
extends Step<I, O> {
    private final AbstractStep<I, O> step;
    private final RetryContext rCtx;

    RetryableStep(AbstractStep<I, O> step, RetryContext retryContext) {
        super(RetryableStep.name(step));
        this.step = step;
        this.rCtx = retryContext;
    }

    public final RetryableFlow<I, O> toRetryableFlow() {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("step", this.step);
            params.put("retryContext", this.rCtx);
            return (RetryableFlow)RetryableStep.dynamicResolve(new TypeClass<RetryableFlow<I, O>>(){}, params);
        }
        catch (ClassNotFoundException e) {
            throw new FlowConstructException("Failed to construct flow from step! Please contact SJF Team. Error: " + e.getMessage());
        }
    }

    @Override
    protected final ExecutionResult<O> execute(ExecutionContext ctx, I input) {
        ExecutionContext subCtx = RetryableStep.copy(ctx, null);
        Input inp = Input.of(input);
        ExecutionResult<O> res = RetryableStep.execute(this.step, input, subCtx);
        int count = 0;
        long delay = this.rCtx.initialDelay();
        String template = "Step '" + RetryableStep.name(this.step) + "' - Retrying %s after %s millis...";
        boolean retryFlag = this.isRetryNeeded(res, 0L, count);
        long s = System.currentTimeMillis();
        while (retryFlag) {
            String msg = String.format(template, ++count, delay);
            RetryableStep.log(ctx, msg);
            RetryableStep.addFrame(subCtx, RetryableStep.stepFrame(this.name() + "-retry#" + count, msg));
            RetryableStep.pause(delay);
            res = RetryableStep.execute(this.step, input, subCtx);
            delay = this.rCtx.computeDelay(delay);
            retryFlag = this.isRetryNeeded(res, System.currentTimeMillis() - s, count);
        }
        long e = System.currentTimeMillis();
        if (count > 0) {
            if (!res.isSuccess()) {
                RetryableStep.addFrame(subCtx, RetryableStep.stepFrame(this.name() + "-retry#" + count, "Exceeded retry!"));
            }
            res = RetryableStep.executionResult(res.result(), res.error(), RetryableStep.addFrame(ctx, RetryableStep.stepFrame(this.name(), inp, RetryableStep.stepFrames(subCtx), res.result(), e - s)));
        } else {
            res = RetryableStep.executionResult(res.result(), res.error(), RetryableStep.merge(ctx, res.executionContext(), false));
        }
        return res;
    }

    private boolean isRetryNeeded(ExecutionResult<O> res, long timeElapsed, int count) {
        Either<Exception, O> e = res.resultOrError();
        return this.rCtx.isRetryNeeded(count, timeElapsed, e) && (e.isRight() || RetryableStep.notFlowBreak((Exception)e.left()));
    }
}

