/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.exceptions.StepSkipException;
import com.simplj.flows.steps.IterableStep;
import java.util.LinkedList;
import java.util.List;

public final class SerialIteratorStep<I, O>
extends IterableStep<I, O> {
    private final boolean failFast;

    SerialIteratorStep(String name, AbstractStep<I, O> step, boolean failFast) {
        super(name, step);
        this.failFast = failFast;
    }

    @Override
    final List<ExecutionResult<O>> iterateSteps(ExecutionContext ctx, Iterable<I> inputs, AbstractStep<I, O> step) {
        LinkedList<ExecutionResult<O>> res = new LinkedList<ExecutionResult<O>>();
        boolean skip = false;
        for (I input : inputs) {
            ExecutionResult<Object> eRes;
            if (skip) {
                eRes = ExecutionResult.failure(new StepSkipException("Step Execution Skipped!"));
            } else {
                eRes = SerialIteratorStep.execute(step, input, ctx);
                skip = this.failFast && eRes.isFailure();
            }
            res.add(eRes);
        }
        return res;
    }

    @Override
    IterableStep<I, O> construct(String name, AbstractStep<I, O> step) {
        return new SerialIteratorStep<I, O>(name, step, this.failFast);
    }
}

