/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.exceptions.StepSkipException;
import com.simplj.flows.steps.ForkStep;
import com.simplj.flows.steps.Step;
import com.simplj.lambda.executable.Executable;
import java.util.ArrayList;
import java.util.List;

public final class SerialStep<I, O>
extends ForkStep<I, O, SerialStep<I, O>> {
    private final boolean failFast;

    SerialStep(String name, Executable<I, O> executable, boolean failFast) {
        this(name, Step.lift(name + "-part#1", executable), failFast);
    }

    SerialStep(String name, AbstractStep<I, O> step, boolean failFast) {
        super(name);
        this.failFast = failFast;
        this.add(step);
    }

    private SerialStep(String name, int counter, List<AbstractStep<I, O>> steps, boolean failFast) {
        super(name, counter, steps);
        this.failFast = failFast;
    }

    @Override
    final SerialStep<I, O> instance() {
        return this;
    }

    @Override
    final List<ExecutionResult<O>> executeSteps(ExecutionContext ctx, I inp, List<AbstractStep<I, O>> steps) {
        ArrayList<ExecutionResult<O>> res = new ArrayList<ExecutionResult<O>>(steps.size());
        boolean skip = false;
        for (AbstractStep<I, O> step : steps) {
            ExecutionResult<Object> eRes;
            if (skip) {
                eRes = ExecutionResult.failure(new StepSkipException("Step Execution Skipped!"));
            } else {
                eRes = SerialStep.execute(step, inp, ctx);
                skip = this.failFast && eRes.isFailure();
            }
            res.add(eRes);
        }
        return res;
    }

    @Override
    ForkStep<I, O, SerialStep<I, O>> construct(String name, int counter, List<AbstractStep<I, O>> steps) {
        return new SerialStep<I, O>(name, counter, steps, this.failFast);
    }
}

