/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.steps.ParallelIteratorStep;
import com.simplj.flows.steps.SerialIteratorStep;
import com.simplj.flows.steps.SpliteratorStep;
import com.simplj.flows.steps.Step;
import com.simplj.flows.steps.ThreadPoolFactory;
import com.simplj.lambda.executable.Executable;
import com.simplj.lambda.tuples.Couple;
import com.simplj.lambda.tuples.Tuple;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Spliterator<I, O> {
    private final String name;
    private final Executable<I, ? extends Iterable<O>> splitter;

    Spliterator(String name, Executable<I, ? extends Iterable<O>> splitter) {
        this.name = name;
        this.splitter = splitter;
    }

    public final <R> SpliteratorStep<I, O, R> iterate(Executable<O, R> executable) {
        return this.iterate(false, Step.lift(executable));
    }

    public final <R> SpliteratorStep<I, O, R> iterate(boolean failFast, Executable<O, R> executable) {
        return this.iterate(failFast, Step.lift(executable));
    }

    public final <R> SpliteratorStep<I, O, R> iterate(AbstractStep<O, R> step) {
        return this.iterate(false, step);
    }

    public final <R> SpliteratorStep<I, O, R> iterate(boolean failFast, AbstractStep<O, R> step) {
        return new SpliteratorStep<I, O, R>(this.name, this.splitter, new SerialIteratorStep<O, R>(this.name + "-iterator", step, failFast));
    }

    public final <R> SpliteratorStep<I, O, R> parallelIterate(Executable<O, R> executable) {
        return this.parallelIterate(Step.lift(executable), Runtime.getRuntime().availableProcessors());
    }

    public final <R> SpliteratorStep<I, O, R> parallelIterate(AbstractStep<O, R> step) {
        return this.parallelIterate(step, Runtime.getRuntime().availableProcessors());
    }

    public final <R> SpliteratorStep<I, O, R> parallelIterate(Executable<O, R> executable, int threads) {
        return this.parallelIterate(Step.lift(executable), threads);
    }

    public final <R> SpliteratorStep<I, O, R> parallelIterate(AbstractStep<O, R> step, int threads) {
        return new SpliteratorStep<I, O, R>(this.name + "-iterator", this.splitter, new ParallelIteratorStep<O, R>(this.name + "-iterator", step, ThreadPoolFactory.create(threads)));
    }

    public final <R> SpliteratorStep<I, O, R> parallelIterate(Executable<O, R> executable, ExecutorService es) {
        return this.parallelIterate(Step.lift(executable), es);
    }

    public final <R> SpliteratorStep<I, O, R> parallelIterate(AbstractStep<O, R> step, ExecutorService es) {
        return new SpliteratorStep<I, O, R>(this.name + "-iterator", this.splitter, new ParallelIteratorStep<O, R>(this.name + "-iterator", step, ThreadPoolFactory.provided(es)));
    }

    public static final class SpliteratorBuilder {
        private final String name;

        SpliteratorBuilder(String name) {
            this.name = name;
        }

        public final <T, R> Spliterator<T, R> split(Executable<T, ? extends Iterable<R>> splitter) {
            return new Spliterator(this.name, splitter);
        }

        public final <T> Spliterator<T, T> fork(int n) {
            return new Spliterator(this.name, t -> Stream.iterate(1, x -> x + 1).limit(n).map(x -> t).collect(Collectors.toList()));
        }

        public final <T> Spliterator<T, Integer> indices(int n) {
            return new Spliterator(this.name, t -> Stream.iterate(1, x -> x + 1).limit(n).collect(Collectors.toList()));
        }

        public final <T> Spliterator<T, Couple<Integer, T>> indexedFork(int n) {
            return new Spliterator(this.name, t -> Stream.iterate(1, x -> x + 1).limit(n).map(x -> Tuple.of((Object)x, (Object)t)).collect(Collectors.toList()));
        }
    }
}

