/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.di.core.TypeClass;
import com.simplj.flows.Flow;
import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.exceptions.FlowBreakException;
import com.simplj.flows.exceptions.FlowConstructException;
import com.simplj.flows.steps.EitherExecutableStep;
import com.simplj.flows.steps.ErrorStep;
import com.simplj.flows.steps.ExecutableStep;
import com.simplj.flows.steps.FlatExecutableStep;
import com.simplj.flows.steps.RetryableStep;
import com.simplj.lambda.executable.Executable;
import com.simplj.lambda.executable.Provider;
import com.simplj.lambda.executable.Receiver;
import com.simplj.lambda.function.Function;
import com.simplj.lambda.monadic.State;
import com.simplj.lambda.monadic.Thunk;
import com.simplj.lambda.util.Either;
import com.simplj.lambda.util.Try;
import com.simplj.lambda.util.retry.RetryContext;
import java.util.Collections;

public abstract class Step<I, O>
extends AbstractStep<I, O> {
    private static final String ANONYMOUS = "anonymous";

    public Step(String name) {
        super(name);
    }

    public static <T> Step<T, T> id() {
        return Step.lift("identity", Executable.id());
    }

    public static <T> Step<T, T> lift(Receiver<T> c) {
        return Step.lift(ANONYMOUS, c);
    }

    public static <T> Step<T, T> lift(String name, Receiver<T> c) {
        return Step.lift(name, c.yield());
    }

    public static <T, R> Step<T, R> lift(Provider<R> p) {
        return Step.lift(ANONYMOUS, p);
    }

    public static <T, R> Step<T, R> lift(String name, Provider<R> p) {
        return Step.lift(name, p.toExecutable());
    }

    public static <T, R> Step<T, R> lift(Executable<T, R> executable) {
        return Step.lift(ANONYMOUS, executable);
    }

    public static <T, R> Step<T, R> lift(String name, Executable<T, R> executable) {
        return new ExecutableStep<T, R>(name, executable);
    }

    public static <T, R> Step<T, R> flatten(Executable<? super T, AbstractStep<? super T, R>> executable) {
        return Step.flatten("flatten", executable);
    }

    public static <T, R> Step<T, R> flatten(String name, Executable<? super T, AbstractStep<? super T, R>> executable) {
        return new FlatExecutableStep<T, R>(name, executable);
    }

    public static <T, R> Step<T, R> liftEither(Function<T, Either<Exception, R>> f) {
        return Step.liftEither(ANONYMOUS, f);
    }

    public static <T, R> Step<T, R> liftEither(String name, Function<T, Either<Exception, R>> f) {
        return new EitherExecutableStep<T, R>(name, f);
    }

    public static <T, R> Step<T, R> liftTry(Function<T, Try<R>> f) {
        return Step.liftTry(ANONYMOUS, f);
    }

    public static <T, R> Step<T, R> liftTry(String name, Function<T, Try<R>> f) {
        return new EitherExecutableStep(name, f.andThen(Try::result));
    }

    public static <T, R> Step<T, R> liftState(Function<T, State<R>> f) {
        return Step.liftState(ANONYMOUS, f);
    }

    public static <T, R> Step<T, R> liftState(String name, Function<T, State<R>> f) {
        return new EitherExecutableStep(name, f.andThen(State::result));
    }

    public static <T, R> Step<T, R> liftThunk(Function<T, Thunk<R>> f) {
        return Step.liftThunk(ANONYMOUS, f);
    }

    public static <T, R> Step<T, R> liftThunk(String name, Function<T, Thunk<R>> f) {
        return new EitherExecutableStep(name, f.andThen(Thunk::result));
    }

    public static <T, R> Step<T, R> err(String errorMessage) {
        return Step.error(x -> new FlowBreakException(errorMessage));
    }

    public static <T, R> Step<T, R> err(Function<T, String> errorF) {
        return Step.error(errorF.andThen(FlowBreakException::new));
    }

    public static <T, R> Step<T, R> error(Exception ex) {
        return Step.error(x -> ex);
    }

    public static <T, R> Step<T, R> error(Function<T, Exception> exF) {
        return new ErrorStep(exF);
    }

    public final Step<Void, O> withInput(I input) {
        return Step.connectorStep(this.name, Step.simpleStep(x -> input), this);
    }

    public final <A> Step<A, O> compose(Function<A, I> f) {
        return Step.connectorStep(this.name, Step.simpleStep(f), this);
    }

    public final <A> Step<I, A> map(Function<O, A> f) {
        return Step.connectorStep(this.name, this, Step.simpleStep(f));
    }

    @Override
    public AbstractStep<I, O> withRetry(RetryContext ctx) {
        return new RetryableStep(this, ctx);
    }

    public final Flow<I, O> toFlow() {
        try {
            return (Flow)Step.dynamicResolve(new TypeClass<Flow<I, O>>(){}, Collections.singletonMap("step", this));
        }
        catch (ClassNotFoundException e) {
            throw new FlowConstructException("Failed to construct flow from step! Please contact SJF Team. Error: " + e.getMessage());
        }
    }
}

