/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.di.core.TypeClass;
import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.exceptions.FlowBreakException;
import com.simplj.flows.steps.AsyncCompletable;
import com.simplj.flows.steps.AsyncStep;
import com.simplj.flows.steps.AsyncStepBuilder;
import com.simplj.flows.steps.BranchStep;
import com.simplj.flows.steps.ComparableStepBuilder;
import com.simplj.flows.steps.ConditionalStepBuilder;
import com.simplj.flows.steps.GuardStep;
import com.simplj.flows.steps.IteratorStepBuilder;
import com.simplj.flows.steps.ParallelStepBuilder;
import com.simplj.flows.steps.PauseStep;
import com.simplj.flows.steps.RepeatableStepBuilder;
import com.simplj.flows.steps.RetryableStep;
import com.simplj.flows.steps.SerialStepBuilder;
import com.simplj.flows.steps.Spliterator;
import com.simplj.flows.steps.Step;
import com.simplj.flows.steps.ThreadPoolFactory;
import com.simplj.flows.steps.UnsafeStepBuilder;
import com.simplj.lambda.executable.BiExecutable;
import com.simplj.lambda.executable.Executable;
import com.simplj.lambda.executable.Receiver;
import com.simplj.lambda.function.BiConsumer;
import com.simplj.lambda.function.Condition;
import com.simplj.lambda.function.Consumer;
import com.simplj.lambda.function.Function;
import com.simplj.lambda.util.retry.RetryContext;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class StepFactory {
    public static <T> AbstractStep<T, T> pauseStep(long duration, TimeUnit unit) {
        return new PauseStep(duration, unit);
    }

    public static <T> Step<T, T> asyncStep(Receiver<T> consumer) {
        return StepFactory.asyncStep(Consumer.noOp(), Step.lift(consumer.yield()), BiConsumer.noOp(), BiConsumer.noOp(), null);
    }

    public static <T> Step<T, T> asyncStep(Consumer<T> preHook, Receiver<T> consumer, Consumer<T> postHook) {
        return StepFactory.asyncStep(preHook, Step.lift(consumer.yield()), (i, o) -> postHook.consume(i), BiConsumer.noOp(), null);
    }

    public static <T> Step<T, T> asyncStep(Consumer<T> preHook, Receiver<T> consumer, Consumer<T> postHook, BiConsumer<T, Exception> errNotifier) {
        return StepFactory.asyncStep(preHook, Step.lift(consumer.yield()), (i, o) -> postHook.consume(i), errNotifier, null);
    }

    public static <T> Step<T, T> asyncStep(Receiver<T> consumer, ExecutorService es) {
        return StepFactory.asyncStep(Consumer.noOp(), Step.lift(consumer.yield()), BiConsumer.noOp(), BiConsumer.noOp(), es);
    }

    public static <T> Step<T, T> asyncStep(Consumer<T> preHook, Receiver<T> consumer, Consumer<T> postHook, ExecutorService es) {
        return StepFactory.asyncStep(preHook, Step.lift(consumer.yield()), (i, o) -> postHook.consume(i), BiConsumer.noOp(), es);
    }

    public static <T> Step<T, T> asyncStep(Consumer<T> preHook, Receiver<T> consumer, Consumer<T> postHook, BiConsumer<T, Exception> errNotifier, ExecutorService es) {
        return StepFactory.asyncStep(preHook, Step.lift(consumer.yield()), (i, o) -> postHook.consume(i), errNotifier, es);
    }

    public static <T, R> Step<T, T> asyncStep(Executable<T, R> e) {
        return StepFactory.asyncStep(Consumer.noOp(), Step.lift(e), BiConsumer.noOp(), BiConsumer.noOp(), null);
    }

    public static <T, R> Step<T, T> asyncStep(Consumer<T> preHook, Executable<T, R> e, BiConsumer<T, R> postHook) {
        return StepFactory.asyncStep(preHook, Step.lift(e), postHook, BiConsumer.noOp(), null);
    }

    public static <T, R> Step<T, T> asyncStep(Consumer<T> preHook, Executable<T, R> e, BiConsumer<T, R> postHook, BiConsumer<T, Exception> errNotifier) {
        return StepFactory.asyncStep(preHook, Step.lift(e), postHook, errNotifier, null);
    }

    public static <T, R> Step<T, T> asyncStep(Executable<T, R> e, ExecutorService es) {
        return StepFactory.asyncStep(Consumer.noOp(), Step.lift(e), BiConsumer.noOp(), BiConsumer.noOp(), es);
    }

    public static <T, R> Step<T, T> asyncStep(Consumer<T> preHook, Executable<T, R> e, BiConsumer<T, R> postHook, ExecutorService es) {
        return StepFactory.asyncStep(preHook, Step.lift(e), postHook, BiConsumer.noOp(), es);
    }

    public static <T, R> Step<T, T> asyncStep(Consumer<T> preHook, Executable<T, R> e, BiConsumer<T, R> postHook, BiConsumer<T, Exception> errNotifier, ExecutorService es) {
        return StepFactory.asyncStep(preHook, Step.lift(e), postHook, errNotifier, es);
    }

    public static <T, R> Step<T, T> asyncStep(AbstractStep<T, T> step) {
        return StepFactory.asyncStep(Consumer.noOp(), step, BiConsumer.noOp(), BiConsumer.noOp(), null);
    }

    public static <T, R> Step<T, T> asyncStep(Consumer<T> preHook, AbstractStep<T, R> step, BiConsumer<T, R> postHook) {
        return StepFactory.asyncStep(preHook, step, postHook, BiConsumer.noOp(), null);
    }

    public static <T, R> Step<T, T> asyncStep(Consumer<T> preHook, AbstractStep<T, R> step, BiConsumer<T, R> postHook, BiConsumer<T, Exception> errNotifier) {
        return StepFactory.asyncStep(preHook, step, postHook, errNotifier, null);
    }

    public static <T, R> Step<T, T> asyncStep(AbstractStep<T, R> step, ExecutorService es) {
        return StepFactory.asyncStep(Consumer.noOp(), step, BiConsumer.noOp(), BiConsumer.noOp(), es);
    }

    public static <T, R> Step<T, T> asyncStep(Consumer<T> preHook, AbstractStep<T, R> step, BiConsumer<T, R> postHook, ExecutorService es) {
        return StepFactory.asyncStep(preHook, step, postHook, BiConsumer.noOp(), es);
    }

    public static <T, R> Step<T, T> asyncStep(Consumer<T> preHook, AbstractStep<T, R> step, BiConsumer<T, R> postHook, BiConsumer<T, Exception> errNotifier, ExecutorService es) {
        return new AsyncStep<T, R>(preHook, step, postHook, errNotifier, es);
    }

    public static <T, R> AsyncStepBuilder<T, R> completableAsyncStep(Executable<T, R> executable) {
        return StepFactory.completableAsyncStep(Step.lift(executable), null);
    }

    public static <T, R> AsyncStepBuilder<T, R> completableAsyncStep(Executable<T, R> executable, ExecutorService es) {
        return StepFactory.completableAsyncStep(Step.lift(executable), es);
    }

    public static <T, R> AsyncStepBuilder<T, R> completableAsyncStep(AbstractStep<T, R> step) {
        return StepFactory.completableAsyncStep(step, null);
    }

    public static <T, R> AsyncStepBuilder<T, R> completableAsyncStep(AbstractStep<T, R> step, ExecutorService es) {
        return new AsyncStepBuilder<T, R>(step, es);
    }

    public static <I, T> AsyncCompletable<I, T, T> obtainCompletable(String key, Class<T> type) throws ClassNotFoundException {
        TypeClass cType = new TypeClass<Future<ExecutionResult<T>>>(){};
        return new AsyncCompletable(key, cType.getRawType(), BiExecutable.second());
    }

    public static <I, T, R> AsyncCompletable<I, T, R> accumulateCompletable(String key, Class<T> type, BiExecutable<I, T, R> accumulator) throws ClassNotFoundException {
        TypeClass cType = new TypeClass<Future<ExecutionResult<T>>>(){};
        return new AsyncCompletable<I, T, R>(key, cType.getRawType(), accumulator);
    }

    public static <T> Step<T, T> breakIf(Condition<T> condition, Exception error) {
        return StepFactory.breakIf(null, condition, x -> error);
    }

    public static <T> Step<T, T> breakIf(String name, Condition<T> condition, Exception error) {
        return StepFactory.breakIf(name, condition, x -> error);
    }

    public static <T, X extends Exception> Step<T, T> breakIf(Condition<T> condition, Function<T, X> errorF) {
        return StepFactory.breakIf(null, condition, errorF);
    }

    public static <T, X extends Exception> Step<T, T> breakIf(String name, Condition<T> condition, Function<T, X> errorF) {
        return new GuardStep<T>(name, condition.negate(), errorF);
    }

    public static <T> Step<T, T> continueIf(Condition<T> condition, String errorMessage) {
        return StepFactory.continueIf(null, condition, x -> errorMessage);
    }

    public static <T> Step<T, T> continueIf(String name, Condition<T> condition, String errorMessage) {
        return StepFactory.continueIf(name, condition, x -> errorMessage);
    }

    public static <T> Step<T, T> continueIf(Condition<T> condition, Function<T, String> errorF) {
        return StepFactory.continueIf(null, condition, errorF);
    }

    public static <T> Step<T, T> continueIf(String name, Condition<T> condition, Function<T, String> errorF) {
        return new GuardStep<T>(name, condition, errorF.andThen(FlowBreakException::new));
    }

    public static <T> Step<T, T> executeIf(Condition<T> condition, Executable<T, T> satisfyStep) {
        return StepFactory.executeIf(condition, Step.lift(satisfyStep));
    }

    public static <T> Step<T, T> executeIf(String name, Condition<T> condition, Executable<T, T> satisfyStep) {
        return StepFactory.executeIf(name, condition, Step.lift(name, satisfyStep));
    }

    public static <T> Step<T, T> executeIf(Condition<T> condition, AbstractStep<T, T> satisfyStep) {
        return StepFactory.executeIf(null, condition, satisfyStep);
    }

    public static <T> Step<T, T> executeIf(String name, Condition<T> condition, AbstractStep<T, T> satisfyStep) {
        return new BranchStep<T>(name, condition, satisfyStep);
    }

    public static ConditionalStepBuilder newConditionalStep(String name) {
        return new ConditionalStepBuilder(name);
    }

    public static ComparableStepBuilder newComparableStep(String name) {
        return new ComparableStepBuilder(name);
    }

    public static <T, R> RetryableStep<T, R> retryableStep(Executable<T, R> executable, RetryContext retryContext) {
        return StepFactory.retryableStep(Step.lift(executable), retryContext);
    }

    public static <T, R> RetryableStep<T, R> retryableStep(AbstractStep<T, R> step, RetryContext retryContext) {
        Objects.requireNonNull(retryContext);
        return new RetryableStep<T, R>(step, retryContext);
    }

    public static <T, R> UnsafeStepBuilder<T, R> unsafeStep(Executable<T, R> executable) {
        return StepFactory.unsafeStep(Step.lift("unsafe", executable));
    }

    public static <T, R> UnsafeStepBuilder<T, R> unsafeStep(String name, Executable<T, R> executable) {
        return StepFactory.unsafeStep(Step.lift(name, executable));
    }

    public static <T, R> UnsafeStepBuilder<T, R> unsafeStep(AbstractStep<T, R> step) {
        return new UnsafeStepBuilder<T, R>(step);
    }

    public static RepeatableStepBuilder repeatableStep(String name) {
        return new RepeatableStepBuilder(name);
    }

    public static SerialStepBuilder newSerialStep(String name) {
        return new SerialStepBuilder(name);
    }

    public static ParallelStepBuilder newParallelStep(String name) {
        return StepFactory.newParallelStep(name, Runtime.getRuntime().availableProcessors());
    }

    public static ParallelStepBuilder newParallelStep(String name, int threads) {
        return new ParallelStepBuilder(name, ThreadPoolFactory.create(threads));
    }

    public static ParallelStepBuilder newParallelStep(String name, ExecutorService es) {
        return new ParallelStepBuilder(name, ThreadPoolFactory.provided(es));
    }

    public static IteratorStepBuilder newIteratorStep(String name) {
        return new IteratorStepBuilder(name);
    }

    public static Spliterator.SpliteratorBuilder newSpliteratorStep(String name) {
        return new Spliterator.SpliteratorBuilder(name);
    }
}

