/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.ExecutionResult;
import com.simplj.lambda.function.Consumer;
import com.simplj.lambda.function.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

final class ThreadPool {
    private final boolean isSelfCreated;
    private final ExecutorService executorService;

    ThreadPool(boolean isSelfCreated, ExecutorService executorService) {
        this.isSelfCreated = isSelfCreated;
        this.executorService = executorService;
    }

    static <O> List<ExecutionResult<O>> waitForCompletion(Queue<Future<ExecutionResult<O>>> q, Function<ExecutionResult<O>, ExecutionResult<O>> ctxMerger, Consumer<String> logger) {
        ArrayList<ExecutionResult<O>> res = new ArrayList<ExecutionResult<O>>(q.size());
        while (!q.isEmpty()) {
            Future<ExecutionResult<O>> future = q.poll();
            if (future.isDone()) {
                try {
                    res.add((ExecutionResult<O>)ctxMerger.apply(future.get()));
                }
                catch (Exception ex) {
                    logger.consume((Object)("One of the parallel task failed! Error: " + ex.getMessage()));
                }
                continue;
            }
            q.add(future);
        }
        return res;
    }

    final ExecutorService getExecutorService() {
        return this.executorService;
    }

    final void dispose(Consumer<String> logger) {
        if (this.isSelfCreated) {
            try {
                this.executorService.shutdown();
                boolean flag = this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
                logger.consume((Object)("sjf-thread-pool terminated " + (flag ? "successfully" : "abruptly")));
            }
            catch (InterruptedException e) {
                logger.consume((Object)"Error occurred while waiting for sjf-thread-pool termination!");
                e.printStackTrace();
            }
        }
    }
}

