/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.steps.ThreadPool;
import com.simplj.lambda.function.Producer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

final class ThreadPoolFactory {
    private final boolean isSelfCreated;
    private final Producer<ExecutorService> executorF;

    private ThreadPoolFactory(boolean isSelfCreated, Producer<ExecutorService> executorF) {
        this.isSelfCreated = isSelfCreated;
        this.executorF = executorF;
    }

    static ThreadPoolFactory create(int threads) {
        return new ThreadPoolFactory(true, (Producer<ExecutorService>)((Producer)() -> Executors.newFixedThreadPool(threads)));
    }

    static ThreadPoolFactory provided(ExecutorService es) {
        return new ThreadPoolFactory(false, (Producer<ExecutorService>)Producer.defer((Object)es));
    }

    final ThreadPool newThreadPool() {
        return new ThreadPool(this.isSelfCreated, (ExecutorService)this.executorF.produce());
    }
}

