/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.flows.steps;

import com.simplj.flows.core.AbstractStep;
import com.simplj.flows.core.ExecutionContext;
import com.simplj.flows.core.ExecutionResult;
import com.simplj.flows.core.Input;
import com.simplj.flows.steps.Step;
import com.simplj.lambda.executable.BiExecutable;
import com.simplj.lambda.function.BiConsumer;
import com.simplj.lambda.function.BiFunction;
import com.simplj.lambda.function.Condition;
import com.simplj.lambda.function.Function;
import com.simplj.lambda.util.Either;
import java.util.Optional;

public final class UnsafeStep<I, O>
extends Step<I, O> {
    private final AbstractStep<I, O> unsafeStep;
    private final Type type;
    private final Condition<Exception> recoveryCondition;
    private final BiExecutable<I, Exception, O> recoveryStep;
    private final BiConsumer<I, Either<Exception, O>> finallyConstruct;
    private final BiFunction<I, Exception, Exception> errMapper;

    UnsafeStep(String name, AbstractStep<I, O> unsafeStep, Condition<Exception> recoveryCondition, BiExecutable<I, Exception, O> recoveryX) {
        this(name, unsafeStep, Type.RECOVERY, recoveryCondition, recoveryX, null, null);
    }

    UnsafeStep(String name, AbstractStep<I, O> unsafeStep, BiConsumer<I, Either<Exception, O>> finallyC) {
        this(name, unsafeStep, Type.FINALLY, null, null, finallyC, null);
    }

    UnsafeStep(String name, AbstractStep<I, O> unsafeStep, BiFunction<I, Exception, Exception> errorMapper) {
        this(name, unsafeStep, Type.MAP_ERROR, null, null, null, errorMapper);
    }

    private UnsafeStep(String name, AbstractStep<I, O> unsafeStep, Type type, Condition<Exception> recoveryCondition, BiExecutable<I, Exception, O> recoveryX, BiConsumer<I, Either<Exception, O>> finallyC, BiFunction<I, Exception, Exception> errorMapper) {
        super(Optional.ofNullable(name).orElse(UnsafeStep.name(unsafeStep)));
        this.unsafeStep = unsafeStep;
        this.type = type;
        this.recoveryCondition = recoveryCondition;
        this.recoveryStep = recoveryX;
        this.finallyConstruct = finallyC;
        this.errMapper = errorMapper;
    }

    @Override
    protected final ExecutionResult<O> execute(ExecutionContext ctx, I input) {
        ExecutionResult<O> res = UnsafeStep.execute(this.unsafeStep, input, ctx);
        switch (this.type) {
            case RECOVERY: {
                if (res.isSuccess()) break;
                res = this.executeRecovery(ctx, input, res);
                break;
            }
            case FINALLY: {
                this.executeFinally(ctx, input, res);
                break;
            }
            case MAP_ERROR: {
                res = res.mapError((Function<Exception, Exception>)this.errMapper.ap(input));
            }
        }
        return res;
    }

    private void executeFinally(ExecutionContext ctx, I input, ExecutionResult<O> res) {
        long s = System.currentTimeMillis();
        this.finallyConstruct.consume(input, res.resultOrError());
        if (res.isSuccess()) {
            UnsafeStep.addFrame(ctx, UnsafeStep.stepFrame(this.name() + "-success", "applied for SUCCESS!", System.currentTimeMillis() - s));
        } else {
            UnsafeStep.addFrame(ctx, UnsafeStep.errStepFrame(this.name() + "-error", Input.of("applied for ERROR!"), res.error(), System.currentTimeMillis() - s));
        }
    }

    private ExecutionResult<O> executeRecovery(ExecutionContext ctx, I input, ExecutionResult<O> res) {
        long s = System.currentTimeMillis();
        boolean flag = this.recoveryCondition.evaluate((Object)res.error());
        if (flag) {
            Input inp = Input.of(input, res.error());
            try {
                Object r = this.recoveryStep.execute(input, (Object)res.error());
                res = UnsafeStep.success(r, UnsafeStep.addFrame(ctx, UnsafeStep.stepFrame(this.name() + "-recovery", inp, r, System.currentTimeMillis() - s)));
            }
            catch (Exception ex) {
                res = UnsafeStep.error(ex, UnsafeStep.addFrame(ctx, UnsafeStep.errStepFrame(this.name() + "-recovery-error", inp, ex, System.currentTimeMillis() - s)));
            }
        }
        return res;
    }

    private static enum Type {
        RECOVERY,
        FINALLY,
        MAP_ERROR;

    }
}

