/*
 * Decompiled with CFR 0.152.
 */
package com.simplyti.service.builder.di.guice;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.inject.Module;
import com.simplyti.service.ServerConfig;
import com.simplyti.service.Service;
import com.simplyti.service.api.builder.ApiProvider;
import com.simplyti.service.builder.di.guice.ServiceBuilder;
import com.simplyti.service.fileserver.DirectoryResolver;
import com.simplyti.service.fileserver.FileServeConfiguration;
import io.netty.channel.EventLoopGroup;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4J2LoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public abstract class AbstractServiceBuilder<T extends Service<?>>
implements ServiceBuilder<T> {
    private static final int DEFAULT_BLOCKING_THREAD_POOL = 500;
    private static final int DEFAULT_INSECURE_PORT = 8080;
    private static final int DEFAULT_SECURE_PORT = 8443;
    private final Class<T> serviceClass;
    private String usingLogger;
    private Collection<Class<? extends ApiProvider>> apiClasses;
    private Collection<ApiProvider> apiProviders;
    private Collection<Module> modules;
    private Integer blockingThreadPool;
    private Integer insecuredPort;
    private Integer securedPort;
    private String name;
    private FileServeConfiguration fileServe;
    private EventLoopGroup eventLoopGroup;
    private boolean verbose;

    public AbstractServiceBuilder(Class<T> serviceClass) {
        this.serviceClass = serviceClass;
    }

    @Override
    public T build() {
        ServerConfig config = new ServerConfig(this.name, ((Integer)MoreObjects.firstNonNull((Object)this.blockingThreadPool, (Object)500)).intValue(), ((Integer)MoreObjects.firstNonNull((Object)this.insecuredPort, (Object)8080)).intValue(), ((Integer)MoreObjects.firstNonNull((Object)this.securedPort, (Object)8443)).intValue(), this.fileServe, this.eventLoopGroup != null, this.verbose);
        Stream<Module> additinalModules = Optional.ofNullable(this.modules).map(Collection::stream).orElse(Stream.empty());
        return this.build0(config, this.serviceClass, additinalModules, (Collection)MoreObjects.firstNonNull(this.apiClasses, Collections.emptySet()), (Collection)MoreObjects.firstNonNull(this.apiProviders, Collections.emptySet()), this.eventLoopGroup);
    }

    protected abstract T build0(ServerConfig var1, Class<T> var2, Stream<Module> var3, Collection<Class<? extends ApiProvider>> var4, Collection<ApiProvider> var5, EventLoopGroup var6);

    @Override
    public ServiceBuilder<T> withBlockingThreadPoolSize(int blockingThreadPool) {
        this.blockingThreadPool = blockingThreadPool;
        return this;
    }

    @Override
    public ServiceBuilder<T> insecuredPort(int port) {
        this.insecuredPort = port;
        return this;
    }

    @Override
    public ServiceBuilder<T> disableInsecurePort() {
        this.insecuredPort = -1;
        return this;
    }

    @Override
    public ServiceBuilder<T> disableSecuredPort() {
        this.securedPort = -1;
        return this;
    }

    @Override
    public ServiceBuilder<T> securedPort(int port) {
        this.securedPort = port;
        return this;
    }

    @Override
    public ServiceBuilder<T> withLog4J2Logger() {
        Preconditions.checkState((this.usingLogger == null ? 1 : 0) != 0, (Object)String.format("Logger already stablished to %s", this.usingLogger));
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Log4J2LoggerFactory.INSTANCE);
        this.usingLogger = "log4j2";
        return this;
    }

    @Override
    public ServiceBuilder<T> withSlf4jLogger() {
        Preconditions.checkState((this.usingLogger == null ? 1 : 0) != 0, (Object)String.format("Logger already stablished to %s", this.usingLogger));
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
        this.usingLogger = "slf4j";
        return this;
    }

    @Override
    public ServiceBuilder<T> withApi(Class<? extends ApiProvider> apiClass) {
        if (this.apiClasses == null) {
            this.apiClasses = new HashSet<Class<? extends ApiProvider>>();
        }
        this.apiClasses.add(apiClass);
        return this;
    }

    @Override
    public ServiceBuilder<T> withApi(ApiProvider provider) {
        if (this.apiProviders == null) {
            this.apiProviders = new HashSet<ApiProvider>();
        }
        this.apiProviders.add(provider);
        return this;
    }

    @Override
    public ServiceBuilder<T> withModule(Module module) {
        if (this.modules == null) {
            this.modules = new HashSet<Module>();
        }
        this.modules.add(module);
        return this;
    }

    @Override
    public ServiceBuilder<T> withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ServiceBuilder<T> withModule(Class<? extends Module> module) {
        try {
            return this.withModule(module.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ServiceBuilder<T> fileServe(String path, String directory) {
        this.fileServe = new FileServeConfiguration(Pattern.compile("^" + path + "/(.*)$"), DirectoryResolver.literal((String)directory));
        return this;
    }

    @Override
    public ServiceBuilder<T> eventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    @Override
    public ServiceBuilder<T> verbose() {
        this.verbose = true;
        return this;
    }
}

