/*
 * Decompiled with CFR 0.152.
 */
package com.simplyti.service.builder.di.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.simplyti.service.DefaultService;
import com.simplyti.service.DefaultStartStopMonitor;
import com.simplyti.service.ServerConfig;
import com.simplyti.service.Service;
import com.simplyti.service.StartStopMonitor;
import com.simplyti.service.api.ApiResolver;
import com.simplyti.service.api.DefaultApiResolver;
import com.simplyti.service.api.builder.ApiProvider;
import com.simplyti.service.api.builder.di.InstanceProvider;
import com.simplyti.service.api.filter.HttpRequestFilter;
import com.simplyti.service.api.filter.HttpResponseFilter;
import com.simplyti.service.api.filter.OperationInboundFilter;
import com.simplyti.service.api.health.HealthApi;
import com.simplyti.service.builder.di.EventLoopGroupProvider;
import com.simplyti.service.builder.di.ExecutorServiceProvider;
import com.simplyti.service.builder.di.SslContextProvider;
import com.simplyti.service.builder.di.StartStopLoop;
import com.simplyti.service.builder.di.StartStopLoopProvider;
import com.simplyti.service.builder.di.guice.GuiceInstanceProvider;
import com.simplyti.service.channel.ClientChannelGroup;
import com.simplyti.service.channel.DefaultServiceChannelInitializer;
import com.simplyti.service.channel.EntryChannelInit;
import com.simplyti.service.channel.ServerChannelFactoryProvider;
import com.simplyti.service.channel.ServiceChannelInitializer;
import com.simplyti.service.channel.handler.DefaultBackendFullRequestHandler;
import com.simplyti.service.channel.handler.DefaultBackendRequestHandler;
import com.simplyti.service.channel.handler.FileServeHandler;
import com.simplyti.service.channel.handler.ServerHeadersHandler;
import com.simplyti.service.channel.handler.inits.ApiRequestHandlerInit;
import com.simplyti.service.channel.handler.inits.DefaultBackendHandlerInit;
import com.simplyti.service.channel.handler.inits.FileServerHandlerInit;
import com.simplyti.service.channel.handler.inits.HandlerInit;
import com.simplyti.service.exception.ExceptionHandler;
import com.simplyti.service.hook.ServerStartHook;
import com.simplyti.service.hook.ServerStopHook;
import com.simplyti.service.json.DslJsonModule;
import com.simplyti.service.sse.ServerSentEventEncoder;
import com.simplyti.service.ssl.DefaultServerCertificateProvider;
import com.simplyti.service.ssl.DefaultSslHandlerFactory;
import com.simplyti.service.ssl.IoCKeyManager;
import com.simplyti.service.ssl.IoCKeyManagerFactory;
import com.simplyti.service.ssl.IoCKeyManagerFactorySpi;
import com.simplyti.service.ssl.IoCSecurityProvider;
import com.simplyti.service.ssl.IoCTrustManager;
import com.simplyti.service.ssl.IoCTrustManagerFactory;
import com.simplyti.service.ssl.IoCTrustManagerFactorySpi;
import com.simplyti.service.ssl.ServerCertificateProvider;
import com.simplyti.service.ssl.SslHandlerFactory;
import com.simplyti.service.sync.DefaultSyncTaskSubmitter;
import com.simplyti.service.sync.SyncTaskSubmitter;
import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.handler.ssl.SslContext;
import java.security.Provider;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import javax.inject.Singleton;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;

public class ServiceModule
extends AbstractModule {
    private final ServerConfig config;
    private final Collection<Class<? extends ApiProvider>> apiClasses;
    private final EventLoopGroup eventLoopGroup;
    private final Collection<ApiProvider> apiProviders;

    public ServiceModule(ServerConfig config, Collection<Class<? extends ApiProvider>> apiClasses, Collection<ApiProvider> apiProviders, EventLoopGroup eventLoopGroup) {
        this.config = config;
        this.apiClasses = apiClasses;
        this.apiProviders = apiProviders;
        this.eventLoopGroup = eventLoopGroup;
    }

    protected void configure() {
        this.install((Module)new DslJsonModule());
        this.bind(ServerConfig.class).toInstance((Object)this.config);
        this.bind(InstanceProvider.class).to(GuiceInstanceProvider.class).in(Singleton.class);
        this.bindEventLoop();
        this.bind(EventLoop.class).annotatedWith(StartStopLoop.class).toProvider(StartStopLoopProvider.class).in(Singleton.class);
        this.bind(StartStopMonitor.class).to(DefaultStartStopMonitor.class).in(Singleton.class);
        this.bind((TypeLiteral)new TypeLiteral<ChannelFactory<ServerChannel>>(){}).toProvider(ServerChannelFactoryProvider.class).in(Singleton.class);
        this.bind(ClientChannelGroup.class).in(Singleton.class);
        this.bind(ServiceChannelInitializer.class).to(DefaultServiceChannelInitializer.class).in(Singleton.class);
        this.bind(ServerHeadersHandler.class).in(Singleton.class);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), EntryChannelInit.class);
        this.bind(new TypeLiteral<Service<?>>(){}).to(DefaultService.class).in(Singleton.class);
        Multibinder.newSetBinder((Binder)this.binder(), HandlerInit.class).addBinding().to(DefaultBackendHandlerInit.class).in(Singleton.class);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), DefaultBackendFullRequestHandler.class);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), DefaultBackendRequestHandler.class);
        this.bindFileServer();
        this.bind(ServerSentEventEncoder.class).in(Singleton.class);
        this.bind(ExceptionHandler.class).in(Singleton.class);
        this.bind(ExecutorService.class).toProvider(ExecutorServiceProvider.class).in(Singleton.class);
        this.bind(SyncTaskSubmitter.class).to(DefaultSyncTaskSubmitter.class).in(Singleton.class);
        this.bind(ApiResolver.class).to(DefaultApiResolver.class).in(Singleton.class);
        Multibinder.newSetBinder((Binder)this.binder(), HandlerInit.class).addBinding().to(ApiRequestHandlerInit.class).in(Singleton.class);
        this.bindApis((Multibinder<ApiProvider>)Multibinder.newSetBinder((Binder)this.binder(), ApiProvider.class));
        Multibinder.newSetBinder((Binder)this.binder(), HttpRequestFilter.class);
        Multibinder.newSetBinder((Binder)this.binder(), OperationInboundFilter.class);
        Multibinder.newSetBinder((Binder)this.binder(), HttpResponseFilter.class);
        Multibinder.newSetBinder((Binder)this.binder(), ServerStartHook.class);
        Multibinder.newSetBinder((Binder)this.binder(), ServerStopHook.class);
        this.bind(Provider.class).to(IoCSecurityProvider.class).in(Singleton.class);
        this.bind(KeyManager.class).to(IoCKeyManager.class).in(Singleton.class);
        this.bind(KeyManagerFactorySpi.class).to(IoCKeyManagerFactorySpi.class).in(Singleton.class);
        this.bind(KeyManagerFactory.class).to(IoCKeyManagerFactory.class).in(Singleton.class);
        this.bind(TrustManager.class).to(IoCTrustManager.class).in(Singleton.class);
        this.bind(TrustManagerFactorySpi.class).to(IoCTrustManagerFactorySpi.class).in(Singleton.class);
        this.bind(TrustManagerFactory.class).to(IoCTrustManagerFactory.class).in(Singleton.class);
        this.bind(SslContext.class).toProvider(SslContextProvider.class).in(Singleton.class);
        this.bind(SslHandlerFactory.class).to(DefaultSslHandlerFactory.class).in(Singleton.class);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), DefaultServerCertificateProvider.class);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), ServerCertificateProvider.class);
    }

    private void bindFileServer() {
        if (this.config.fileServer() != null) {
            Multibinder.newSetBinder((Binder)this.binder(), HandlerInit.class).addBinding().to(FileServerHandlerInit.class).in(Singleton.class);
            this.bind(FileServeHandler.class).in(Singleton.class);
        }
    }

    private void bindEventLoop() {
        if (this.eventLoopGroup == null) {
            this.bind(EventLoopGroup.class).toProvider(EventLoopGroupProvider.class).in(Singleton.class);
        } else {
            this.bind(EventLoopGroup.class).toInstance((Object)this.eventLoopGroup);
        }
    }

    private void bindApis(Multibinder<ApiProvider> apiBinder) {
        this.apiProviders.forEach(provider -> apiBinder.addBinding().toInstance(provider));
        Stream.concat(this.apiClasses.stream(), Stream.of(HealthApi.class)).forEach(apiClass -> apiBinder.addBinding().to(apiClass).in(Singleton.class));
    }
}

