/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd;

import com.simsilica.mathd.Vec3d;
import java.io.Serializable;

public final class AaBBox
implements Cloneable,
Serializable {
    static final long serialVersionUID = 42L;
    private final Vec3d min = new Vec3d();
    private final Vec3d max = new Vec3d();

    public AaBBox() {
    }

    public AaBBox(double radius) {
        this.setForRadius(new Vec3d(), radius);
    }

    public AaBBox(Vec3d center, double radius) {
        this.setForRadius(center, radius);
    }

    public AaBBox(Vec3d min, Vec3d max) {
        this.set(min, max);
    }

    public AaBBox clone() {
        return new AaBBox(this.min.clone(), this.max.clone());
    }

    public void set(Vec3d min, Vec3d max) {
        this.min.set(min);
        this.max.set(max);
    }

    public void setForRadius(Vec3d center, double radius) {
        this.min.set(center.x - radius, center.y - radius, center.z - radius);
        this.max.set(center.x + radius, center.y + radius, center.z + radius);
    }

    public void setForRadius(double xCenter, double yCenter, double zCenter, double radius) {
        this.min.set(xCenter - radius, yCenter - radius, zCenter - radius);
        this.max.set(xCenter + radius, yCenter + radius, zCenter + radius);
    }

    public void setForExtents(Vec3d center, Vec3d extents) {
        this.min.set(center.x, center.y, center.z);
        this.min.subtractLocal(extents);
        this.max.set(center.x, center.y, center.z);
        this.max.addLocal(extents);
    }

    public Vec3d getExtents() {
        return this.getExtents(null);
    }

    public Vec3d getExtents(Vec3d target) {
        if (target == null) {
            target = new Vec3d();
        }
        target.set(this.max);
        target.subtractLocal(this.min);
        target.multLocal(0.5);
        return target;
    }

    public void setCenter(Vec3d center) {
        double x = center.x - (this.max.x + this.min.x) * 0.5;
        double y = center.y - (this.max.y + this.min.y) * 0.5;
        double z = center.z - (this.max.z + this.min.z) * 0.5;
        this.min.addLocal(x, y, z);
        this.max.addLocal(x, y, z);
    }

    public void setCenter(double xCenter, double yCenter, double zCenter) {
        double x = xCenter - (this.max.x + this.min.x) * 0.5;
        double y = yCenter - (this.max.y + this.min.y) * 0.5;
        double z = zCenter - (this.max.z + this.min.z) * 0.5;
        this.min.addLocal(x, y, z);
        this.max.addLocal(x, y, z);
    }

    public Vec3d getCenter() {
        return this.getCenter(null);
    }

    public Vec3d getCenter(Vec3d target) {
        if (target == null) {
            target = new Vec3d();
        }
        target.set(this.min);
        target.addLocal(this.max);
        target.multLocal(0.5);
        return target;
    }

    public void setMin(Vec3d min) {
        this.min.set(min);
    }

    public Vec3d getMin() {
        return this.min;
    }

    public void setMax(Vec3d max) {
        this.max.set(max);
    }

    public Vec3d getMax() {
        return this.max;
    }

    public static void main(String ... args) {
        AaBBox box = new AaBBox(new Vec3d(5.0, 5.0, 0.0), 2.0);
        System.out.println("box:" + box + "   center:" + box.getCenter() + "  extents:" + box.getExtents());
        box.setCenter(new Vec3d(7.0, 2.0, 1.0));
        System.out.println("box:" + box + "   center:" + box.getCenter() + "  extents:" + box.getExtents());
    }

    public String toString() {
        return this.getClass().getName() + "[min=" + this.min + ", max=" + this.max + "]";
    }
}

