/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd.filter;

import com.simsilica.mathd.filter.Filterd;

public class SimpleMovingMean
implements Filterd {
    private int filterSize;
    private double[] values;
    private int current;
    private double total;
    private int count;

    public SimpleMovingMean(int filterSize) {
        this.filterSize = filterSize;
        this.values = new double[filterSize];
    }

    @Override
    public void addValue(double d) {
        this.total -= this.values[this.current];
        this.values[this.current] = d;
        this.total += d;
        if (this.count < this.filterSize) {
            ++this.count;
        }
        ++this.current;
        if (this.current >= this.filterSize) {
            this.current -= this.filterSize;
        }
    }

    @Override
    public double getFilteredValue() {
        return this.count == 0 ? 0.0 : this.total / (double)this.count;
    }
}

