/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.base;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.es.base.ComponentHandler;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MapComponentHandler<T extends EntityComponent>
implements ComponentHandler<T> {
    private Map<EntityId, T> components = new ConcurrentHashMap<EntityId, T>();

    @Override
    public void setComponent(EntityId entityId, T component) {
        this.components.put(entityId, component);
    }

    @Override
    public boolean removeComponent(EntityId entityId) {
        return this.components.remove(entityId) != null;
    }

    @Override
    public T getComponent(EntityId entityId) {
        return (T)((EntityComponent)this.components.get(entityId));
    }

    @Override
    public Set<EntityId> getEntities() {
        return this.components.keySet();
    }

    @Override
    public Set<EntityId> getEntities(ComponentFilter filter) {
        if (filter == null) {
            return this.components.keySet();
        }
        HashSet<EntityId> results = new HashSet<EntityId>();
        for (Map.Entry<EntityId, T> e : this.components.entrySet()) {
            if (!filter.evaluate((EntityComponent)e.getValue())) continue;
            results.add(e.getKey());
        }
        return results;
    }

    @Override
    public EntityId findEntity(ComponentFilter filter) {
        for (Map.Entry<EntityId, T> e : this.components.entrySet()) {
            if (filter != null && !filter.evaluate((EntityComponent)e.getValue())) continue;
            return e.getKey();
        }
        return null;
    }
}

