/*
 * Decompiled with CFR 0.152.
 */
package com.simtechdata.sceneonefx;

import com.simtechdata.sceneonefx.SceneOne;
import com.simtechdata.sceneonefx.Stages;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.jetbrains.annotations.NotNull;

public class SceneObject {
    private Stage stage;
    private Scene scene;
    private final String sceneId;
    private final boolean centered;
    private boolean hasShown = false;
    private double posX;
    private double posY;
    private double splitFactorX;
    private double splitFactorY;
    private final double width;
    private final double height;
    private Size size;
    private boolean hidden = false;
    private final ChangeListener<? super Boolean> lostFocusListener = (observable, oldValue, newValue) -> {
        if (!newValue.booleanValue()) {
            this.hidden = true;
            Platform.runLater(() -> this.stage.hide());
        }
    };

    public SceneObject(@NotNull SceneOne.Builder build) {
        this.sceneId = build.sceneId;
        this.scene = build.scene;
        this.centered = build.centered;
        this.posX = build.posX;
        this.posY = build.posY;
        this.splitFactorX = build.splitFactorX;
        this.splitFactorY = build.splitFactorY;
        this.stage = build.stage;
        this.width = build.width;
        this.height = build.height;
        if (this.stage == null) {
            this.stage = new Stage();
        }
        if (this.scene == null) {
            this.scene = new Scene(build.parent);
        }
        this.stage.setScene(this.scene);
        this.stage.setTitle(build.title);
        this.scene.getStylesheets().addAll(build.styleSheets);
        if (build.style != null) {
            this.stage.initStyle(build.style);
        }
        if (build.modality != null) {
            this.stage.initModality(build.modality);
        }
        if (build.onShownEventHandler != null) {
            this.stage.setOnShown(build.onShownEventHandler);
        }
        if (build.onShowingEventHandler != null) {
            this.stage.setOnShowing(build.onShowingEventHandler);
        }
        if (build.onHiddenEventHandler != null) {
            this.stage.setOnHidden(build.onHiddenEventHandler);
        }
        if (build.onHidingEventHandler != null) {
            this.stage.setOnHiding(build.onHidingEventHandler);
        }
        if (build.onCloseEventHandler != null) {
            this.stage.setOnCloseRequest(build.onCloseEventHandler);
        }
        if (build.onWindowCloseEventHandler != null) {
            this.scene.getWindow().setOnCloseRequest(build.onWindowCloseEventHandler);
        }
        if (build.keyPressedEventHandler != null) {
            this.setOnKeyPressed(build.keyPressedEventHandler);
        }
        if (build.keyReleasedEventHandler != null) {
            this.setOnKeyReleased(build.keyReleasedEventHandler);
        }
        if (build.owner != null) {
            this.stage.initOwner((Window)build.owner);
        }
        this.stage.setAlwaysOnTop(build.alwaysOnTop);
        if (build.width > 0.0 && build.height > 0.0) {
            this.size = new Size(this.stage, build.width, build.height);
        } else if (build.width > 0.0) {
            this.size = new Size(this.stage, SceneOne.DIMENSION.WIDTH, build.width);
        } else if (build.height > 0.0) {
            this.size = new Size(this.stage, SceneOne.DIMENSION.HEIGHT, build.height);
        }
        if (build.hideOnLostFocus) {
            this.stage.focusedProperty().addListener(this.lostFocusListener);
        } else if (build.lostFocusListener != null) {
            this.stage.focusedProperty().addListener(build.lostFocusListener);
        }
        this.stage.setFullScreen(build.fullScreen);
    }

    public void setOnKeyPressedEvent(EventHandler<? super KeyEvent> keyPressedEventHandler) {
        this.scene.setOnKeyPressed(keyPressedEventHandler);
    }

    public void setOnKeyReleasedEvent(EventHandler<? super KeyEvent> keyReleasedEventHandler) {
        this.scene.setOnKeyReleased(keyReleasedEventHandler);
    }

    public void setOnShowingEvent(EventHandler<WindowEvent> onShowingEventHandler) {
        this.stage.setOnShowing(onShowingEventHandler);
    }

    public void setOnShownEvent(EventHandler<WindowEvent> onShownEventHandler) {
        this.stage.setOnShown(onShownEventHandler);
    }

    public void setOnHidingEvent(EventHandler<WindowEvent> onHidingEventHandler) {
        this.stage.setOnHiding(onHidingEventHandler);
    }

    public void setOnHiddenEvent(EventHandler<WindowEvent> onHiddenEventHandler) {
        this.stage.setOnHidden(onHiddenEventHandler);
    }

    public void setOnCloseEvent(EventHandler<WindowEvent> onCloseEventHandler) {
        this.stage.setOnCloseRequest(onCloseEventHandler);
    }

    public void setOnWindowCloseEvent(EventHandler<WindowEvent> onWindowCloseEventHandler) {
        this.scene.getWindow().setOnCloseRequest(onWindowCloseEventHandler);
    }

    public void setOnLostFocus(ChangeListener<? super Boolean> lostFocusListener) {
        this.stage.focusedProperty().removeListener(this.lostFocusListener);
        this.stage.focusedProperty().addListener(lostFocusListener);
    }

    public void setHideOnLostFocus(boolean hideOnLostFocus) {
        if (hideOnLostFocus) {
            this.stage.focusedProperty().addListener(this.lostFocusListener);
        } else {
            this.stage.focusedProperty().removeListener(this.lostFocusListener);
        }
    }

    private void findCenter() {
        double screenWidth = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        double screenHeight = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        this.posX = screenWidth / 2.0 - this.size.getWidth() / 2.0;
        this.posY = screenHeight / 2.0 - this.size.getHeight() / 2.0;
    }

    private void preProcess() {
        if (this.size != null) {
            if (this.splitFactorX > 0.0 && this.splitFactorY > 0.0) {
                double xSplit = this.size.getWidth() * this.splitFactorX;
                double ySplit = this.size.getHeight() * this.splitFactorY;
                this.stage.setX(this.posX - xSplit);
                this.stage.setY(this.posY - ySplit);
            } else if (this.splitFactorX > 0.0) {
                double xSplit = this.size.getWidth() * this.splitFactorX;
                this.stage.setX(this.posX - xSplit);
            } else if (this.splitFactorY > 0.0) {
                double ySplit = this.size.getHeight() * this.splitFactorY;
                this.stage.setY(this.posY - ySplit);
            }
        }
        if (this.posX > 0.0 && this.posY > 0.0) {
            this.stage.setX(this.posX);
            this.stage.setY(this.posY);
        }
    }

    public void reCenterScene() {
        new Thread(() -> {
            double sceneWidth = this.scene.getWidth();
            double sceneHeight = this.scene.getHeight();
            double screenWidth = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
            double screenHeight = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
            double posX = screenWidth - sceneWidth - 0.5 * (screenWidth - sceneWidth);
            double posY = screenHeight - sceneHeight - 0.5 * (screenHeight - sceneHeight);
            Platform.runLater(() -> {
                this.scene.getWindow().setX(posX);
                this.scene.getWindow().setY(posY);
            });
        }).start();
    }

    public void show() {
        this.stage.setScene(this.scene);
        Stages.showingScene(this.sceneId);
        if (this.hasShown) {
            this.reShow();
            return;
        }
        this.preProcess();
        this.stage.show();
        if (this.size == null) {
            this.stage.sizeToScene();
        }
        if (this.centered) {
            this.stage.centerOnScreen();
        }
        this.checkSplit();
        this.hasShown = true;
        this.addLastScene();
    }

    public void showAndWait() {
        this.stage.setScene(this.scene);
        Stages.showingScene(this.sceneId);
        this.preProcess();
        if (this.centered) {
            if (this.width < 0.0 || this.height < 0.0) {
                throw SceneObject.centerOnWaitError();
            }
            this.findCenter();
        }
        this.addLastScene();
        this.stage.showAndWait();
    }

    public void reShow() {
        if (this.hasShown) {
            this.stage.setScene(this.scene);
            Stages.showingScene(this.sceneId);
            if (this.centered) {
                this.stage.centerOnScreen();
            }
            this.stage.show();
            this.stage.toFront();
            this.addLastScene();
        }
    }

    private void addLastScene() {
        SceneOne.lastSceneShown.addLast(this.sceneId);
        if (SceneOne.lastSceneShown.size() > 2) {
            SceneOne.lastSceneShown.removeFirst();
        }
    }

    public void checkSplit() {
        if (this.splitFactorX > 0.0 && this.splitFactorY > 0.0) {
            double xSplit = this.size.getWidth() * this.splitFactorX;
            double ySplit = this.size.getHeight() * this.splitFactorY;
            this.stage.setX(this.posX - xSplit);
            this.stage.setY(this.posY - ySplit);
        } else if (this.splitFactorX > 0.0) {
            double xSplit = this.size.getWidth() * this.splitFactorX;
            this.stage.setX(this.posX - xSplit);
        } else if (this.splitFactorY > 0.0) {
            double ySplit = this.size.getHeight() * this.splitFactorY;
            this.stage.setY(this.posY - ySplit);
        }
    }

    public void showSplit(double X, double Y, double splitFactorX, double splitFactorY) {
        this.posX = X;
        this.posY = Y;
        this.splitFactorX = splitFactorX;
        this.splitFactorY = splitFactorY;
        this.show();
    }

    public void showSplitX(double X, double splitFactorX) {
        this.posX = X;
        this.splitFactorX = splitFactorX;
        this.splitFactorY = -1.0;
        this.show();
    }

    public void showSplitY(double Y, double splitFactorY) {
        this.posY = Y;
        this.splitFactorY = splitFactorY;
        this.splitFactorX = -1.0;
        this.show();
    }

    public void resize(double width, double height) {
        if (this.size == null) {
            this.size = new Size(this.stage, width, height);
        } else {
            this.size.set(width, height);
        }
        this.size.resize();
    }

    public void setPosition(double posX, double posY) {
        this.posX = posX;
        this.posY = posY;
        this.stage.setX(posX);
        this.stage.setY(posY);
    }

    public void setParent(Parent parent) {
        this.scene = new Scene(parent);
        this.stage.setScene(this.scene);
    }

    public void setScene(Scene scene) {
        this.scene = scene;
        this.stage.setScene(this.scene);
    }

    public void setTitle(String title) {
        this.stage.setTitle(title);
    }

    public void setWidth(double width) {
        if (this.size == null) {
            this.size = new Size(this.stage, SceneOne.DIMENSION.WIDTH, width);
        } else {
            this.size.setWidth(width);
        }
        this.size.resize();
    }

    public void setHeight(double height) {
        if (this.size == null) {
            this.size = new Size(this.stage, SceneOne.DIMENSION.HEIGHT, height);
        } else {
            this.size.setHeight(height);
        }
        this.size.resize();
    }

    public void setSize(double width, double height) {
        if (this.size == null) {
            this.size = new Size(this.stage, width, height);
        } else {
            this.size.setSize(width, height);
        }
        this.size.resize();
    }

    public void setOnKeyPressed(EventHandler<? super KeyEvent> keyPressedEventHandler) {
        if (keyPressedEventHandler != null) {
            this.scene.setOnKeyPressed(keyPressedEventHandler);
        }
    }

    public void setOnKeyReleased(EventHandler<? super KeyEvent> keyReleasedEventHandler) {
        if (keyReleasedEventHandler != null) {
            this.scene.setOnKeyReleased(keyReleasedEventHandler);
        }
    }

    public void toggleFullScreen() {
        this.stage.setFullScreen(!this.stage.isFullScreen());
    }

    public void hide() {
        this.stage.hide();
        this.hidden = true;
    }

    public void unHide() {
        if (this.hidden) {
            this.stage.show();
            this.hidden = false;
        }
    }

    public void center() {
        this.stage.centerOnScreen();
    }

    public void close() {
        this.stage.close();
    }

    public void hideIfShowing() {
        if (this.stage.isShowing()) {
            this.stage.hide();
        }
    }

    public double getWidth() {
        return this.stage.getWidth();
    }

    public double getHeight() {
        return this.stage.getHeight();
    }

    public Stage getStage() {
        return this.stage;
    }

    public Scene getScene() {
        return this.scene;
    }

    public Window getWindow() {
        return this.scene.getWindow();
    }

    public void clearStyleSheets() {
        this.scene.getStylesheets().clear();
    }

    public void addStyleSheet(String styleSheet) {
        this.scene.getStylesheets().add((Object)styleSheet);
        this.scene.getRoot().getStylesheets().add((Object)styleSheet);
    }

    public void setStyleSheets(String ... styleSheets) {
        this.scene.getStylesheets().clear();
        this.scene.getRoot().getStylesheets().clear();
        this.scene.getStylesheets().addAll((Object[])styleSheets);
        this.scene.getRoot().getStylesheets().addAll((Object[])styleSheets);
    }

    public void setStyleSheet(String ... styleSheets) {
        if (this.stage != null && this.stage.isShowing()) {
            this.scene.getStylesheets().setAll((Object[])styleSheets);
        }
    }

    @NotNull
    private static UnsupportedOperationException centerOnWaitError() {
        String message = "* When you call showAndWait() while also choosing to center your Scene, you must declare the size(width, height) in your build or set statement *";
        String frame = SceneObject.getBoardersFor(message);
        String finalMessage = "\n\n" + frame + "\n" + message + "\n" + frame + "\n";
        return new UnsupportedOperationException(finalMessage);
    }

    @NotNull
    private static String getBoardersFor(@NotNull String message) {
        int length = message.length();
        StringBuilder frame = new StringBuilder();
        for (int x = 0; x < length; ++x) {
            frame.append("*");
        }
        return frame.toString();
    }

    protected static class Size {
        private final Map<SceneOne.DIMENSION, Double> VALUES = new HashMap<SceneOne.DIMENSION, Double>();
        private boolean userSetAll = false;
        private boolean userSetWidth = false;
        private boolean userSetHeight = false;
        private final Stage stage;

        public Size(Stage stage, double width, double height) {
            this.VALUES.put(SceneOne.DIMENSION.WIDTH, width);
            this.VALUES.put(SceneOne.DIMENSION.HEIGHT, height);
            this.stage = stage;
            this.userSetAll = true;
        }

        public Size(Stage stage, SceneOne.DIMENSION dimension, double value) {
            this.VALUES.put(SceneOne.DIMENSION.WIDTH, -1.0);
            this.VALUES.put(SceneOne.DIMENSION.HEIGHT, -1.0);
            this.userSetWidth = dimension == SceneOne.DIMENSION.WIDTH;
            this.userSetHeight = dimension == SceneOne.DIMENSION.HEIGHT;
            switch (dimension) {
                case WIDTH: {
                    this.VALUES.put(SceneOne.DIMENSION.WIDTH, value);
                }
                case HEIGHT: {
                    this.VALUES.put(SceneOne.DIMENSION.HEIGHT, value);
                }
            }
            this.stage = stage;
        }

        public void set(Double width, Double height) {
            this.VALUES.replace(SceneOne.DIMENSION.WIDTH, width);
            this.VALUES.replace(SceneOne.DIMENSION.HEIGHT, height);
        }

        public void setWidth(Double width) {
            this.VALUES.replace(SceneOne.DIMENSION.WIDTH, width);
        }

        public void setHeight(Double height) {
            this.VALUES.replace(SceneOne.DIMENSION.HEIGHT, height);
        }

        public void setSize(Double width, Double height) {
            this.VALUES.replace(SceneOne.DIMENSION.WIDTH, width);
            this.VALUES.replace(SceneOne.DIMENSION.HEIGHT, height);
        }

        public Double getWidth() {
            if (this.VALUES.get((Object)SceneOne.DIMENSION.WIDTH) == -1.0) {
                if (this.stage.getScene().getWindow() != null) {
                    this.VALUES.put(SceneOne.DIMENSION.WIDTH, this.stage.getScene().getWindow().getWidth());
                }
                if (this.stage.getScene() != null) {
                    this.VALUES.put(SceneOne.DIMENSION.WIDTH, this.stage.getScene().getWidth());
                } else {
                    this.VALUES.put(SceneOne.DIMENSION.WIDTH, this.stage.getWidth());
                }
            }
            return this.VALUES.get((Object)SceneOne.DIMENSION.WIDTH);
        }

        public Double getHalfWidth() {
            return this.getWidth() / 2.0;
        }

        public Double getHeight() {
            if (this.VALUES.get((Object)SceneOne.DIMENSION.HEIGHT) == -1.0) {
                if (this.stage.getScene().getWindow() != null) {
                    this.VALUES.put(SceneOne.DIMENSION.HEIGHT, this.stage.getScene().getWindow().getHeight());
                }
                if (this.stage.getScene() != null) {
                    this.VALUES.put(SceneOne.DIMENSION.HEIGHT, this.stage.getScene().getHeight());
                } else {
                    this.VALUES.put(SceneOne.DIMENSION.HEIGHT, this.stage.getHeight());
                }
            }
            return this.VALUES.get((Object)SceneOne.DIMENSION.HEIGHT);
        }

        public Double getHalfHeight() {
            return this.getHeight() / 2.0;
        }

        private boolean widthSet() {
            return this.getWidth() > 0.0;
        }

        private boolean heightSet() {
            return this.getHeight() > 0.0;
        }

        public boolean notSet() {
            return !this.isFullySized();
        }

        public boolean isFullySized() {
            return this.widthSet() && this.heightSet();
        }

        private void sizeStage(SceneOne.DIMENSION dimension) {
            switch (dimension) {
                case WIDTH: {
                    this.stage.setWidth(this.getWidth().doubleValue());
                }
                case HEIGHT: {
                    this.stage.setHeight(this.getHeight().doubleValue());
                }
                case ALL: {
                    this.stage.setWidth(this.getWidth().doubleValue());
                    this.stage.setHeight(this.getHeight().doubleValue());
                }
            }
        }

        private void sizeWindow(SceneOne.DIMENSION dimension) {
            if (this.stage.getScene().getWindow() != null) {
                switch (dimension) {
                    case WIDTH: {
                        this.stage.getScene().getWindow().setWidth(this.getWidth().doubleValue());
                    }
                    case HEIGHT: {
                        this.stage.getScene().getWindow().setHeight(this.getHeight().doubleValue());
                    }
                    case ALL: {
                        this.stage.getScene().getWindow().setWidth(this.getWidth().doubleValue());
                        this.stage.getScene().getWindow().setHeight(this.getHeight().doubleValue());
                    }
                }
            }
        }

        public void resize() {
            if (this.isFullySized()) {
                Platform.runLater(() -> {
                    this.sizeStage(SceneOne.DIMENSION.ALL);
                    this.sizeWindow(SceneOne.DIMENSION.ALL);
                });
            } else if (this.widthSet()) {
                Platform.runLater(() -> {
                    this.sizeStage(SceneOne.DIMENSION.WIDTH);
                    this.sizeWindow(SceneOne.DIMENSION.WIDTH);
                });
            } else if (this.heightSet()) {
                Platform.runLater(() -> {
                    this.sizeStage(SceneOne.DIMENSION.HEIGHT);
                    this.sizeWindow(SceneOne.DIMENSION.HEIGHT);
                });
            }
        }

        protected static class User {
            private double width = -1.0;
            private double height = -1.0;

            public User(SceneOne.DIMENSION dimension, double value) {
                switch (dimension) {
                    case WIDTH: {
                        this.width = value;
                    }
                    case HEIGHT: {
                        this.height = value;
                    }
                }
            }

            public User(double width, double height) {
                this.width = width;
                this.height = height;
            }

            public boolean setWidth() {
                return this.width > 0.0;
            }

            public boolean setHeight() {
                return this.height > 0.0;
            }
        }
    }
}

