/*
 * Decompiled with CFR 0.152.
 */
package com.simtechdata.sceneonefx;

import com.simtechdata.sceneonefx.SceneObject;
import com.simtechdata.sceneonefx.Stages;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.jetbrains.annotations.NotNull;

public class SceneOne {
    private static final Map<String, SceneObject> sceneMap = new HashMap<String, SceneObject>();
    static final LinkedList<String> lastSceneShown = new LinkedList();
    private static String masterTitle = "";
    private static boolean disableNotice = false;

    public static Builder set(String sceneId, Parent parent) {
        return new Builder(sceneId, parent);
    }

    public static Builder set(String sceneId, Parent parent, double width, double height) {
        return new Builder(sceneId, parent, width, height);
    }

    public static Builder set(String sceneId, Scene scene) {
        return new Builder(sceneId, scene);
    }

    public static Builder set(String sceneId, Scene scene, double width, double height) {
        return new Builder(sceneId, scene, width, height);
    }

    public static void toggleFullScreen(String sceneId) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).toggleFullScreen();
    }

    public static void disableNotice() {
        disableNotice = true;
    }

    public static void show(String sceneId) {
        SceneOne.checkScene(sceneId);
        Platform.runLater(() -> sceneMap.get(sceneId).show());
    }

    public static void showAndWait(String sceneId) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).showAndWait();
    }

    public static void hide(String sceneId) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).hide();
    }

    public static void unHide(String sceneId) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).unHide();
    }

    public static void reSize(String sceneId, double width, double height) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).resize(width, height);
    }

    public static void closeStage(String sceneId) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).close();
    }

    public static void close(String sceneId) {
        SceneOne.checkScene(sceneId);
        if (Stages.sceneHasHistory(sceneId)) {
            sceneMap.get(Stages.getLastShownScene(sceneId)).reShow();
        } else {
            sceneMap.get(sceneId).close();
        }
    }

    public static void closeIfShowing(String sceneId) {
        SceneOne.checkScene(sceneId);
        if (SceneOne.isShowing(sceneId)) {
            SceneOne.close(sceneId);
        }
    }

    public static void closeStageIfShowing(String sceneId) {
        SceneOne.checkScene(sceneId);
        if (SceneOne.isShowing(sceneId)) {
            sceneMap.get(sceneId).close();
        }
    }

    public static void hideIfShowing(String sceneId) {
        if (sceneMap.containsKey(sceneId)) {
            sceneMap.get(sceneId).hideIfShowing();
        }
    }

    public static void remove(String sceneId) {
        sceneMap.remove(sceneId);
        Stages.removeScene(sceneId);
    }

    public static void center(String sceneId) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).center();
    }

    public static void reCenterScene(String sceneId) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).reCenterScene();
    }

    public static void reShow(String sceneId) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).reShow();
    }

    public static void showSplitXY(String sceneId, double mouseX, double mouseY, double factorX, double factorY) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).showSplit(mouseX, mouseY, factorX, factorY);
    }

    public static void showSplitX(String sceneId, double mouseX, double factorX) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).showSplitX(mouseX, factorX);
    }

    public static void showSplitY(String sceneId, double mouseY, double factorY) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).showSplitY(mouseY, factorY);
    }

    public static void showLastScene() {
        if (lastSceneShown.size() <= 1) {
            throw SceneOne.userError("No last Scene to show, verify first by using lastSceneAvailable()");
        }
        lastSceneShown.removeLast();
        String sceneId = lastSceneShown.getLast();
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).reShow();
    }

    public static Integer askYesNo(String parentSceneId, String question, double width, double height) {
        return SceneOne.askYesNo(parentSceneId, question, width, height, Pos.CENTER, true);
    }

    public static Integer askYesNo(String parentSceneId, String question, double width, double height, Pos textAlignment) {
        return SceneOne.askYesNo(parentSceneId, question, width, height, textAlignment, true);
    }

    public static Integer askYesNo(String parentSceneId, String question, double width, double height, Pos textAlignment, boolean wrapText) {
        SceneOne.checkScene(parentSceneId);
        String sid = "SceneOneYesNo";
        Label label = new Label(question);
        label.setWrapText(wrapText);
        label.setMinWidth(width * 0.85);
        label.setMaxWidth(width * 0.85);
        label.setPrefWidth(width * 0.85);
        label.setAlignment(textAlignment);
        SimpleIntegerProperty answer = new SimpleIntegerProperty(-1);
        Button btnYes = new Button("Yes");
        btnYes.setOnAction(arg_0 -> SceneOne.lambda$askYesNo$1((IntegerProperty)answer, sid, arg_0));
        Button btnNo = new Button("No");
        btnNo.setOnAction(arg_0 -> SceneOne.lambda$askYesNo$2((IntegerProperty)answer, sid, arg_0));
        HBox hbox = new HBox(20.0, new Node[]{btnYes, btnNo});
        hbox.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(10.0, new Node[]{label, hbox});
        vbox.setAlignment(Pos.CENTER);
        vbox.setMinWidth(width);
        vbox.setMinHeight(height);
        SceneOne.set(sid, (Parent)vbox, width, height).newStage().centered().owner(parentSceneId).alwaysOnTop().build();
        SceneOne.showAndWait(sid);
        SceneOne.remove(sid);
        return answer.getValue();
    }

    public static void showMessage(String parentSceneId, double width, double height, String message) {
        SceneOne.showMessage(parentSceneId, width, height, message, true, Pos.CENTER);
    }

    public static void showMessage(String parentSceneId, double width, double height, String message, boolean wrapText, Pos textAlignment) {
        SceneOne.checkScene(parentSceneId);
        String sid = "SceneOneMessage";
        Label label = new Label(message);
        label.setWrapText(wrapText);
        label.setMinWidth(width * 0.85);
        label.setMaxWidth(width * 0.85);
        label.setPrefWidth(width * 0.85);
        label.setAlignment(textAlignment);
        Button btnOk = new Button("OK");
        btnOk.setOnAction(e -> SceneOne.close(sid));
        VBox vbox = new VBox(10.0, new Node[]{label, btnOk});
        vbox.setAlignment(Pos.CENTER);
        vbox.setMinWidth(width);
        vbox.setMinHeight(height);
        SceneOne.set(sid, (Parent)vbox, width, height).newStage().centered().owner(parentSceneId).alwaysOnTop().build();
        SceneOne.showAndWait(sid);
        SceneOne.remove(sid);
    }

    public static Integer choiceResponse(String parentSceneId, String question, double width, double height, String ... buttonText) {
        return SceneOne.choiceResponse(parentSceneId, question, width, height, Pos.CENTER, true, buttonText);
    }

    public static Integer choiceResponse(String parentSceneId, String question, double width, double height, Pos textAlignment, boolean wrapText, String ... buttonText) {
        SceneOne.checkScene(parentSceneId);
        String sid = "SceneOneChoiceResponse";
        int buttonCount = buttonText.length;
        Button[] buttons = new Button[buttonCount];
        Label label = new Label(question);
        label.setWrapText(wrapText);
        label.setMinWidth(width * 0.85);
        label.setMaxWidth(width * 0.85);
        label.setPrefWidth(width * 0.85);
        label.setAlignment(textAlignment);
        SimpleIntegerProperty answer = new SimpleIntegerProperty(-1);
        for (int x = 0; x < buttonCount; ++x) {
            buttons[x] = new Button(buttonText[x]);
            int btnAnswer = x;
            buttons[x].setOnAction(arg_0 -> SceneOne.lambda$choiceResponse$4((IntegerProperty)answer, btnAnswer, sid, arg_0));
        }
        HBox hbox = new HBox(buttonCount < 4 ? 20.0 : 15.0, (Node[])buttons);
        hbox.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(10.0, new Node[]{label, hbox});
        vbox.setAlignment(Pos.CENTER);
        vbox.setMinWidth(width);
        vbox.setMinHeight(height);
        SceneOne.set(sid, (Parent)vbox, width, height).newStage().centered().owner(SceneOne.getStage(parentSceneId)).alwaysOnTop().build();
        SceneOne.showAndWait(sid);
        SceneOne.remove(sid);
        return answer.getValue();
    }

    public static void setTitle(String title) {
        masterTitle = title;
    }

    public static void setStyleSheetsForAll(String ... styleSheets) {
        for (String sceneId : sceneMap.keySet()) {
            SceneObject so = sceneMap.get(sceneId);
            if (so == null) continue;
            so.setStyleSheets(styleSheets);
        }
    }

    public static void setHeight(String sceneId, double height) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setHeight(height);
    }

    public static void setWidth(String sceneId, double width) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setWidth(width);
    }

    public static void setSize(String sceneId, double width, double height) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setSize(width, height);
    }

    public static void setPosition(String sceneId, double posX, double posY) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setPosition(posX, posY);
    }

    public static void setParent(String sceneId, Parent parent) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setParent(parent);
    }

    public static void setScene(String sceneId, Scene scene) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setScene(scene);
    }

    public static void swapScene(String sceneId, Scene scene) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setScene(scene);
    }

    public static void setTitle(String sceneId, String title) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setTitle(title);
    }

    public static void setOnKeyPressedEvent(String sceneId, EventHandler<? super KeyEvent> keyPressedEventHandler) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setOnKeyPressedEvent(keyPressedEventHandler);
    }

    public static void setOnKeyReleasedEvent(String sceneId, EventHandler<? super KeyEvent> keyReleasedEventHandler) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setOnKeyReleasedEvent(keyReleasedEventHandler);
    }

    public static void setOnShowingEvent(String sceneId, EventHandler<WindowEvent> onShowingEventHandler) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setOnShowingEvent(onShowingEventHandler);
    }

    public static void setOnShownEvent(String sceneId, EventHandler<WindowEvent> onShownEventHandler) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setOnShownEvent(onShownEventHandler);
    }

    public static void setOnHidingEvent(String sceneId, EventHandler<WindowEvent> onHidingEventHandler) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setOnHidingEvent(onHidingEventHandler);
    }

    public static void setOnHiddenEvent(String sceneId, EventHandler<WindowEvent> onHiddenEventHandler) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setOnHiddenEvent(onHiddenEventHandler);
    }

    public static void setOnCloseEvent(String sceneId, EventHandler<WindowEvent> onCloseEventHandler) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setOnCloseEvent(onCloseEventHandler);
    }

    public static void setOnWindowCloseEvent(String sceneId, EventHandler<WindowEvent> onWindowCloseEventHandler) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setOnWindowCloseEvent(onWindowCloseEventHandler);
    }

    public static void setStyleSheets(String sceneId, String ... styleSheets) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setStyleSheets(styleSheets);
    }

    public static void addStyleSheet(String sceneId, String styleSheet) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).addStyleSheet(styleSheet);
    }

    public static void clearStyleSheets(String sceneId) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).clearStyleSheets();
    }

    public static void setOnLostFocus(String sceneId, ChangeListener<? super Boolean> lostFocusListener) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setOnLostFocus(lostFocusListener);
    }

    public static void setHideOnLostFocus(String sceneId) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setHideOnLostFocus(true);
    }

    public static void setHideOnLostFocus(String sceneId, boolean hideOnLostFocus) {
        SceneOne.checkScene(sceneId);
        sceneMap.get(sceneId).setHideOnLostFocus(hideOnLostFocus);
    }

    public static boolean lastSceneAvailable() {
        LinkedList<String> newList = new LinkedList<String>(lastSceneShown);
        if (newList.size() > 1) {
            newList.removeLast();
            return sceneMap.containsKey(newList.getLast());
        }
        return false;
    }

    public static Stage getStage(String sceneId) {
        SceneOne.checkScene(sceneId);
        return sceneMap.get(sceneId).getStage();
    }

    public static boolean isShowing(String sceneId) {
        SceneOne.checkScene(sceneId);
        return sceneMap.get(sceneId).getStage().isShowing();
    }

    public static Scene getScene(String sceneId) {
        SceneOne.checkScene(sceneId);
        return sceneMap.get(sceneId).getScene();
    }

    public static Window getWindow(String sceneId) {
        SceneOne.checkScene(sceneId);
        return sceneMap.get(sceneId).getWindow();
    }

    public static boolean sceneExists(String sceneId) {
        return sceneMap.containsKey(sceneId);
    }

    public static Window getOwner(String sceneId) {
        SceneOne.checkScene(sceneId);
        return sceneMap.get(sceneId).getStage().getOwner();
    }

    public static Dimension getScreenDimensions() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    @NotNull
    public static Double getScreenWidth() {
        return Toolkit.getDefaultToolkit().getScreenSize().getWidth();
    }

    @NotNull
    public static Double getScreenHeight() {
        return Toolkit.getDefaultToolkit().getScreenSize().getHeight();
    }

    @NotNull
    public static Double getWidth(String sceneId) {
        SceneOne.checkScene(sceneId);
        return sceneMap.get(sceneId).getWidth();
    }

    @NotNull
    public static Double getHeight(String sceneId) {
        SceneOne.checkScene(sceneId);
        return sceneMap.get(sceneId).getHeight();
    }

    private static void checkScene(String sceneId) {
        if (!sceneMap.containsKey(sceneId)) {
            throw SceneOne.noSceneError(sceneId);
        }
    }

    @NotNull
    private static UnsupportedOperationException noSceneError(String sceneId) {
        String message = "* Scene " + sceneId + " does not exist, you need to run SceneOne.set(sceneId, Parent).build(); to complete a Scene *";
        String frame = SceneOne.getFrameFor(message);
        String finalMessage = "\n\n" + frame + "\n" + message + "\n" + frame + "\n";
        return new UnsupportedOperationException(finalMessage);
    }

    @NotNull
    private static UnsupportedOperationException userError(String message) {
        String tempMessage = "* " + message + " *";
        String frame = SceneOne.getFrameFor(tempMessage);
        String finalMessage = "\n\n" + frame + "\n" + tempMessage + "\n" + frame + "\n";
        return new UnsupportedOperationException(finalMessage);
    }

    @NotNull
    private static UnsupportedOperationException centerOnWaitError() {
        String message = "* When you call showAndWait() while also choosing to center your Scene, you must declare the size(width, height) in your build or set statement *";
        String frame = SceneOne.getFrameFor(message);
        String finalMessage = "\n\n" + frame + "\n" + message + "\n" + frame + "\n";
        return new UnsupportedOperationException(finalMessage);
    }

    @NotNull
    private static String getFrameFor(@NotNull String message) {
        int length = message.length();
        StringBuilder frame = new StringBuilder();
        for (int x = 0; x < length; ++x) {
            frame.append("*");
        }
        return frame.toString();
    }

    private static /* synthetic */ void lambda$choiceResponse$4(IntegerProperty answer, int btnAnswer, String sid, ActionEvent e) {
        answer.setValue((Number)btnAnswer);
        SceneOne.close(sid);
    }

    private static /* synthetic */ void lambda$askYesNo$2(IntegerProperty answer, String sid, ActionEvent e) {
        answer.setValue((Number)0);
        SceneOne.close(sid);
    }

    private static /* synthetic */ void lambda$askYesNo$1(IntegerProperty answer, String sid, ActionEvent e) {
        answer.setValue((Number)1);
        SceneOne.close(sid);
    }

    static /* synthetic */ String access$000() {
        return masterTitle;
    }

    public static class Builder {
        final String sceneId;
        Scene scene;
        Parent parent;
        final ObservableList<String> styleSheets = FXCollections.observableArrayList();
        double width = -1.0;
        double height = -1.0;
        StageStyle style = null;
        Modality modality = null;
        boolean centered = false;
        boolean alwaysOnTop = false;
        boolean hideOnLostFocus = false;
        boolean fullScreen = false;
        String title = SceneOne.access$000();
        double posX = -1.0;
        double posY = -1.0;
        double splitFactorX = -1.0;
        double splitFactorY = -1.0;
        EventHandler<WindowEvent> onShownEventHandler = null;
        EventHandler<WindowEvent> onHiddenEventHandler = null;
        EventHandler<WindowEvent> onShowingEventHandler = null;
        EventHandler<WindowEvent> onHidingEventHandler = null;
        EventHandler<WindowEvent> onCloseEventHandler = null;
        EventHandler<WindowEvent> onWindowCloseEventHandler = null;
        ChangeListener<? super Boolean> lostFocusListener = null;
        EventHandler<? super KeyEvent> keyPressedEventHandler = null;
        EventHandler<? super KeyEvent> keyReleasedEventHandler = null;
        Stage owner = null;
        Stage stage = null;
        private boolean addStage = false;

        public Builder(String sceneId, Parent parent) {
            this.sceneId = sceneId;
            this.parent = parent;
        }

        public Builder(String sceneId, Parent parent, double width, double height) {
            this.sceneId = sceneId;
            this.parent = parent;
            this.width = width;
            this.height = height;
        }

        public Builder(String sceneId, Scene scene) {
            this.sceneId = sceneId;
            this.scene = scene;
        }

        public Builder(String sceneId, Scene scene, double width, double height) {
            this.sceneId = sceneId;
            this.scene = scene;
            this.width = width;
            this.height = height;
        }

        public Builder newStage() {
            this.addStage = true;
            return this;
        }

        public Builder owner(Stage owner) {
            if (owner != null) {
                this.owner = owner;
            }
            return this;
        }

        public Builder owner(String sceneId) {
            if (sceneId != null && sceneMap.containsKey(sceneId)) {
                this.owner = ((SceneObject)sceneMap.get(sceneId)).getStage();
            }
            return this;
        }

        public Builder stage(Stage stage) {
            this.stage = stage;
            return this;
        }

        public Builder centered() {
            this.centered = true;
            return this;
        }

        public Builder centered(boolean centered) {
            this.centered = centered;
            return this;
        }

        public Builder centered(double width, double height) {
            this.width = width;
            this.height = height;
            this.centered = true;
            return this;
        }

        public Builder fullScreen() {
            this.fullScreen = true;
            return this;
        }

        public Builder hideOnLostFocus() {
            this.hideOnLostFocus = true;
            return this;
        }

        public Builder hideOnLostFocus(boolean hideOnLostFocus) {
            this.hideOnLostFocus = hideOnLostFocus;
            return this;
        }

        public Builder position(double posX, double posY) {
            this.posX = posX;
            this.posY = posY;
            return this;
        }

        public Builder initStyle(StageStyle style) {
            if (style != null) {
                this.style = style;
            }
            return this;
        }

        public Builder styleSheets(String ... styleSheets) {
            if (styleSheets != null) {
                this.styleSheets.addAll((Object[])styleSheets);
            }
            return this;
        }

        public Builder modality(Modality modality) {
            if (modality != null) {
                this.modality = modality;
            }
            return this;
        }

        public Builder title(String title) {
            if (title != null && !title.isEmpty()) {
                this.title = title;
            }
            return this;
        }

        public Builder size(double width, double height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder width(double width) {
            this.width = width;
            return this;
        }

        public Builder height(double height) {
            this.height = height;
            return this;
        }

        public Builder splitXY(double posX, double posY, double xFactor, double yFactor) {
            this.posX = posX;
            this.posY = posY;
            this.splitFactorX = xFactor;
            this.splitFactorY = yFactor;
            return this;
        }

        public Builder splitX(double posX, double splitFactorX) {
            this.posX = posX;
            this.splitFactorX = splitFactorX;
            return this;
        }

        public Builder splitY(double posY, double splitFactorY) {
            this.splitFactorY = splitFactorY;
            this.posY = posY;
            return this;
        }

        public Builder onKeyPressed(EventHandler<? super KeyEvent> keyPressedEventHandler) {
            if (keyPressedEventHandler != null) {
                this.keyPressedEventHandler = keyPressedEventHandler;
            }
            return this;
        }

        public Builder onKeyReleased(EventHandler<? super KeyEvent> keyReleasedEventHandler) {
            if (keyReleasedEventHandler != null) {
                this.keyReleasedEventHandler = keyReleasedEventHandler;
            }
            return this;
        }

        public Builder onShowingEvent(EventHandler<WindowEvent> onShowingEventHandler) {
            if (onShowingEventHandler != null) {
                this.onShowingEventHandler = onShowingEventHandler;
            }
            return this;
        }

        public Builder onShownEvent(EventHandler<WindowEvent> onShownEventHandler) {
            if (onShownEventHandler != null) {
                this.onShownEventHandler = onShownEventHandler;
            }
            return this;
        }

        public Builder onHidingEvent(EventHandler<WindowEvent> onHidingEventHandler) {
            if (onHidingEventHandler != null) {
                this.onHidingEventHandler = onHidingEventHandler;
            }
            return this;
        }

        public Builder onHiddenEvent(EventHandler<WindowEvent> onHiddenEventHandler) {
            if (onHiddenEventHandler != null) {
                this.onHiddenEventHandler = onHiddenEventHandler;
            }
            return this;
        }

        public Builder onCloseEvent(EventHandler<WindowEvent> onCloseEventHandler) {
            if (onCloseEventHandler != null) {
                this.onCloseEventHandler = onCloseEventHandler;
            }
            return this;
        }

        public Builder onWindowCloseEvent(EventHandler<WindowEvent> onWindowCloseEventHandler) {
            if (onWindowCloseEventHandler != null) {
                this.onWindowCloseEventHandler = onWindowCloseEventHandler;
            }
            return this;
        }

        public Builder onLostFocus(ChangeListener<? super Boolean> lostFocusListener) {
            this.lostFocusListener = lostFocusListener;
            return this;
        }

        public Builder alwaysOnTop() {
            this.alwaysOnTop = true;
            return this;
        }

        public Builder alwaysOnTop(boolean alwaysOnTop) {
            this.alwaysOnTop = alwaysOnTop;
            return this;
        }

        public void build() {
            boolean sceneHasStage = Stages.hasStage(this.sceneId);
            sceneMap.remove(this.sceneId);
            if (!sceneHasStage && this.addStage) {
                this.stage = new Stage();
                Stages.addStage(this.sceneId, this.stage);
            } else if (sceneHasStage && this.addStage) {
                Stages.removeScene(this.sceneId);
                this.stage = Stages.getDefaultStage();
                Stages.addStage(this.sceneId, this.stage);
            } else if (sceneHasStage) {
                this.stage = Stages.getStage(this.sceneId);
            } else {
                this.stage = Stages.getDefaultStage();
                Stages.addStage(this.sceneId, this.stage);
            }
            sceneMap.put(this.sceneId, new SceneObject(this));
            if (!disableNotice) {
                System.out.println("SceneOneFX now switches out your Scenes onto a single stage. See README at https://github.com/EasyG0ing1/SceneOneFX\nDisable this notice by calling SceneOne.disableNotice() once.");
            }
        }

        public void show() {
            this.build();
            Platform.runLater(() -> ((SceneObject)sceneMap.get(this.sceneId)).show());
        }

        public void showAndWait() {
            if (this.centered && (this.width < 0.0 || this.height < 0.0)) {
                throw SceneOne.centerOnWaitError();
            }
            this.build();
            Platform.runLater(() -> ((SceneObject)sceneMap.get(this.sceneId)).showAndWait());
        }
    }

    static enum DIMENSION {
        WIDTH,
        HEIGHT,
        ALL;

    }
}

