/*
 * Decompiled with CFR 0.152.
 */
package com.simtechdata.sceneonefx;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javafx.stage.Stage;

public class Stages {
    private static final Map<String, Stage> stageMap = new HashMap<String, Stage>();
    private static final Stage defaultStage = new Stage();
    private static final Map<Stage, LinkedList<String>> shownSceneMap = new HashMap<Stage, LinkedList<String>>();

    public static void addStage(String sceneId, Stage stage) {
        if (!stageMap.containsKey(sceneId)) {
            stageMap.put(sceneId, stage);
        }
        if (!shownSceneMap.containsKey(stage)) {
            shownSceneMap.put(stage, new LinkedList());
        }
    }

    public static Stage getStage(String sceneId) {
        return stageMap.getOrDefault(sceneId, null);
    }

    public static boolean hasStage(String sceneId) {
        return stageMap.containsKey(sceneId);
    }

    public static Stage getDefaultStage() {
        return defaultStage;
    }

    public static void showingScene(String sceneId) {
        Stage stage = stageMap.get(sceneId);
        if (shownSceneMap.containsKey(stage)) {
            if (shownSceneMap.get(stage).contains(sceneId)) {
                LinkedList<String> list = shownSceneMap.get(stage);
                list.remove(sceneId);
                list.addLast(sceneId);
                shownSceneMap.replace(stage, list);
            } else {
                shownSceneMap.get(stage).addLast(sceneId);
            }
        }
    }

    public static boolean sceneHasHistory(String sceneId) {
        Stage stage = stageMap.get(sceneId);
        return shownSceneMap.get(stage).size() > 1;
    }

    public static String getLastShownScene(String sceneId) {
        Stage stage = stageMap.get(sceneId);
        if (shownSceneMap.get(stage).size() > 0) {
            shownSceneMap.get(stage).removeLast();
        }
        return shownSceneMap.get(stage).getLast();
    }

    private static Stage getStageForScene(String sceneId) {
        for (String id : stageMap.keySet()) {
            if (!id.equals(sceneId)) continue;
            return stageMap.get(sceneId);
        }
        return null;
    }

    public static void removeShownScene(String sceneId) {
        LinkedList<String> list;
        Stage stage = stageMap.get(sceneId);
        if (shownSceneMap.containsKey(stage) && (list = shownSceneMap.get(stage)).contains(sceneId)) {
            list.remove(sceneId);
            shownSceneMap.replace(stage, list);
        }
    }

    public static void removeScene(String sceneId) {
        stageMap.remove(sceneId);
    }
}

