/*
 * Decompiled with CFR 0.152.
 */
package com.simtechdata.sceneonefx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public class UpdateVersion {
    public static void main(String[] args) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("1) Change Version\n2) Copy Jar File\n3) Switch POM File\n: ");
            String option = reader.readLine();
            switch (option.substring(0, 1)) {
                case "1": {
                    UpdateVersion.changeVersion();
                }
                case "2": {
                    UpdateVersion.copyJarFile();
                }
                case "3": {
                    UpdateVersion.swapPomFile();
                }
            }
            System.exit(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeTextFile(File textFile, String text) {
        try {
            FileWriter fw = new FileWriter(textFile);
            fw.write(text);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String loadTextFile(File file) {
        StringBuilder sb = new StringBuilder();
        try (Stream<String> stream = Files.lines(file.toPath(), StandardCharsets.UTF_8);){
            stream.forEach(s -> sb.append((String)s).append("\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private static void swapPomFile() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("1) Java 1.8\n2) Java 18\n:");
            String option = reader.readLine();
            switch (option.substring(0, 1)) {
                case "1": {
                    UpdateVersion.swap("1.8");
                }
                case "2": {
                    UpdateVersion.swap("18");
                }
            }
            System.exit(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void changeVersion() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            System.out.print("\n\nCurrent Version: ");
            String currentVersion = reader.readLine();
            System.out.print("New Version: ");
            String newVersion = reader.readLine();
            File readme = new File("/Users/michael/IdeaProjects/SceneOneFX/readme.md");
            File POM = new File("/Users/michael/IdeaProjects/SceneOneFX/pom.xml");
            File pomOneEight = new File("/Users/michael/IdeaProjects/SceneOneFX/pom1.8.txt");
            File pomEighteen = new File("/Users/michael/IdeaProjects/SceneOneFX/pom18.txt");
            List<File> pomFileList = Arrays.asList(POM, pomOneEight, pomEighteen);
            String pomSearch = "<version>" + currentVersion + "</version>";
            String pomReplace = "<version>" + newVersion + "</version>";
            for (File file : pomFileList) {
                String pomFileString = UpdateVersion.loadTextFile(file);
                String newPOM = pomFileString.replace(pomSearch, pomReplace);
                UpdateVersion.writeTextFile(file, newPOM);
            }
            String readmeString = UpdateVersion.loadTextFile(readme);
            String readmeSearch1 = "version: " + currentVersion;
            String readmeReplace1 = "version: " + newVersion;
            String readmeSearch2 = "version=" + currentVersion;
            String readmeReplace2 = "version=" + newVersion;
            String finalReadme = readmeString.replace(pomSearch, pomReplace).replace(readmeSearch1, readmeReplace1).replace(readmeSearch2, readmeReplace2);
            UpdateVersion.writeTextFile(readme, finalReadme);
            System.out.println("Done!");
            System.exit(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyJarFile() {
        System.out.println("Copy Jar File");
        Path target = Paths.get("/Users/michael/IdeaProjects/SceneOneFX/target", new String[0]);
        Path destination = Paths.get("/Users/michael/IdeaProjects/SceneOneFX/testOut/SceneOneFX.jar", new String[0]);
        File[] targetFiles = target.toFile().listFiles();
        File jarFile = null;
        File destinationJar = new File(destination.toFile(), "SceneOneFX.jar");
        assert (targetFiles != null);
        System.out.println(targetFiles.length);
        for (File file : targetFiles) {
            System.out.println(file.getName());
            if (!file.getName().matches("SceneOneFX-\\d\\.\\d\\.\\d\\d\\.jar")) continue;
            System.out.println("Match");
            jarFile = file;
            break;
        }
        try {
            assert (jarFile != null);
            Files.copy(jarFile.toPath(), destination, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Done!");
            System.exit(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void swap(String version) {
        Path oldFile = Paths.get(System.getProperty("user.dir"), "pom1_8.txt");
        Path newFile = Paths.get(System.getProperty("user.dir"), "pom18.txt");
        Path pomFile = Paths.get(System.getProperty("user.dir"), "pom.xml");
        Object fileReader = null;
        try {
            Path path = version.equals("18") ? newFile : oldFile;
            List<String> newPOMList = Files.readAllLines(path);
            StringBuilder sb = new StringBuilder();
            for (String line : newPOMList) {
                sb.append(line).append("\n");
            }
            String newPomFileText = sb.toString();
            if (!newPomFileText.isEmpty()) {
                new Thread(() -> {
                    try {
                        Files.delete(pomFile);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).start();
                TimeUnit.MILLISECONDS.sleep(2000L);
                FileWriter fw = new FileWriter(pomFile.toFile());
                fw.write(newPomFileText);
                fw.close();
            }
            System.out.println("Done!");
            System.exit(0);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

