/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sinch.xms.ApiConnectionImpl;
import com.sinch.xms.ApiException;
import com.sinch.xms.ApiHttpAsyncClient;
import com.sinch.xms.ApiObjectMapper;
import com.sinch.xms.BatchDeliveryReportParams;
import com.sinch.xms.BatchFilter;
import com.sinch.xms.CallbackWrapper;
import com.sinch.xms.DeliveryReportFilter;
import com.sinch.xms.EmptyAsyncConsumer;
import com.sinch.xms.GroupFilter;
import com.sinch.xms.InboundsFilter;
import com.sinch.xms.JsonApiAsyncConsumer;
import com.sinch.xms.PagedFetcher;
import com.sinch.xms.Utils;
import com.sinch.xms.ValueStylePackageDirect;
import com.sinch.xms.api.BatchDeliveryReport;
import com.sinch.xms.api.BatchId;
import com.sinch.xms.api.FeedbackDeliveryCreate;
import com.sinch.xms.api.GroupCreate;
import com.sinch.xms.api.GroupId;
import com.sinch.xms.api.GroupResult;
import com.sinch.xms.api.GroupUpdate;
import com.sinch.xms.api.MoSms;
import com.sinch.xms.api.MtBatchBinarySmsCreate;
import com.sinch.xms.api.MtBatchBinarySmsResult;
import com.sinch.xms.api.MtBatchBinarySmsUpdate;
import com.sinch.xms.api.MtBatchDryRunResult;
import com.sinch.xms.api.MtBatchSmsCreate;
import com.sinch.xms.api.MtBatchSmsResult;
import com.sinch.xms.api.MtBatchTextSmsCreate;
import com.sinch.xms.api.MtBatchTextSmsResult;
import com.sinch.xms.api.MtBatchTextSmsUpdate;
import com.sinch.xms.api.Page;
import com.sinch.xms.api.PagedBatchResult;
import com.sinch.xms.api.PagedDeliveryReportResult;
import com.sinch.xms.api.PagedGroupResult;
import com.sinch.xms.api.PagedInboundsResult;
import com.sinch.xms.api.RecipientDeliveryReport;
import com.sinch.xms.api.Tags;
import com.sinch.xms.api.TagsUpdate;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.protocol.BasicAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable(copy=false)
@ValueStylePackageDirect
public abstract class ApiConnection
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ApiConnection.class);
    public static final URI DEFAULT_ENDPOINT = URI.create("https://us.sms.api.sinch.com/xms");
    private final ApiObjectMapper json = new ApiObjectMapper();

    ApiConnection() {
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public void start() {
        log.debug("Starting API connection: {}", (Object)this);
        if (this.httpClient() instanceof ApiHttpAsyncClient) {
            ((ApiHttpAsyncClient)this.httpClient()).start();
        } else {
            log.debug("Not starting HTTP client since it was given externally");
        }
    }

    @Override
    public void close() throws IOException {
        log.debug("Closing API connection: {}", (Object)this);
        HttpAsyncClient c = this.httpClient();
        if (c instanceof ApiHttpAsyncClient && ((ApiHttpAsyncClient)c).isStartedInternally()) {
            ((ApiHttpAsyncClient)c).close();
        } else {
            log.debug("Not closing HTTP client since it was given externally");
        }
    }

    public abstract String token();

    public abstract String servicePlanId();

    @Value.Default
    public boolean prettyPrintJson() {
        return false;
    }

    @Value.Default
    public HttpAsyncClient httpClient() {
        return new ApiHttpAsyncClient(true);
    }

    @Value.Default
    public CallbackWrapper callbackWrapper() {
        return CallbackWrapper.exceptionDropper;
    }

    @Value.Default
    public URI endpoint() {
        return DEFAULT_ENDPOINT;
    }

    @Value.Derived
    protected HttpHost endpointHost() {
        URI uri = this.endpoint();
        return new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
    }

    @Value.Check
    protected void check() {
        this.json.configure(SerializationFeature.INDENT_OUTPUT, this.prettyPrintJson());
        if (this.endpoint().getQuery() != null) {
            throw new IllegalStateException("base endpoint has query component");
        }
        if (this.endpoint().getFragment() != null) {
            throw new IllegalStateException("base endpoint has fragment component");
        }
        this.endpoint("");
    }

    @Nonnull
    private URI endpoint(@Nonnull String subPath, @Nonnull List<NameValuePair> params) {
        try {
            String spid = URLEncoder.encode(this.servicePlanId(), "UTF-8");
            String path = this.endpoint().getPath() + "/v1/" + spid + subPath;
            URIBuilder uriBuilder = new URIBuilder(this.endpoint()).setPath(path);
            if (!params.isEmpty()) {
                uriBuilder.setParameters(params);
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    private URI endpoint(String subPath) {
        return this.endpoint(subPath, Collections.emptyList());
    }

    @Nonnull
    private URI batchesEndpoint() {
        return this.endpoint("/batches");
    }

    @Nonnull
    private URI batchEndpoint(BatchId batchId) {
        return this.endpoint("/batches/" + batchId);
    }

    @Nonnull
    private URI batchDeliveryReportEndpoint(BatchId batchId, List<NameValuePair> params) {
        return this.endpoint("/batches/" + batchId + "/delivery_report", params);
    }

    @Nonnull
    private URI deliveryReportListEndpoint(List<NameValuePair> params) {
        return this.endpoint("/delivery_reports", params);
    }

    @Nonnull
    private URI batchDryRunEndpoint(List<NameValuePair> params) {
        return this.endpoint("/batches/dry_run", params);
    }

    @Nonnull
    private URI batchRecipientDeliveryReportEndpoint(BatchId batchId, String recipient) {
        return this.endpoint("/batches/" + batchId + "/delivery_report/" + recipient);
    }

    @Nonnull
    private URI batchDeliveryFeedbackEndpoint(BatchId batchId) {
        return this.endpoint("/batches/" + batchId + "/delivery_feedback");
    }

    @Nonnull
    private URI batchTagsEndpoint(BatchId batchId) {
        return this.endpoint("/batches/" + batchId + "/tags");
    }

    @Nonnull
    private URI groupsEndpoint() {
        return this.endpoint("/groups");
    }

    @Nonnull
    private URI groupsEndpoint(List<NameValuePair> params) {
        return this.endpoint("/groups", params);
    }

    @Nonnull
    private URI groupEndpoint(GroupId id) {
        return this.endpoint("/groups/" + id);
    }

    @Nonnull
    private URI groupMembersEndpoint(GroupId id) {
        return this.endpoint("/groups/" + id + "/members");
    }

    @Nonnull
    private URI groupTagsEndpoint(GroupId id) {
        return this.endpoint("/groups/" + id + "/tags");
    }

    @Nonnull
    private URI inboundsEndpoint(List<NameValuePair> params) {
        return this.endpoint("/inbounds", params);
    }

    @Nonnull
    private URI inboundEndpoint(String id) {
        return this.endpoint("/inbounds/" + id);
    }

    private <T, P extends T> JsonApiAsyncConsumer<T> jsonAsyncConsumer(Class<P> clazz) {
        return new JsonApiAsyncConsumer<P>(this.json, clazz);
    }

    private <T> HttpPost post(URI endpoint, T object) {
        return this.withJsonContent(object, this.withStandardHeaders(new HttpPost(endpoint)));
    }

    private <T> HttpPut put(URI endpoint, T object) {
        return this.withJsonContent(object, this.withStandardHeaders(new HttpPut(endpoint)));
    }

    private HttpGet get(URI endpoint) {
        return this.withStandardHeaders(new HttpGet(endpoint));
    }

    private HttpDelete delete(URI endpoint) {
        return this.withStandardHeaders(new HttpDelete(endpoint));
    }

    private <T extends HttpRequest> T withStandardHeaders(T req) {
        req.setHeader("Authorization", "Bearer " + this.token());
        req.setHeader("Accept", ContentType.APPLICATION_JSON.toString());
        req.setHeader("X-Sinch-SDK-Version", "1.1.6");
        return req;
    }

    private <T extends HttpEntityEnclosingRequest> T withJsonContent(Object object, T req) {
        byte[] content;
        try {
            content = this.json.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        ByteArrayEntity entity = new ByteArrayEntity(content, ContentType.APPLICATION_JSON);
        req.setEntity((HttpEntity)entity);
        return req;
    }

    public MtBatchTextSmsResult createBatch(MtBatchTextSmsCreate sms) throws InterruptedException, ApiException {
        try {
            return this.createBatchAsync(sms, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<MtBatchTextSmsResult> createBatchAsync(MtBatchTextSmsCreate sms, FutureCallback<MtBatchTextSmsResult> callback) {
        HttpPost req = this.post(this.batchesEndpoint(), sms);
        BasicAsyncRequestProducer requestProducer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer responseConsumer = this.jsonAsyncConsumer(MtBatchTextSmsResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)requestProducer, responseConsumer, this.callbackWrapper().wrap(callback));
    }

    public MtBatchBinarySmsResult createBatch(MtBatchBinarySmsCreate sms) throws InterruptedException, ApiException {
        try {
            return this.createBatchAsync(sms, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<MtBatchBinarySmsResult> createBatchAsync(MtBatchBinarySmsCreate sms, FutureCallback<MtBatchBinarySmsResult> callback) {
        HttpPost req = this.post(this.batchesEndpoint(), sms);
        BasicAsyncRequestProducer requestProducer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer responseConsumer = this.jsonAsyncConsumer(MtBatchBinarySmsResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)requestProducer, responseConsumer, this.callbackWrapper().wrap(callback));
    }

    public MtBatchTextSmsResult replaceBatch(BatchId id, MtBatchTextSmsCreate sms) throws InterruptedException, ApiException {
        try {
            return this.replaceBatchAsync(id, sms, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<MtBatchTextSmsResult> replaceBatchAsync(BatchId id, MtBatchTextSmsCreate sms, FutureCallback<MtBatchTextSmsResult> callback) {
        HttpPut req = this.put(this.batchEndpoint(id), sms);
        BasicAsyncRequestProducer requestProducer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer responseConsumer = this.jsonAsyncConsumer(MtBatchTextSmsResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)requestProducer, responseConsumer, this.callbackWrapper().wrap(callback));
    }

    public MtBatchBinarySmsResult replaceBatch(BatchId id, MtBatchBinarySmsCreate sms) throws InterruptedException, ApiException {
        try {
            return this.replaceBatchAsync(id, sms, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<MtBatchBinarySmsResult> replaceBatchAsync(BatchId id, MtBatchBinarySmsCreate sms, FutureCallback<MtBatchBinarySmsResult> callback) {
        HttpPut req = this.put(this.batchEndpoint(id), sms);
        BasicAsyncRequestProducer requestProducer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer responseConsumer = this.jsonAsyncConsumer(MtBatchBinarySmsResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)requestProducer, responseConsumer, this.callbackWrapper().wrap(callback));
    }

    public MtBatchTextSmsResult updateBatch(BatchId id, MtBatchTextSmsUpdate sms) throws InterruptedException, ApiException {
        try {
            return this.updateBatchAsync(id, sms, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<MtBatchTextSmsResult> updateBatchAsync(BatchId batchId, MtBatchTextSmsUpdate sms, FutureCallback<MtBatchTextSmsResult> callback) {
        HttpPost req = this.post(this.batchEndpoint(batchId), sms);
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(MtBatchTextSmsResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public MtBatchBinarySmsResult updateBatch(BatchId id, MtBatchBinarySmsUpdate sms) throws InterruptedException, ApiException {
        try {
            return this.updateBatchAsync(id, sms, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<MtBatchBinarySmsResult> updateBatchAsync(BatchId batchId, MtBatchBinarySmsUpdate sms, FutureCallback<MtBatchBinarySmsResult> callback) {
        HttpPost req = this.post(this.batchEndpoint(batchId), sms);
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(MtBatchBinarySmsResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public MtBatchSmsResult fetchBatch(BatchId id) throws InterruptedException, ApiException {
        try {
            return this.fetchBatchAsync(id, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<MtBatchSmsResult> fetchBatchAsync(BatchId batchId, FutureCallback<MtBatchSmsResult> callback) {
        HttpGet req = this.get(this.batchEndpoint(batchId));
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(MtBatchSmsResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public PagedFetcher<MtBatchSmsResult> fetchBatches(final BatchFilter filter) {
        return new PagedFetcher<MtBatchSmsResult>(){

            @Override
            Future<Page<MtBatchSmsResult>> fetchAsync(int page, FutureCallback<Page<MtBatchSmsResult>> callback) {
                return ApiConnection.this.fetchBatches(page, filter, (FutureCallback<Page<MtBatchSmsResult>>)ApiConnection.this.callbackWrapper().wrap(callback));
            }
        };
    }

    private Future<Page<MtBatchSmsResult>> fetchBatches(int page, BatchFilter filter, FutureCallback<Page<MtBatchSmsResult>> callback) {
        List<NameValuePair> params = filter.toQueryParams(page);
        URI url = this.endpoint("/batches", params);
        HttpGet req = this.get(url);
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(PagedBatchResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public MtBatchSmsResult cancelBatch(BatchId batchId) throws InterruptedException, ApiException {
        try {
            return this.cancelBatchAsync(batchId, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<MtBatchSmsResult> cancelBatchAsync(BatchId batchId, FutureCallback<MtBatchSmsResult> callback) {
        HttpDelete req = this.delete(this.batchEndpoint(batchId));
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(MtBatchSmsResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public MtBatchDryRunResult createBatchDryRun(MtBatchSmsCreate sms, Boolean perRecipient, Integer numRecipients) throws InterruptedException, ApiException {
        try {
            return this.createBatchDryRunAsync(sms, perRecipient, numRecipients, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<MtBatchDryRunResult> createBatchDryRunAsync(MtBatchSmsCreate sms, Boolean perRecipient, Integer numRecipients, FutureCallback<MtBatchDryRunResult> callback) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        if (perRecipient != null) {
            params.add((NameValuePair)new BasicNameValuePair("per_recipient", perRecipient.toString()));
        }
        if (numRecipients != null) {
            params.add((NameValuePair)new BasicNameValuePair("number_of_recipients", numRecipients.toString()));
        }
        HttpPost req = this.post(this.batchDryRunEndpoint(params), sms);
        BasicAsyncRequestProducer requestProducer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer responseConsumer = this.jsonAsyncConsumer(MtBatchDryRunResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)requestProducer, responseConsumer, this.callbackWrapper().wrap(callback));
    }

    public BatchDeliveryReport fetchDeliveryReport(BatchId id, BatchDeliveryReportParams filter) throws InterruptedException, ApiException {
        try {
            return this.fetchDeliveryReportAsync(id, filter, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<BatchDeliveryReport> fetchDeliveryReportAsync(BatchId id, BatchDeliveryReportParams filter, FutureCallback<BatchDeliveryReport> callback) {
        List<NameValuePair> params = filter.toQueryParams();
        HttpGet req = this.get(this.batchDeliveryReportEndpoint(id, params));
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(BatchDeliveryReport.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public RecipientDeliveryReport fetchDeliveryReport(BatchId id, String recipient) throws InterruptedException, ApiException {
        try {
            return this.fetchDeliveryReportAsync(id, recipient, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<RecipientDeliveryReport> fetchDeliveryReportAsync(BatchId id, String recipient, FutureCallback<RecipientDeliveryReport> callback) {
        HttpGet req = this.get(this.batchRecipientDeliveryReportEndpoint(id, recipient));
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(RecipientDeliveryReport.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public PagedFetcher<RecipientDeliveryReport> fetchDeliveryReports(final DeliveryReportFilter filter) {
        return new PagedFetcher<RecipientDeliveryReport>(){

            @Override
            Future<Page<RecipientDeliveryReport>> fetchAsync(int page, FutureCallback<Page<RecipientDeliveryReport>> callback) {
                return ApiConnection.this.fetchDeliveryReports(page, filter, (FutureCallback<Page<RecipientDeliveryReport>>)ApiConnection.this.callbackWrapper().wrap(callback));
            }
        };
    }

    private Future<Page<RecipientDeliveryReport>> fetchDeliveryReports(int page, DeliveryReportFilter filter, FutureCallback<Page<RecipientDeliveryReport>> callback) {
        List<NameValuePair> params = filter.toQueryParams(page);
        HttpGet req = this.get(this.deliveryReportListEndpoint(params));
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(PagedDeliveryReportResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public Void createDeliveryFeedback(BatchId id, FeedbackDeliveryCreate feedbackDeliveryCreate) throws InterruptedException, ApiException {
        try {
            return this.createDeliveryFeedbackAsync(id, feedbackDeliveryCreate, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<Void> createDeliveryFeedbackAsync(BatchId id, FeedbackDeliveryCreate feedbackDeliveryCreate, FutureCallback<Void> callback) {
        HttpPost req = this.post(this.batchDeliveryFeedbackEndpoint(id), feedbackDeliveryCreate);
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(Void.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public Tags updateTags(BatchId id, TagsUpdate tags) throws InterruptedException, ApiException {
        try {
            return this.updateTagsAsync(id, tags, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<Tags> updateTagsAsync(BatchId id, TagsUpdate tags, FutureCallback<Tags> callback) {
        HttpPost req = this.post(this.batchTagsEndpoint(id), tags);
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(Tags.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public Tags replaceTags(BatchId id, Tags tags) throws InterruptedException, ApiException {
        try {
            return this.replaceTagsAsync(id, tags, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<Tags> replaceTagsAsync(BatchId id, Tags tags, FutureCallback<Tags> callback) {
        HttpPut req = this.put(this.batchTagsEndpoint(id), tags);
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(Tags.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public Tags fetchTags(BatchId id) throws InterruptedException, ApiException {
        try {
            return this.fetchTagsAsync(id, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<Tags> fetchTagsAsync(BatchId id, FutureCallback<Tags> callback) {
        HttpGet req = this.get(this.batchTagsEndpoint(id));
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(Tags.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public GroupResult createGroup(GroupCreate group) throws InterruptedException, ApiException {
        try {
            return this.createGroupAsync(group, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<GroupResult> createGroupAsync(GroupCreate group, FutureCallback<GroupResult> callback) {
        HttpPost req = this.post(this.groupsEndpoint(), group);
        BasicAsyncRequestProducer requestProducer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer responseConsumer = this.jsonAsyncConsumer(GroupResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)requestProducer, responseConsumer, this.callbackWrapper().wrap(callback));
    }

    public GroupResult fetchGroup(GroupId id) throws InterruptedException, ApiException {
        try {
            return this.fetchGroupAsync(id, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<GroupResult> fetchGroupAsync(GroupId id, FutureCallback<GroupResult> callback) {
        HttpGet req = this.get(this.groupEndpoint(id));
        BasicAsyncRequestProducer requestProducer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer responseConsumer = this.jsonAsyncConsumer(GroupResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)requestProducer, responseConsumer, this.callbackWrapper().wrap(callback));
    }

    public Set<String> fetchGroupMembers(GroupId id) throws InterruptedException, ApiException {
        try {
            return this.fetchGroupMembersAsync(id, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<Set<String>> fetchGroupMembersAsync(GroupId id, FutureCallback<Set<String>> callback) {
        HttpGet req = this.get(this.groupMembersEndpoint(id));
        BasicAsyncRequestProducer requestProducer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer responseConsumer = this.jsonAsyncConsumer(Set.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)requestProducer, responseConsumer, this.callbackWrapper().wrap(callback));
    }

    public PagedFetcher<GroupResult> fetchGroups(final GroupFilter filter) {
        return new PagedFetcher<GroupResult>(){

            @Override
            Future<Page<GroupResult>> fetchAsync(int page, FutureCallback<Page<GroupResult>> callback) {
                return ApiConnection.this.fetchGroups(page, filter, (FutureCallback<Page<GroupResult>>)ApiConnection.this.callbackWrapper().wrap(callback));
            }
        };
    }

    private Future<Page<GroupResult>> fetchGroups(int page, GroupFilter filter, FutureCallback<Page<GroupResult>> callback) {
        List<NameValuePair> params = filter.toQueryParams(page);
        HttpGet req = this.get(this.groupsEndpoint(params));
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(PagedGroupResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public GroupResult updateGroup(GroupId id, GroupUpdate group) throws InterruptedException, ApiException {
        try {
            return this.updateGroupAsync(id, group, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<GroupResult> updateGroupAsync(GroupId id, GroupUpdate group, FutureCallback<GroupResult> callback) {
        HttpPost req = this.post(this.groupEndpoint(id), group);
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(GroupResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public GroupResult replaceGroup(GroupId id, GroupCreate group) throws InterruptedException, ApiException {
        try {
            return this.replaceGroupAsync(id, group, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<GroupResult> replaceGroupAsync(GroupId id, GroupCreate group, FutureCallback<GroupResult> callback) {
        HttpPut req = this.put(this.groupEndpoint(id), group);
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(GroupResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public void deleteGroup(GroupId id) throws InterruptedException, ApiException {
        try {
            this.deleteGroupAsync(id, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<Void> deleteGroupAsync(GroupId id, FutureCallback<Void> callback) {
        HttpDelete req = this.delete(this.groupEndpoint(id));
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        EmptyAsyncConsumer consumer = new EmptyAsyncConsumer(this.json);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, (HttpAsyncResponseConsumer)consumer, this.callbackWrapper().wrap(callback));
    }

    public Tags updateTags(GroupId id, TagsUpdate tags) throws InterruptedException, ApiException {
        try {
            return this.updateTagsAsync(id, tags, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<Tags> updateTagsAsync(GroupId id, TagsUpdate tags, FutureCallback<Tags> callback) {
        HttpPost req = this.post(this.groupTagsEndpoint(id), tags);
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(Tags.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public Tags replaceTags(GroupId id, Tags tags) throws InterruptedException, ApiException {
        try {
            return this.replaceTagsAsync(id, tags, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<Tags> replaceTagsAsync(GroupId id, Tags tags, FutureCallback<Tags> callback) {
        HttpPut req = this.put(this.groupTagsEndpoint(id), tags);
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(Tags.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public Tags fetchTags(GroupId id) throws InterruptedException, ApiException {
        try {
            return this.fetchTagsAsync(id, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<Tags> fetchTagsAsync(GroupId id, FutureCallback<Tags> callback) {
        HttpGet req = this.get(this.groupTagsEndpoint(id));
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(Tags.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public PagedFetcher<MoSms> fetchInbounds(final InboundsFilter filter) {
        return new PagedFetcher<MoSms>(){

            @Override
            Future<Page<MoSms>> fetchAsync(int page, FutureCallback<Page<MoSms>> callback) {
                return ApiConnection.this.fetchInbounds(page, filter, (FutureCallback<Page<MoSms>>)ApiConnection.this.callbackWrapper().wrap(callback));
            }
        };
    }

    private Future<Page<MoSms>> fetchInbounds(int page, InboundsFilter filter, FutureCallback<Page<MoSms>> callback) {
        List<NameValuePair> params = filter.toQueryParams(page);
        HttpGet req = this.get(this.inboundsEndpoint(params));
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(PagedInboundsResult.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public MoSms fetchInbound(String id) throws InterruptedException, ApiException {
        try {
            return this.fetchInboundAsync(id, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    public Future<MoSms> fetchInboundAsync(String id, FutureCallback<MoSms> callback) {
        HttpGet req = this.get(this.inboundEndpoint(id));
        BasicAsyncRequestProducer producer = new BasicAsyncRequestProducer(this.endpointHost(), (HttpRequest)req);
        JsonApiAsyncConsumer consumer = this.jsonAsyncConsumer(MoSms.class);
        return this.httpClient().execute((HttpAsyncRequestProducer)producer, consumer, this.callbackWrapper().wrap(callback));
    }

    public static class Builder
    extends ApiConnectionImpl.Builder {
        Builder() {
        }

        public Builder endpoint(String url) {
            return this.endpoint(URI.create(url));
        }

        @Override
        public ApiConnection build() {
            return super.build();
        }

        public ApiConnection start() {
            ApiConnection conn = this.build();
            conn.start();
            return conn;
        }
    }
}

