/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.ApiConnection;
import com.sinch.xms.CallbackWrapper;
import java.net.URI;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.http.HttpHost;
import org.apache.http.nio.client.HttpAsyncClient;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class ApiConnectionImpl
extends ApiConnection {
    private final String token;
    private final String servicePlanId;
    private final boolean prettyPrintJson;
    private final HttpAsyncClient httpClient;
    private final CallbackWrapper callbackWrapper;
    private final URI endpoint;
    private final HttpHost endpointHost;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ApiConnectionImpl(String token, String servicePlanId, boolean prettyPrintJson, HttpAsyncClient httpClient, CallbackWrapper callbackWrapper, URI endpoint) {
        this.token = ApiConnectionImpl.requireNonNull(token, "token");
        this.servicePlanId = ApiConnectionImpl.requireNonNull(servicePlanId, "servicePlanId");
        this.prettyPrintJson = prettyPrintJson;
        this.httpClient = ApiConnectionImpl.requireNonNull(httpClient, "httpClient");
        this.callbackWrapper = ApiConnectionImpl.requireNonNull(callbackWrapper, "callbackWrapper");
        this.endpoint = ApiConnectionImpl.requireNonNull(endpoint, "endpoint");
        this.initShim.prettyPrintJson(this.prettyPrintJson);
        this.initShim.httpClient(this.httpClient);
        this.initShim.callbackWrapper(this.callbackWrapper);
        this.initShim.endpoint(this.endpoint);
        this.endpointHost = this.initShim.endpointHost();
        this.initShim = null;
    }

    private ApiConnectionImpl(Builder builder) {
        this.token = builder.token;
        this.servicePlanId = builder.servicePlanId;
        if (builder.prettyPrintJsonIsSet()) {
            this.initShim.prettyPrintJson(builder.prettyPrintJson);
        }
        if (builder.httpClient != null) {
            this.initShim.httpClient(builder.httpClient);
        }
        if (builder.callbackWrapper != null) {
            this.initShim.callbackWrapper(builder.callbackWrapper);
        }
        if (builder.endpoint != null) {
            this.initShim.endpoint(builder.endpoint);
        }
        this.prettyPrintJson = this.initShim.prettyPrintJson();
        this.httpClient = this.initShim.httpClient();
        this.callbackWrapper = this.initShim.callbackWrapper();
        this.endpoint = this.initShim.endpoint();
        this.endpointHost = this.initShim.endpointHost();
        this.initShim = null;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    public String servicePlanId() {
        return this.servicePlanId;
    }

    @Override
    public boolean prettyPrintJson() {
        InitShim shim = this.initShim;
        return shim != null ? shim.prettyPrintJson() : this.prettyPrintJson;
    }

    @Override
    public HttpAsyncClient httpClient() {
        InitShim shim = this.initShim;
        return shim != null ? shim.httpClient() : this.httpClient;
    }

    @Override
    public CallbackWrapper callbackWrapper() {
        InitShim shim = this.initShim;
        return shim != null ? shim.callbackWrapper() : this.callbackWrapper;
    }

    @Override
    public URI endpoint() {
        InitShim shim = this.initShim;
        return shim != null ? shim.endpoint() : this.endpoint;
    }

    @Override
    protected HttpHost endpointHost() {
        InitShim shim = this.initShim;
        return shim != null ? shim.endpointHost() : this.endpointHost;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ApiConnectionImpl && this.equalTo((ApiConnectionImpl)another);
    }

    private boolean equalTo(ApiConnectionImpl another) {
        return this.token.equals(another.token) && this.servicePlanId.equals(another.servicePlanId) && this.prettyPrintJson == another.prettyPrintJson && this.httpClient.equals(another.httpClient) && this.callbackWrapper.equals(another.callbackWrapper) && this.endpoint.equals(another.endpoint) && this.endpointHost.equals((Object)another.endpointHost);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.token.hashCode();
        h = h * 17 + this.servicePlanId.hashCode();
        h = h * 17 + (this.prettyPrintJson ? 1231 : 1237);
        h = h * 17 + this.httpClient.hashCode();
        h = h * 17 + this.callbackWrapper.hashCode();
        h = h * 17 + this.endpoint.hashCode();
        h = h * 17 + this.endpointHost.hashCode();
        return h;
    }

    public String toString() {
        return "ApiConnection{token=" + this.token + ", servicePlanId=" + this.servicePlanId + ", prettyPrintJson=" + this.prettyPrintJson + ", httpClient=" + this.httpClient + ", callbackWrapper=" + this.callbackWrapper + ", endpoint=" + this.endpoint + ", endpointHost=" + this.endpointHost + "}";
    }

    public static ApiConnection of(String token, String servicePlanId, boolean prettyPrintJson, HttpAsyncClient httpClient, CallbackWrapper callbackWrapper, URI endpoint) {
        return ApiConnectionImpl.validate(new ApiConnectionImpl(token, servicePlanId, prettyPrintJson, httpClient, callbackWrapper, endpoint));
    }

    private static ApiConnectionImpl validate(ApiConnectionImpl instance) {
        instance.check();
        return instance;
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_SERVICE_PLAN_ID = 2L;
        private static final long OPT_BIT_PRETTY_PRINT_JSON = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String token;
        @Nullable
        private String servicePlanId;
        private boolean prettyPrintJson;
        @Nullable
        private HttpAsyncClient httpClient;
        @Nullable
        private CallbackWrapper callbackWrapper;
        @Nullable
        private URI endpoint;

        Builder() {
            if (!(this instanceof ApiConnection.Builder)) {
                throw new UnsupportedOperationException("Use: new ApiConnection.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final ApiConnection.Builder using(ApiConnection instance) {
            ApiConnectionImpl.requireNonNull(instance, "instance");
            this.token(instance.token());
            this.servicePlanId(instance.servicePlanId());
            this.prettyPrintJson(instance.prettyPrintJson());
            this.httpClient(instance.httpClient());
            this.callbackWrapper(instance.callbackWrapper());
            this.endpoint(instance.endpoint());
            return (ApiConnection.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ApiConnection.Builder token(String token) {
            this.token = (String)ApiConnectionImpl.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (ApiConnection.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ApiConnection.Builder servicePlanId(String servicePlanId) {
            this.servicePlanId = (String)ApiConnectionImpl.requireNonNull(servicePlanId, "servicePlanId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (ApiConnection.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ApiConnection.Builder prettyPrintJson(boolean prettyPrintJson) {
            this.prettyPrintJson = prettyPrintJson;
            this.optBits |= 1L;
            return (ApiConnection.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ApiConnection.Builder httpClient(HttpAsyncClient httpClient) {
            this.httpClient = (HttpAsyncClient)ApiConnectionImpl.requireNonNull(httpClient, "httpClient");
            return (ApiConnection.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ApiConnection.Builder callbackWrapper(CallbackWrapper callbackWrapper) {
            this.callbackWrapper = (CallbackWrapper)ApiConnectionImpl.requireNonNull(callbackWrapper, "callbackWrapper");
            return (ApiConnection.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ApiConnection.Builder endpoint(URI endpoint) {
            this.endpoint = (URI)ApiConnectionImpl.requireNonNull(endpoint, "endpoint");
            return (ApiConnection.Builder)this;
        }

        public ApiConnection build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ApiConnectionImpl.validate(new ApiConnectionImpl(this));
        }

        private boolean prettyPrintJsonIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("servicePlanId");
            }
            return "Cannot build ApiConnection, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private boolean prettyPrintJson;
        private int prettyPrintJsonBuildStage;
        private HttpAsyncClient httpClient;
        private int httpClientBuildStage;
        private CallbackWrapper callbackWrapper;
        private int callbackWrapperBuildStage;
        private URI endpoint;
        private int endpointBuildStage;
        private HttpHost endpointHost;
        private int endpointHostBuildStage;

        private InitShim() {
        }

        boolean prettyPrintJson() {
            if (this.prettyPrintJsonBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.prettyPrintJsonBuildStage == 0) {
                this.prettyPrintJsonBuildStage = -1;
                this.prettyPrintJson = ApiConnectionImpl.super.prettyPrintJson();
                this.prettyPrintJsonBuildStage = 1;
            }
            return this.prettyPrintJson;
        }

        void prettyPrintJson(boolean prettyPrintJson) {
            this.prettyPrintJson = prettyPrintJson;
            this.prettyPrintJsonBuildStage = 1;
        }

        HttpAsyncClient httpClient() {
            if (this.httpClientBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.httpClientBuildStage == 0) {
                this.httpClientBuildStage = -1;
                this.httpClient = (HttpAsyncClient)ApiConnectionImpl.requireNonNull(ApiConnectionImpl.super.httpClient(), "httpClient");
                this.httpClientBuildStage = 1;
            }
            return this.httpClient;
        }

        void httpClient(HttpAsyncClient httpClient) {
            this.httpClient = httpClient;
            this.httpClientBuildStage = 1;
        }

        CallbackWrapper callbackWrapper() {
            if (this.callbackWrapperBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.callbackWrapperBuildStage == 0) {
                this.callbackWrapperBuildStage = -1;
                this.callbackWrapper = (CallbackWrapper)ApiConnectionImpl.requireNonNull(ApiConnectionImpl.super.callbackWrapper(), "callbackWrapper");
                this.callbackWrapperBuildStage = 1;
            }
            return this.callbackWrapper;
        }

        void callbackWrapper(CallbackWrapper callbackWrapper) {
            this.callbackWrapper = callbackWrapper;
            this.callbackWrapperBuildStage = 1;
        }

        URI endpoint() {
            if (this.endpointBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.endpointBuildStage == 0) {
                this.endpointBuildStage = -1;
                this.endpoint = (URI)ApiConnectionImpl.requireNonNull(ApiConnectionImpl.super.endpoint(), "endpoint");
                this.endpointBuildStage = 1;
            }
            return this.endpoint;
        }

        void endpoint(URI endpoint) {
            this.endpoint = endpoint;
            this.endpointBuildStage = 1;
        }

        HttpHost endpointHost() {
            if (this.endpointHostBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.endpointHostBuildStage == 0) {
                this.endpointHostBuildStage = -1;
                this.endpointHost = (HttpHost)ApiConnectionImpl.requireNonNull(ApiConnectionImpl.super.endpointHost(), "endpointHost");
                this.endpointHostBuildStage = 1;
            }
            return this.endpointHost;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.prettyPrintJsonBuildStage == -1) {
                attributes.add("prettyPrintJson");
            }
            if (this.httpClientBuildStage == -1) {
                attributes.add("httpClient");
            }
            if (this.callbackWrapperBuildStage == -1) {
                attributes.add("callbackWrapper");
            }
            if (this.endpointBuildStage == -1) {
                attributes.add("endpoint");
            }
            if (this.endpointHostBuildStage == -1) {
                attributes.add("endpointHost");
            }
            return "Cannot build ApiConnection, attribute initializers form cycle" + attributes;
        }
    }
}

