/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;

public class ApiHttpAsyncClient
implements HttpAsyncClient,
Closeable {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    private static final int DEFAULT_MAX_CONN = 100;
    private boolean startedInternally;
    private final CloseableHttpAsyncClient client;

    ApiHttpAsyncClient(boolean startedInternally) {
        this.startedInternally = startedInternally;
        SSLIOSessionStrategy sslSessionStrategy = new SSLIOSessionStrategy(SSLContexts.createSystemDefault(), new String[]{"TLSv1.2"}, null, SSLIOSessionStrategy.getDefaultHostnameVerifier());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)DEFAULT_TIMEOUT.toMillis()).setSocketTimeout((int)DEFAULT_TIMEOUT.toMillis()).build();
        this.client = HttpAsyncClients.custom().setSSLStrategy((SchemeIOSessionStrategy)sslSessionStrategy).disableCookieManagement().setMaxConnPerRoute(100).setMaxConnTotal(100).setKeepAliveStrategy((response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                return Long.parseLong(value) * 1000L;
            }
            return 5000L;
        }).setDefaultRequestConfig(requestConfig).build();
    }

    @Nonnull
    public static ApiHttpAsyncClient of() {
        return new ApiHttpAsyncClient(false);
    }

    boolean isStartedInternally() {
        return this.startedInternally;
    }

    public boolean isRunning() {
        return this.client.isRunning();
    }

    public void start() {
        this.client.start();
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        return this.client.execute(requestProducer, responseConsumer, context, callback);
    }

    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.client.execute(requestProducer, responseConsumer, callback);
    }

    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        return this.client.execute(target, request, context, callback);
    }

    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, FutureCallback<HttpResponse> callback) {
        return this.client.execute(target, request, callback);
    }

    public Future<HttpResponse> execute(HttpUriRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        return this.client.execute(request, context, callback);
    }

    public Future<HttpResponse> execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        return this.client.execute(request, callback);
    }
}

