/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.sinch.xms.BatchDeliveryReportParamsImpl;
import com.sinch.xms.Utils;
import com.sinch.xms.ValueStylePackage;
import com.sinch.xms.api.DeliveryStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.immutables.value.Value;

@Value.Immutable
@ValueStylePackage
public abstract class BatchDeliveryReportParams {
    @Nonnull
    public static final Builder builder() {
        return new Builder();
    }

    @Nullable
    public abstract ReportType reportType();

    public abstract Set<DeliveryStatus> statuses();

    public abstract Set<Integer> codes();

    @Nonnull
    List<NameValuePair> toQueryParams() {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(6);
        if (this.reportType() != null) {
            params.add((NameValuePair)new BasicNameValuePair("type", this.reportType().name().toLowerCase(Locale.US)));
        }
        if (!this.statuses().isEmpty()) {
            ArrayList<String> statusStrings = new ArrayList<String>(this.statuses().size());
            for (DeliveryStatus s : this.statuses()) {
                statusStrings.add(s.status());
            }
            params.add((NameValuePair)new BasicNameValuePair("status", Utils.join(",", statusStrings)));
        }
        if (!this.codes().isEmpty()) {
            ArrayList<String> codeStrings = new ArrayList<String>(this.codes().size());
            for (Integer code : this.codes()) {
                codeStrings.add(code.toString());
            }
            params.add((NameValuePair)new BasicNameValuePair("code", Utils.join(",", codeStrings)));
        }
        return params;
    }

    public static class Builder
    extends BatchDeliveryReportParamsImpl.Builder {
        Builder() {
        }

        public Builder summaryReport() {
            return this.reportType(ReportType.SUMMARY);
        }

        public Builder fullReport() {
            return this.reportType(ReportType.FULL);
        }
    }

    public static enum ReportType {
        SUMMARY,
        FULL;

    }
}

