/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.BatchDeliveryReportParams;
import com.sinch.xms.api.DeliveryStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class BatchDeliveryReportParamsImpl
extends BatchDeliveryReportParams {
    @Nullable
    private final BatchDeliveryReportParams.ReportType reportType;
    private final Set<DeliveryStatus> statuses;
    private final Set<Integer> codes;

    private BatchDeliveryReportParamsImpl(@Nullable BatchDeliveryReportParams.ReportType reportType, Set<DeliveryStatus> statuses, Set<Integer> codes) {
        this.reportType = reportType;
        this.statuses = statuses;
        this.codes = codes;
    }

    @Override
    @Nullable
    public BatchDeliveryReportParams.ReportType reportType() {
        return this.reportType;
    }

    @Override
    public Set<DeliveryStatus> statuses() {
        return this.statuses;
    }

    @Override
    public Set<Integer> codes() {
        return this.codes;
    }

    public final BatchDeliveryReportParamsImpl withReportType(@Nullable BatchDeliveryReportParams.ReportType value) {
        if (this.reportType == value) {
            return this;
        }
        return new BatchDeliveryReportParamsImpl(value, this.statuses, this.codes);
    }

    public final BatchDeliveryReportParamsImpl withStatuses(DeliveryStatus ... elements) {
        Set<DeliveryStatus> newValue = BatchDeliveryReportParamsImpl.createUnmodifiableSet(BatchDeliveryReportParamsImpl.createSafeList(Arrays.asList(elements), true, false));
        return new BatchDeliveryReportParamsImpl(this.reportType, newValue, this.codes);
    }

    public final BatchDeliveryReportParamsImpl withStatuses(Iterable<? extends DeliveryStatus> elements) {
        if (this.statuses == elements) {
            return this;
        }
        Set<DeliveryStatus> newValue = BatchDeliveryReportParamsImpl.createUnmodifiableSet(BatchDeliveryReportParamsImpl.createSafeList(elements, true, false));
        return new BatchDeliveryReportParamsImpl(this.reportType, newValue, this.codes);
    }

    public final BatchDeliveryReportParamsImpl withCodes(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        Set<Integer> newValue = BatchDeliveryReportParamsImpl.createUnmodifiableSet(wrappedList);
        return new BatchDeliveryReportParamsImpl(this.reportType, this.statuses, newValue);
    }

    public final BatchDeliveryReportParamsImpl withCodes(Iterable<Integer> elements) {
        if (this.codes == elements) {
            return this;
        }
        Set<Integer> newValue = BatchDeliveryReportParamsImpl.createUnmodifiableSet(BatchDeliveryReportParamsImpl.createSafeList(elements, true, false));
        return new BatchDeliveryReportParamsImpl(this.reportType, this.statuses, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BatchDeliveryReportParamsImpl && this.equalTo((BatchDeliveryReportParamsImpl)another);
    }

    private boolean equalTo(BatchDeliveryReportParamsImpl another) {
        return BatchDeliveryReportParamsImpl.equals((Object)this.reportType, (Object)another.reportType) && this.statuses.equals(another.statuses) && this.codes.equals(another.codes);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + BatchDeliveryReportParamsImpl.hashCode((Object)this.reportType);
        h = h * 17 + this.statuses.hashCode();
        h = h * 17 + this.codes.hashCode();
        return h;
    }

    public String toString() {
        return "BatchDeliveryReportParams{reportType=" + (Object)((Object)this.reportType) + ", statuses=" + this.statuses + ", codes=" + this.codes + "}";
    }

    public static BatchDeliveryReportParams copyOf(BatchDeliveryReportParams instance) {
        if (instance instanceof BatchDeliveryReportParamsImpl) {
            return (BatchDeliveryReportParamsImpl)instance;
        }
        return new BatchDeliveryReportParams.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                BatchDeliveryReportParamsImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    static class Builder {
        @Nullable
        private BatchDeliveryReportParams.ReportType reportType;
        private List<DeliveryStatus> statuses = new ArrayList<DeliveryStatus>();
        private List<Integer> codes = new ArrayList<Integer>();

        Builder() {
            if (!(this instanceof BatchDeliveryReportParams.Builder)) {
                throw new UnsupportedOperationException("Use: new BatchDeliveryReportParams.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final BatchDeliveryReportParams.Builder using(BatchDeliveryReportParams instance) {
            BatchDeliveryReportParamsImpl.requireNonNull(instance, "instance");
            BatchDeliveryReportParams.ReportType reportTypeValue = instance.reportType();
            if (reportTypeValue != null) {
                this.reportType(reportTypeValue);
            }
            this.addAllStatuses(instance.statuses());
            this.addAllCodes(instance.codes());
            return (BatchDeliveryReportParams.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchDeliveryReportParams.Builder reportType(@Nullable BatchDeliveryReportParams.ReportType reportType) {
            this.reportType = reportType;
            return (BatchDeliveryReportParams.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchDeliveryReportParams.Builder addStatus(DeliveryStatus element) {
            this.statuses.add((DeliveryStatus)BatchDeliveryReportParamsImpl.requireNonNull(element, "statuses element"));
            return (BatchDeliveryReportParams.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchDeliveryReportParams.Builder addStatus(DeliveryStatus ... elements) {
            for (DeliveryStatus element : elements) {
                this.statuses.add((DeliveryStatus)BatchDeliveryReportParamsImpl.requireNonNull(element, "statuses element"));
            }
            return (BatchDeliveryReportParams.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchDeliveryReportParams.Builder statuses(Iterable<? extends DeliveryStatus> elements) {
            this.statuses.clear();
            return this.addAllStatuses(elements);
        }

        @CanIgnoreReturnValue
        public final BatchDeliveryReportParams.Builder addAllStatuses(Iterable<? extends DeliveryStatus> elements) {
            for (DeliveryStatus deliveryStatus : elements) {
                this.statuses.add((DeliveryStatus)BatchDeliveryReportParamsImpl.requireNonNull(deliveryStatus, "statuses element"));
            }
            return (BatchDeliveryReportParams.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchDeliveryReportParams.Builder addCode(int element) {
            this.codes.add(element);
            return (BatchDeliveryReportParams.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchDeliveryReportParams.Builder addCode(int ... elements) {
            for (int element : elements) {
                this.codes.add(element);
            }
            return (BatchDeliveryReportParams.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchDeliveryReportParams.Builder codes(Iterable<Integer> elements) {
            this.codes.clear();
            return this.addAllCodes(elements);
        }

        @CanIgnoreReturnValue
        public final BatchDeliveryReportParams.Builder addAllCodes(Iterable<Integer> elements) {
            for (int element : elements) {
                this.codes.add((Integer)BatchDeliveryReportParamsImpl.requireNonNull(element, "codes element"));
            }
            return (BatchDeliveryReportParams.Builder)this;
        }

        public BatchDeliveryReportParams build() {
            return new BatchDeliveryReportParamsImpl(this.reportType, BatchDeliveryReportParamsImpl.createUnmodifiableSet(this.statuses), BatchDeliveryReportParamsImpl.createUnmodifiableSet(this.codes));
        }
    }
}

