/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.sinch.xms.BatchFilterImpl;
import com.sinch.xms.Utils;
import com.sinch.xms.ValueStylePackage;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.immutables.value.Value;

@Value.Immutable
@ValueStylePackage
public abstract class BatchFilter {
    @Nonnull
    public static final Builder builder() {
        return new Builder();
    }

    @Value.Default
    public int pageSize() {
        return 0;
    }

    @Nullable
    public abstract OffsetDateTime startDate();

    @Nullable
    public abstract OffsetDateTime endDate();

    public abstract Set<String> senders();

    public abstract Set<String> tags();

    @Nullable
    public abstract String clientReference();

    @Value.Check
    protected void check() {
        for (String s : this.senders()) {
            if (!s.contains(",")) continue;
            throw new IllegalStateException("from contains comma");
        }
        for (String s : this.tags()) {
            if (!s.contains(",")) continue;
            throw new IllegalStateException("tags contains comma");
        }
    }

    @Nonnull
    List<NameValuePair> toQueryParams(int page) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(6);
        params.add((NameValuePair)new BasicNameValuePair("page", String.valueOf(page)));
        if (this.pageSize() > 0) {
            params.add((NameValuePair)new BasicNameValuePair("page_size", String.valueOf(this.pageSize())));
        }
        if (this.startDate() != null) {
            params.add((NameValuePair)new BasicNameValuePair("start_date", this.startDate().toString()));
        }
        if (this.endDate() != null) {
            params.add((NameValuePair)new BasicNameValuePair("end_date", this.endDate().toString()));
        }
        if (!this.senders().isEmpty()) {
            params.add((NameValuePair)new BasicNameValuePair("from", Utils.join(",", this.senders())));
        }
        if (!this.tags().isEmpty()) {
            params.add((NameValuePair)new BasicNameValuePair("tags", Utils.join(",", this.tags())));
        }
        if (this.clientReference() != null) {
            params.add((NameValuePair)new BasicNameValuePair("client_reference", this.clientReference()));
        }
        return params;
    }

    public static class Builder
    extends BatchFilterImpl.Builder {
        Builder() {
        }
    }
}

