/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.BatchFilter;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class BatchFilterImpl
extends BatchFilter {
    private final int pageSize;
    @Nullable
    private final OffsetDateTime startDate;
    @Nullable
    private final OffsetDateTime endDate;
    private final Set<String> senders;
    private final Set<String> tags;
    @Nullable
    private final String clientReference;

    private BatchFilterImpl(Builder builder) {
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.senders = BatchFilterImpl.createUnmodifiableSet(builder.senders);
        this.tags = BatchFilterImpl.createUnmodifiableSet(builder.tags);
        this.clientReference = builder.clientReference;
        this.pageSize = builder.pageSizeIsSet() ? builder.pageSize : super.pageSize();
    }

    private BatchFilterImpl(int pageSize, @Nullable OffsetDateTime startDate, @Nullable OffsetDateTime endDate, Set<String> senders, Set<String> tags, @Nullable String clientReference) {
        this.pageSize = pageSize;
        this.startDate = startDate;
        this.endDate = endDate;
        this.senders = senders;
        this.tags = tags;
        this.clientReference = clientReference;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    @Nullable
    public OffsetDateTime startDate() {
        return this.startDate;
    }

    @Override
    @Nullable
    public OffsetDateTime endDate() {
        return this.endDate;
    }

    @Override
    public Set<String> senders() {
        return this.senders;
    }

    @Override
    public Set<String> tags() {
        return this.tags;
    }

    @Override
    @Nullable
    public String clientReference() {
        return this.clientReference;
    }

    public final BatchFilterImpl withPageSize(int value) {
        if (this.pageSize == value) {
            return this;
        }
        return BatchFilterImpl.validate(new BatchFilterImpl(value, this.startDate, this.endDate, this.senders, this.tags, this.clientReference));
    }

    public final BatchFilterImpl withStartDate(@Nullable OffsetDateTime value) {
        if (this.startDate == value) {
            return this;
        }
        return BatchFilterImpl.validate(new BatchFilterImpl(this.pageSize, value, this.endDate, this.senders, this.tags, this.clientReference));
    }

    public final BatchFilterImpl withEndDate(@Nullable OffsetDateTime value) {
        if (this.endDate == value) {
            return this;
        }
        return BatchFilterImpl.validate(new BatchFilterImpl(this.pageSize, this.startDate, value, this.senders, this.tags, this.clientReference));
    }

    public final BatchFilterImpl withSenders(String ... elements) {
        Set<String> newValue = BatchFilterImpl.createUnmodifiableSet(BatchFilterImpl.createSafeList(Arrays.asList(elements), true, false));
        return BatchFilterImpl.validate(new BatchFilterImpl(this.pageSize, this.startDate, this.endDate, newValue, this.tags, this.clientReference));
    }

    public final BatchFilterImpl withSenders(Iterable<String> elements) {
        if (this.senders == elements) {
            return this;
        }
        Set<String> newValue = BatchFilterImpl.createUnmodifiableSet(BatchFilterImpl.createSafeList(elements, true, false));
        return BatchFilterImpl.validate(new BatchFilterImpl(this.pageSize, this.startDate, this.endDate, newValue, this.tags, this.clientReference));
    }

    public final BatchFilterImpl withTags(String ... elements) {
        Set<String> newValue = BatchFilterImpl.createUnmodifiableSet(BatchFilterImpl.createSafeList(Arrays.asList(elements), true, false));
        return BatchFilterImpl.validate(new BatchFilterImpl(this.pageSize, this.startDate, this.endDate, this.senders, newValue, this.clientReference));
    }

    public final BatchFilterImpl withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        Set<String> newValue = BatchFilterImpl.createUnmodifiableSet(BatchFilterImpl.createSafeList(elements, true, false));
        return BatchFilterImpl.validate(new BatchFilterImpl(this.pageSize, this.startDate, this.endDate, this.senders, newValue, this.clientReference));
    }

    public final BatchFilterImpl withClientReference(@Nullable String value) {
        if (BatchFilterImpl.equals(this.clientReference, value)) {
            return this;
        }
        return BatchFilterImpl.validate(new BatchFilterImpl(this.pageSize, this.startDate, this.endDate, this.senders, this.tags, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BatchFilterImpl && this.equalTo((BatchFilterImpl)another);
    }

    private boolean equalTo(BatchFilterImpl another) {
        return this.pageSize == another.pageSize && BatchFilterImpl.equals(this.startDate, another.startDate) && BatchFilterImpl.equals(this.endDate, another.endDate) && this.senders.equals(another.senders) && this.tags.equals(another.tags) && BatchFilterImpl.equals(this.clientReference, another.clientReference);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.pageSize;
        h = h * 17 + BatchFilterImpl.hashCode(this.startDate);
        h = h * 17 + BatchFilterImpl.hashCode(this.endDate);
        h = h * 17 + this.senders.hashCode();
        h = h * 17 + this.tags.hashCode();
        h = h * 17 + BatchFilterImpl.hashCode(this.clientReference);
        return h;
    }

    public String toString() {
        return "BatchFilter{pageSize=" + this.pageSize + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", senders=" + this.senders + ", tags=" + this.tags + ", clientReference=" + this.clientReference + "}";
    }

    private static BatchFilterImpl validate(BatchFilterImpl instance) {
        instance.check();
        return instance;
    }

    public static BatchFilter copyOf(BatchFilter instance) {
        if (instance instanceof BatchFilterImpl) {
            return (BatchFilterImpl)instance;
        }
        return new BatchFilter.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                BatchFilterImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    static class Builder {
        private static final long OPT_BIT_PAGE_SIZE = 1L;
        private long optBits;
        private int pageSize;
        @Nullable
        private OffsetDateTime startDate;
        @Nullable
        private OffsetDateTime endDate;
        private List<String> senders = new ArrayList<String>();
        private List<String> tags = new ArrayList<String>();
        @Nullable
        private String clientReference;

        Builder() {
            if (!(this instanceof BatchFilter.Builder)) {
                throw new UnsupportedOperationException("Use: new BatchFilter.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final BatchFilter.Builder using(BatchFilter instance) {
            OffsetDateTime endDateValue;
            BatchFilterImpl.requireNonNull(instance, "instance");
            this.pageSize(instance.pageSize());
            OffsetDateTime startDateValue = instance.startDate();
            if (startDateValue != null) {
                this.startDate(startDateValue);
            }
            if ((endDateValue = instance.endDate()) != null) {
                this.endDate(endDateValue);
            }
            this.addAllSenders(instance.senders());
            this.addAllTags(instance.tags());
            String clientReferenceValue = instance.clientReference();
            if (clientReferenceValue != null) {
                this.clientReference(clientReferenceValue);
            }
            return (BatchFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchFilter.Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            this.optBits |= 1L;
            return (BatchFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchFilter.Builder startDate(@Nullable OffsetDateTime startDate) {
            this.startDate = startDate;
            return (BatchFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchFilter.Builder endDate(@Nullable OffsetDateTime endDate) {
            this.endDate = endDate;
            return (BatchFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchFilter.Builder addSender(String element) {
            this.senders.add((String)BatchFilterImpl.requireNonNull(element, "senders element"));
            return (BatchFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchFilter.Builder addSender(String ... elements) {
            for (String element : elements) {
                this.senders.add((String)BatchFilterImpl.requireNonNull(element, "senders element"));
            }
            return (BatchFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchFilter.Builder senders(Iterable<String> elements) {
            this.senders.clear();
            return this.addAllSenders(elements);
        }

        @CanIgnoreReturnValue
        public final BatchFilter.Builder addAllSenders(Iterable<String> elements) {
            for (String element : elements) {
                this.senders.add((String)BatchFilterImpl.requireNonNull(element, "senders element"));
            }
            return (BatchFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchFilter.Builder addTag(String element) {
            this.tags.add((String)BatchFilterImpl.requireNonNull(element, "tags element"));
            return (BatchFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchFilter.Builder addTag(String ... elements) {
            for (String element : elements) {
                this.tags.add((String)BatchFilterImpl.requireNonNull(element, "tags element"));
            }
            return (BatchFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchFilter.Builder tags(Iterable<String> elements) {
            this.tags.clear();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final BatchFilter.Builder addAllTags(Iterable<String> elements) {
            for (String element : elements) {
                this.tags.add((String)BatchFilterImpl.requireNonNull(element, "tags element"));
            }
            return (BatchFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchFilter.Builder clientReference(@Nullable String clientReference) {
            this.clientReference = clientReference;
            return (BatchFilter.Builder)this;
        }

        public BatchFilter build() {
            return BatchFilterImpl.validate(new BatchFilterImpl(this));
        }

        private boolean pageSizeIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

