/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class ByteInOutStream
extends ByteArrayOutputStream {
    public ByteInOutStream(int initialSize) {
        super(initialSize);
    }

    public void write(ByteBuffer buf) {
        if (buf.hasArray()) {
            this.write(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
        } else {
            for (int i = buf.position(); i < buf.limit(); ++i) {
                this.write(buf.get(i));
            }
        }
    }

    @Nonnull
    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }
}

