/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.sinch.xms.DeliveryReportFilterImpl;
import com.sinch.xms.Utils;
import com.sinch.xms.ValueStylePackage;
import com.sinch.xms.api.FinalizedDeliveryStatus;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.immutables.value.Value;

@Value.Immutable
@ValueStylePackage
public abstract class DeliveryReportFilter {
    @Nonnull
    public static final Builder builder() {
        return new Builder();
    }

    @Value.Default
    public int pageSize() {
        return 0;
    }

    @Nullable
    public abstract OffsetDateTime startDate();

    @Nullable
    public abstract OffsetDateTime endDate();

    public abstract Set<FinalizedDeliveryStatus> statuses();

    public abstract Set<Integer> codes();

    @Nullable
    public abstract String clientReference();

    @Nonnull
    List<NameValuePair> toQueryParams(int page) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(6);
        params.add((NameValuePair)new BasicNameValuePair("page", String.valueOf(page)));
        if (this.pageSize() > 0) {
            params.add((NameValuePair)new BasicNameValuePair("page_size", String.valueOf(this.pageSize())));
        }
        if (!this.statuses().isEmpty()) {
            params.add((NameValuePair)new BasicNameValuePair("status", Utils.join(",", this.mapStatuses())));
        }
        if (!this.codes().isEmpty()) {
            params.add((NameValuePair)new BasicNameValuePair("code", Utils.join(",", this.mapCodes())));
        }
        if (this.startDate() != null) {
            params.add((NameValuePair)new BasicNameValuePair("start_date", this.startDate().toString()));
        }
        if (this.endDate() != null) {
            params.add((NameValuePair)new BasicNameValuePair("end_date", this.endDate().toString()));
        }
        if (this.clientReference() != null) {
            params.add((NameValuePair)new BasicNameValuePair("client_reference", this.clientReference()));
        }
        return params;
    }

    private List<String> mapCodes() {
        return this.codes().stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList());
    }

    private List<String> mapStatuses() {
        return this.statuses().stream().filter(Objects::nonNull).map(FinalizedDeliveryStatus::status).collect(Collectors.toList());
    }

    public static class Builder
    extends DeliveryReportFilterImpl.Builder {
        Builder() {
        }
    }
}

