/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.DeliveryReportFilter;
import com.sinch.xms.api.FinalizedDeliveryStatus;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class DeliveryReportFilterImpl
extends DeliveryReportFilter {
    private final int pageSize;
    @Nullable
    private final OffsetDateTime startDate;
    @Nullable
    private final OffsetDateTime endDate;
    private final Set<FinalizedDeliveryStatus> statuses;
    private final Set<Integer> codes;
    @Nullable
    private final String clientReference;

    private DeliveryReportFilterImpl(Builder builder) {
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.statuses = DeliveryReportFilterImpl.createUnmodifiableSet(builder.statuses);
        this.codes = DeliveryReportFilterImpl.createUnmodifiableSet(builder.codes);
        this.clientReference = builder.clientReference;
        this.pageSize = builder.pageSizeIsSet() ? builder.pageSize : super.pageSize();
    }

    private DeliveryReportFilterImpl(int pageSize, @Nullable OffsetDateTime startDate, @Nullable OffsetDateTime endDate, Set<FinalizedDeliveryStatus> statuses, Set<Integer> codes, @Nullable String clientReference) {
        this.pageSize = pageSize;
        this.startDate = startDate;
        this.endDate = endDate;
        this.statuses = statuses;
        this.codes = codes;
        this.clientReference = clientReference;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    @Nullable
    public OffsetDateTime startDate() {
        return this.startDate;
    }

    @Override
    @Nullable
    public OffsetDateTime endDate() {
        return this.endDate;
    }

    @Override
    public Set<FinalizedDeliveryStatus> statuses() {
        return this.statuses;
    }

    @Override
    public Set<Integer> codes() {
        return this.codes;
    }

    @Override
    @Nullable
    public String clientReference() {
        return this.clientReference;
    }

    public final DeliveryReportFilterImpl withPageSize(int value) {
        if (this.pageSize == value) {
            return this;
        }
        return new DeliveryReportFilterImpl(value, this.startDate, this.endDate, this.statuses, this.codes, this.clientReference);
    }

    public final DeliveryReportFilterImpl withStartDate(@Nullable OffsetDateTime value) {
        if (this.startDate == value) {
            return this;
        }
        return new DeliveryReportFilterImpl(this.pageSize, value, this.endDate, this.statuses, this.codes, this.clientReference);
    }

    public final DeliveryReportFilterImpl withEndDate(@Nullable OffsetDateTime value) {
        if (this.endDate == value) {
            return this;
        }
        return new DeliveryReportFilterImpl(this.pageSize, this.startDate, value, this.statuses, this.codes, this.clientReference);
    }

    public final DeliveryReportFilterImpl withStatuses(FinalizedDeliveryStatus ... elements) {
        Set<FinalizedDeliveryStatus> newValue = DeliveryReportFilterImpl.createUnmodifiableSet(DeliveryReportFilterImpl.createSafeList(Arrays.asList(elements), true, false));
        return new DeliveryReportFilterImpl(this.pageSize, this.startDate, this.endDate, newValue, this.codes, this.clientReference);
    }

    public final DeliveryReportFilterImpl withStatuses(Iterable<? extends FinalizedDeliveryStatus> elements) {
        if (this.statuses == elements) {
            return this;
        }
        Set<FinalizedDeliveryStatus> newValue = DeliveryReportFilterImpl.createUnmodifiableSet(DeliveryReportFilterImpl.createSafeList(elements, true, false));
        return new DeliveryReportFilterImpl(this.pageSize, this.startDate, this.endDate, newValue, this.codes, this.clientReference);
    }

    public final DeliveryReportFilterImpl withCodes(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        Set<Integer> newValue = DeliveryReportFilterImpl.createUnmodifiableSet(wrappedList);
        return new DeliveryReportFilterImpl(this.pageSize, this.startDate, this.endDate, this.statuses, newValue, this.clientReference);
    }

    public final DeliveryReportFilterImpl withCodes(Iterable<Integer> elements) {
        if (this.codes == elements) {
            return this;
        }
        Set<Integer> newValue = DeliveryReportFilterImpl.createUnmodifiableSet(DeliveryReportFilterImpl.createSafeList(elements, true, false));
        return new DeliveryReportFilterImpl(this.pageSize, this.startDate, this.endDate, this.statuses, newValue, this.clientReference);
    }

    public final DeliveryReportFilterImpl withClientReference(@Nullable String value) {
        if (DeliveryReportFilterImpl.equals(this.clientReference, value)) {
            return this;
        }
        return new DeliveryReportFilterImpl(this.pageSize, this.startDate, this.endDate, this.statuses, this.codes, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DeliveryReportFilterImpl && this.equalTo((DeliveryReportFilterImpl)another);
    }

    private boolean equalTo(DeliveryReportFilterImpl another) {
        return this.pageSize == another.pageSize && DeliveryReportFilterImpl.equals(this.startDate, another.startDate) && DeliveryReportFilterImpl.equals(this.endDate, another.endDate) && this.statuses.equals(another.statuses) && this.codes.equals(another.codes) && DeliveryReportFilterImpl.equals(this.clientReference, another.clientReference);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.pageSize;
        h = h * 17 + DeliveryReportFilterImpl.hashCode(this.startDate);
        h = h * 17 + DeliveryReportFilterImpl.hashCode(this.endDate);
        h = h * 17 + this.statuses.hashCode();
        h = h * 17 + this.codes.hashCode();
        h = h * 17 + DeliveryReportFilterImpl.hashCode(this.clientReference);
        return h;
    }

    public String toString() {
        return "DeliveryReportFilter{pageSize=" + this.pageSize + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", statuses=" + this.statuses + ", codes=" + this.codes + ", clientReference=" + this.clientReference + "}";
    }

    public static DeliveryReportFilter copyOf(DeliveryReportFilter instance) {
        if (instance instanceof DeliveryReportFilterImpl) {
            return (DeliveryReportFilterImpl)instance;
        }
        return new DeliveryReportFilter.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                DeliveryReportFilterImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    static class Builder {
        private static final long OPT_BIT_PAGE_SIZE = 1L;
        private long optBits;
        private int pageSize;
        @Nullable
        private OffsetDateTime startDate;
        @Nullable
        private OffsetDateTime endDate;
        private List<FinalizedDeliveryStatus> statuses = new ArrayList<FinalizedDeliveryStatus>();
        private List<Integer> codes = new ArrayList<Integer>();
        @Nullable
        private String clientReference;

        Builder() {
            if (!(this instanceof DeliveryReportFilter.Builder)) {
                throw new UnsupportedOperationException("Use: new DeliveryReportFilter.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final DeliveryReportFilter.Builder using(DeliveryReportFilter instance) {
            OffsetDateTime endDateValue;
            DeliveryReportFilterImpl.requireNonNull(instance, "instance");
            this.pageSize(instance.pageSize());
            OffsetDateTime startDateValue = instance.startDate();
            if (startDateValue != null) {
                this.startDate(startDateValue);
            }
            if ((endDateValue = instance.endDate()) != null) {
                this.endDate(endDateValue);
            }
            this.addAllStatuses(instance.statuses());
            this.addAllCodes(instance.codes());
            String clientReferenceValue = instance.clientReference();
            if (clientReferenceValue != null) {
                this.clientReference(clientReferenceValue);
            }
            return (DeliveryReportFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DeliveryReportFilter.Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            this.optBits |= 1L;
            return (DeliveryReportFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DeliveryReportFilter.Builder startDate(@Nullable OffsetDateTime startDate) {
            this.startDate = startDate;
            return (DeliveryReportFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DeliveryReportFilter.Builder endDate(@Nullable OffsetDateTime endDate) {
            this.endDate = endDate;
            return (DeliveryReportFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DeliveryReportFilter.Builder addStatus(FinalizedDeliveryStatus element) {
            this.statuses.add((FinalizedDeliveryStatus)DeliveryReportFilterImpl.requireNonNull(element, "statuses element"));
            return (DeliveryReportFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DeliveryReportFilter.Builder addStatus(FinalizedDeliveryStatus ... elements) {
            for (FinalizedDeliveryStatus element : elements) {
                this.statuses.add((FinalizedDeliveryStatus)DeliveryReportFilterImpl.requireNonNull(element, "statuses element"));
            }
            return (DeliveryReportFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DeliveryReportFilter.Builder statuses(Iterable<? extends FinalizedDeliveryStatus> elements) {
            this.statuses.clear();
            return this.addAllStatuses(elements);
        }

        @CanIgnoreReturnValue
        public final DeliveryReportFilter.Builder addAllStatuses(Iterable<? extends FinalizedDeliveryStatus> elements) {
            for (FinalizedDeliveryStatus finalizedDeliveryStatus : elements) {
                this.statuses.add((FinalizedDeliveryStatus)DeliveryReportFilterImpl.requireNonNull(finalizedDeliveryStatus, "statuses element"));
            }
            return (DeliveryReportFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DeliveryReportFilter.Builder addCode(int element) {
            this.codes.add(element);
            return (DeliveryReportFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DeliveryReportFilter.Builder addCode(int ... elements) {
            for (int element : elements) {
                this.codes.add(element);
            }
            return (DeliveryReportFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DeliveryReportFilter.Builder codes(Iterable<Integer> elements) {
            this.codes.clear();
            return this.addAllCodes(elements);
        }

        @CanIgnoreReturnValue
        public final DeliveryReportFilter.Builder addAllCodes(Iterable<Integer> elements) {
            for (int element : elements) {
                this.codes.add((Integer)DeliveryReportFilterImpl.requireNonNull(element, "codes element"));
            }
            return (DeliveryReportFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DeliveryReportFilter.Builder clientReference(@Nullable String clientReference) {
            this.clientReference = clientReference;
            return (DeliveryReportFilter.Builder)this;
        }

        public DeliveryReportFilter build() {
            return new DeliveryReportFilterImpl(this);
        }

        private boolean pageSizeIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

