/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.sinch.xms.CallbackWrapper;
import org.apache.http.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DropExceptionWrapper
implements CallbackWrapper {
    private static final Logger log = LoggerFactory.getLogger(DropExceptionWrapper.class);
    private static final String msgfmt = "caught and dropped exception in callback: {}";

    DropExceptionWrapper() {
    }

    @Override
    public <T> FutureCallback<T> wrap(FutureCallback<T> callback) {
        return callback == null ? null : new WrappedCallback(callback);
    }

    private static final class WrappedCallback<T>
    implements FutureCallback<T> {
        private final FutureCallback<T> callback;

        private WrappedCallback(FutureCallback<T> callback) {
            this.callback = callback;
        }

        public void completed(T result) {
            try {
                this.callback.completed(result);
            }
            catch (Exception e) {
                log.error(DropExceptionWrapper.msgfmt, (Object)e.getMessage(), (Object)e);
            }
        }

        public void failed(Exception ex) {
            try {
                this.callback.failed(ex);
            }
            catch (Exception e) {
                log.error(DropExceptionWrapper.msgfmt, (Object)e.getMessage(), (Object)e);
            }
        }

        public void cancelled() {
            try {
                this.callback.cancelled();
            }
            catch (Exception e) {
                log.error(DropExceptionWrapper.msgfmt, (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

