/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sinch.xms.ErrorResponseException;
import com.sinch.xms.NotFoundException;
import com.sinch.xms.UnauthorizedException;
import com.sinch.xms.UnexpectedResponseException;
import com.sinch.xms.api.ApiError;
import java.io.IOException;
import java.nio.CharBuffer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AsyncCharConsumer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EmptyAsyncConsumer
extends AsyncCharConsumer<Void> {
    private static final Logger log = LoggerFactory.getLogger(EmptyAsyncConsumer.class);
    private final ObjectMapper json;
    private HttpResponse response;
    private StringBuilder sb;

    public EmptyAsyncConsumer(ObjectMapper json) {
        this.json = json;
    }

    protected void onCharReceived(CharBuffer buf, IOControl ioctrl) throws IOException {
        this.sb.append(buf.toString());
    }

    protected void onResponseReceived(HttpResponse response) throws HttpException, IOException {
        this.response = response;
        this.sb = new StringBuilder();
    }

    protected Void buildResult(HttpContext context) throws Exception {
        int code = this.response.getStatusLine().getStatusCode();
        String content = this.sb.toString();
        switch (code) {
            case 200: 
            case 201: {
                if (!content.isEmpty()) {
                    log.warn("Expected empty body but got '{}'", (Object)content);
                }
                return null;
            }
            case 400: 
            case 403: {
                ApiError error = (ApiError)this.json.readValue(content, ApiError.class);
                throw new ErrorResponseException(error);
            }
            case 404: {
                HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
                RequestLine rl = coreContext.getRequest().getRequestLine();
                throw new NotFoundException(rl.getUri());
            }
            case 401: {
                throw new UnauthorizedException();
            }
        }
        ContentType contentType = ContentType.getLenient((HttpEntity)this.response.getEntity());
        this.response.setEntity((HttpEntity)new StringEntity(content, contentType));
        throw new UnexpectedResponseException(this.response);
    }
}

