/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.sinch.xms.GroupFilterImpl;
import com.sinch.xms.Utils;
import com.sinch.xms.ValueStylePackage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.immutables.value.Value;

@Value.Immutable
@ValueStylePackage
public abstract class GroupFilter {
    @Nonnull
    public static final Builder builder() {
        return new Builder();
    }

    @Value.Default
    public int pageSize() {
        return 0;
    }

    public abstract Set<String> tags();

    @Value.Check
    protected void check() {
        for (String s : this.tags()) {
            if (!s.contains(",")) continue;
            throw new IllegalStateException("tags contains comma");
        }
    }

    @Nonnull
    List<NameValuePair> toQueryParams(int page) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(6);
        params.add((NameValuePair)new BasicNameValuePair("page", String.valueOf(page)));
        if (this.pageSize() > 0) {
            params.add((NameValuePair)new BasicNameValuePair("page_size", String.valueOf(this.pageSize())));
        }
        if (!this.tags().isEmpty()) {
            params.add((NameValuePair)new BasicNameValuePair("tags", Utils.join(",", this.tags())));
        }
        return params;
    }

    public static class Builder
    extends GroupFilterImpl.Builder {
        Builder() {
        }
    }
}

