/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.GroupFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class GroupFilterImpl
extends GroupFilter {
    private final int pageSize;
    private final Set<String> tags;

    private GroupFilterImpl(Builder builder) {
        this.tags = GroupFilterImpl.createUnmodifiableSet(builder.tags);
        this.pageSize = builder.pageSizeIsSet() ? builder.pageSize : super.pageSize();
    }

    private GroupFilterImpl(int pageSize, Set<String> tags) {
        this.pageSize = pageSize;
        this.tags = tags;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public Set<String> tags() {
        return this.tags;
    }

    public final GroupFilterImpl withPageSize(int value) {
        if (this.pageSize == value) {
            return this;
        }
        return GroupFilterImpl.validate(new GroupFilterImpl(value, this.tags));
    }

    public final GroupFilterImpl withTags(String ... elements) {
        Set<String> newValue = GroupFilterImpl.createUnmodifiableSet(GroupFilterImpl.createSafeList(Arrays.asList(elements), true, false));
        return GroupFilterImpl.validate(new GroupFilterImpl(this.pageSize, newValue));
    }

    public final GroupFilterImpl withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        Set<String> newValue = GroupFilterImpl.createUnmodifiableSet(GroupFilterImpl.createSafeList(elements, true, false));
        return GroupFilterImpl.validate(new GroupFilterImpl(this.pageSize, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GroupFilterImpl && this.equalTo((GroupFilterImpl)another);
    }

    private boolean equalTo(GroupFilterImpl another) {
        return this.pageSize == another.pageSize && this.tags.equals(another.tags);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.pageSize;
        h = h * 17 + this.tags.hashCode();
        return h;
    }

    public String toString() {
        return "GroupFilter{pageSize=" + this.pageSize + ", tags=" + this.tags + "}";
    }

    private static GroupFilterImpl validate(GroupFilterImpl instance) {
        instance.check();
        return instance;
    }

    public static GroupFilter copyOf(GroupFilter instance) {
        if (instance instanceof GroupFilterImpl) {
            return (GroupFilterImpl)instance;
        }
        return new GroupFilter.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                GroupFilterImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    static class Builder {
        private static final long OPT_BIT_PAGE_SIZE = 1L;
        private long optBits;
        private int pageSize;
        private List<String> tags = new ArrayList<String>();

        Builder() {
            if (!(this instanceof GroupFilter.Builder)) {
                throw new UnsupportedOperationException("Use: new GroupFilter.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final GroupFilter.Builder using(GroupFilter instance) {
            GroupFilterImpl.requireNonNull(instance, "instance");
            this.pageSize(instance.pageSize());
            this.addAllTags(instance.tags());
            return (GroupFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupFilter.Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            this.optBits |= 1L;
            return (GroupFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupFilter.Builder addTag(String element) {
            this.tags.add((String)GroupFilterImpl.requireNonNull(element, "tags element"));
            return (GroupFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupFilter.Builder addTag(String ... elements) {
            for (String element : elements) {
                this.tags.add((String)GroupFilterImpl.requireNonNull(element, "tags element"));
            }
            return (GroupFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupFilter.Builder tags(Iterable<String> elements) {
            this.tags.clear();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final GroupFilter.Builder addAllTags(Iterable<String> elements) {
            for (String element : elements) {
                this.tags.add((String)GroupFilterImpl.requireNonNull(element, "tags element"));
            }
            return (GroupFilter.Builder)this;
        }

        public GroupFilter build() {
            return GroupFilterImpl.validate(new GroupFilterImpl(this));
        }

        private boolean pageSizeIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

