/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.sinch.xms.InboundsFilterImpl;
import com.sinch.xms.Utils;
import com.sinch.xms.ValueStylePackage;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.immutables.value.Value;

@Value.Immutable
@ValueStylePackage
public abstract class InboundsFilter {
    @Nonnull
    public static final Builder builder() {
        return new Builder();
    }

    @Value.Default
    public int pageSize() {
        return 0;
    }

    @Nullable
    public abstract LocalDate startDate();

    @Nullable
    public abstract LocalDate endDate();

    public abstract Set<String> recipients();

    @Nullable
    public abstract String clientReference();

    @Value.Check
    protected void check() {
        for (String s : this.recipients()) {
            if (!s.contains(",")) continue;
            throw new IllegalStateException("to contains comma");
        }
    }

    @Nonnull
    List<NameValuePair> toQueryParams(int page) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(6);
        params.add((NameValuePair)new BasicNameValuePair("page", String.valueOf(page)));
        if (this.pageSize() > 0) {
            params.add((NameValuePair)new BasicNameValuePair("page_size", String.valueOf(this.pageSize())));
        }
        if (this.startDate() != null) {
            params.add((NameValuePair)new BasicNameValuePair("start_date", this.startDate().toString()));
        }
        if (this.endDate() != null) {
            params.add((NameValuePair)new BasicNameValuePair("end_date", this.endDate().toString()));
        }
        if (!this.recipients().isEmpty()) {
            params.add((NameValuePair)new BasicNameValuePair("to", Utils.join(",", this.recipients())));
        }
        if (this.clientReference() != null) {
            params.add((NameValuePair)new BasicNameValuePair("client_reference", this.clientReference()));
        }
        return params;
    }

    public static class Builder
    extends InboundsFilterImpl.Builder {
        Builder() {
        }
    }
}

