/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.InboundsFilter;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class InboundsFilterImpl
extends InboundsFilter {
    private final int pageSize;
    @Nullable
    private final LocalDate startDate;
    @Nullable
    private final LocalDate endDate;
    private final Set<String> recipients;
    @Nullable
    private final String clientReference;

    private InboundsFilterImpl(Builder builder) {
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.recipients = InboundsFilterImpl.createUnmodifiableSet(builder.recipients);
        this.clientReference = builder.clientReference;
        this.pageSize = builder.pageSizeIsSet() ? builder.pageSize : super.pageSize();
    }

    private InboundsFilterImpl(int pageSize, @Nullable LocalDate startDate, @Nullable LocalDate endDate, Set<String> recipients, @Nullable String clientReference) {
        this.pageSize = pageSize;
        this.startDate = startDate;
        this.endDate = endDate;
        this.recipients = recipients;
        this.clientReference = clientReference;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    @Nullable
    public LocalDate startDate() {
        return this.startDate;
    }

    @Override
    @Nullable
    public LocalDate endDate() {
        return this.endDate;
    }

    @Override
    public Set<String> recipients() {
        return this.recipients;
    }

    @Override
    @Nullable
    public String clientReference() {
        return this.clientReference;
    }

    public final InboundsFilterImpl withPageSize(int value) {
        if (this.pageSize == value) {
            return this;
        }
        return InboundsFilterImpl.validate(new InboundsFilterImpl(value, this.startDate, this.endDate, this.recipients, this.clientReference));
    }

    public final InboundsFilterImpl withStartDate(@Nullable LocalDate value) {
        if (this.startDate == value) {
            return this;
        }
        return InboundsFilterImpl.validate(new InboundsFilterImpl(this.pageSize, value, this.endDate, this.recipients, this.clientReference));
    }

    public final InboundsFilterImpl withEndDate(@Nullable LocalDate value) {
        if (this.endDate == value) {
            return this;
        }
        return InboundsFilterImpl.validate(new InboundsFilterImpl(this.pageSize, this.startDate, value, this.recipients, this.clientReference));
    }

    public final InboundsFilterImpl withRecipients(String ... elements) {
        Set<String> newValue = InboundsFilterImpl.createUnmodifiableSet(InboundsFilterImpl.createSafeList(Arrays.asList(elements), true, false));
        return InboundsFilterImpl.validate(new InboundsFilterImpl(this.pageSize, this.startDate, this.endDate, newValue, this.clientReference));
    }

    public final InboundsFilterImpl withRecipients(Iterable<String> elements) {
        if (this.recipients == elements) {
            return this;
        }
        Set<String> newValue = InboundsFilterImpl.createUnmodifiableSet(InboundsFilterImpl.createSafeList(elements, true, false));
        return InboundsFilterImpl.validate(new InboundsFilterImpl(this.pageSize, this.startDate, this.endDate, newValue, this.clientReference));
    }

    public final InboundsFilterImpl withClientReference(@Nullable String value) {
        if (InboundsFilterImpl.equals(this.clientReference, value)) {
            return this;
        }
        return InboundsFilterImpl.validate(new InboundsFilterImpl(this.pageSize, this.startDate, this.endDate, this.recipients, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof InboundsFilterImpl && this.equalTo((InboundsFilterImpl)another);
    }

    private boolean equalTo(InboundsFilterImpl another) {
        return this.pageSize == another.pageSize && InboundsFilterImpl.equals(this.startDate, another.startDate) && InboundsFilterImpl.equals(this.endDate, another.endDate) && this.recipients.equals(another.recipients) && InboundsFilterImpl.equals(this.clientReference, another.clientReference);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.pageSize;
        h = h * 17 + InboundsFilterImpl.hashCode(this.startDate);
        h = h * 17 + InboundsFilterImpl.hashCode(this.endDate);
        h = h * 17 + this.recipients.hashCode();
        h = h * 17 + InboundsFilterImpl.hashCode(this.clientReference);
        return h;
    }

    public String toString() {
        return "InboundsFilter{pageSize=" + this.pageSize + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", recipients=" + this.recipients + ", clientReference=" + this.clientReference + "}";
    }

    private static InboundsFilterImpl validate(InboundsFilterImpl instance) {
        instance.check();
        return instance;
    }

    public static InboundsFilter copyOf(InboundsFilter instance) {
        if (instance instanceof InboundsFilterImpl) {
            return (InboundsFilterImpl)instance;
        }
        return new InboundsFilter.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                InboundsFilterImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    static class Builder {
        private static final long OPT_BIT_PAGE_SIZE = 1L;
        private long optBits;
        private int pageSize;
        @Nullable
        private LocalDate startDate;
        @Nullable
        private LocalDate endDate;
        private List<String> recipients = new ArrayList<String>();
        @Nullable
        private String clientReference;

        Builder() {
            if (!(this instanceof InboundsFilter.Builder)) {
                throw new UnsupportedOperationException("Use: new InboundsFilter.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final InboundsFilter.Builder using(InboundsFilter instance) {
            LocalDate endDateValue;
            InboundsFilterImpl.requireNonNull(instance, "instance");
            this.pageSize(instance.pageSize());
            LocalDate startDateValue = instance.startDate();
            if (startDateValue != null) {
                this.startDate(startDateValue);
            }
            if ((endDateValue = instance.endDate()) != null) {
                this.endDate(endDateValue);
            }
            this.addAllRecipients(instance.recipients());
            String clientReferenceValue = instance.clientReference();
            if (clientReferenceValue != null) {
                this.clientReference(clientReferenceValue);
            }
            return (InboundsFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final InboundsFilter.Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            this.optBits |= 1L;
            return (InboundsFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final InboundsFilter.Builder startDate(@Nullable LocalDate startDate) {
            this.startDate = startDate;
            return (InboundsFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final InboundsFilter.Builder endDate(@Nullable LocalDate endDate) {
            this.endDate = endDate;
            return (InboundsFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final InboundsFilter.Builder addRecipient(String element) {
            this.recipients.add((String)InboundsFilterImpl.requireNonNull(element, "recipients element"));
            return (InboundsFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final InboundsFilter.Builder addRecipient(String ... elements) {
            for (String element : elements) {
                this.recipients.add((String)InboundsFilterImpl.requireNonNull(element, "recipients element"));
            }
            return (InboundsFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final InboundsFilter.Builder recipients(Iterable<String> elements) {
            this.recipients.clear();
            return this.addAllRecipients(elements);
        }

        @CanIgnoreReturnValue
        public final InboundsFilter.Builder addAllRecipients(Iterable<String> elements) {
            for (String element : elements) {
                this.recipients.add((String)InboundsFilterImpl.requireNonNull(element, "recipients element"));
            }
            return (InboundsFilter.Builder)this;
        }

        @CanIgnoreReturnValue
        public final InboundsFilter.Builder clientReference(@Nullable String clientReference) {
            this.clientReference = clientReference;
            return (InboundsFilter.Builder)this;
        }

        public InboundsFilter build() {
            return InboundsFilterImpl.validate(new InboundsFilterImpl(this));
        }

        private boolean pageSizeIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

