/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sinch.xms.ByteInOutStream;
import com.sinch.xms.ErrorResponseException;
import com.sinch.xms.NotFoundException;
import com.sinch.xms.UnauthorizedException;
import com.sinch.xms.UnexpectedResponseException;
import com.sinch.xms.api.ApiError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AsyncByteConsumer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;

class JsonApiAsyncConsumer<T>
extends AsyncByteConsumer<T> {
    private final ObjectMapper json;
    private final Class<T> jsonClass;
    private HttpResponse response;
    private ByteInOutStream bios;

    public JsonApiAsyncConsumer(ObjectMapper json, Class<T> jsonClass) {
        this.json = json;
        this.jsonClass = jsonClass;
    }

    protected void onByteReceived(ByteBuffer buf, IOControl ioctrl) throws IOException {
        this.bios.write(buf);
    }

    protected void onResponseReceived(HttpResponse response) throws HttpException, IOException {
        this.response = response;
        this.bios = new ByteInOutStream(1024);
    }

    protected T buildResult(HttpContext context) throws Exception {
        int code = this.response.getStatusLine().getStatusCode();
        InputStream inputStream = this.bios.toInputStream();
        switch (code) {
            case 200: 
            case 201: {
                return (T)this.json.readValue(inputStream, this.jsonClass);
            }
            case 202: {
                return null;
            }
            case 400: 
            case 403: {
                ApiError error = (ApiError)this.json.readValue(inputStream, ApiError.class);
                throw new ErrorResponseException(error);
            }
            case 404: {
                HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
                RequestLine rl = coreContext.getRequest().getRequestLine();
                throw new NotFoundException(rl.getUri());
            }
            case 401: {
                throw new UnauthorizedException();
            }
        }
        ContentType type = ContentType.getLenient((HttpEntity)this.response.getEntity());
        InputStreamEntity entity = new InputStreamEntity(inputStream, (long)this.bios.size(), type);
        this.response.setEntity((HttpEntity)entity);
        throw new UnexpectedResponseException(this.response);
    }
}

