/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.sinch.xms.ApiException;
import com.sinch.xms.RuntimeApiException;
import com.sinch.xms.Utils;
import com.sinch.xms.api.Page;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.concurrent.FutureCallback;

public abstract class PagedFetcher<T> {
    @Nonnull
    Page<T> fetch(int page) throws InterruptedException, ApiException {
        try {
            return this.fetchAsync(page, null).get();
        }
        catch (ExecutionException e) {
            throw Utils.unwrapExecutionException(e);
        }
    }

    @Nonnull
    abstract Future<Page<T>> fetchAsync(int var1, @Nullable FutureCallback<Page<T>> var2);

    @Nonnull
    public Iterable<T> elements() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator pageIt = PagedFetcher.this.pages().iterator();
                return new Iterator<T>(){
                    Iterator<T> pageElemIt;
                    {
                        this.pageElemIt = ((Page)pageIt.next()).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (!this.pageElemIt.hasNext()) {
                            if (!pageIt.hasNext()) {
                                return false;
                            }
                            this.pageElemIt = ((Page)pageIt.next()).iterator();
                            return this.pageElemIt.hasNext();
                        }
                        return true;
                    }

                    @Override
                    public T next() {
                        if (!this.pageElemIt.hasNext()) {
                            this.pageElemIt = ((Page)pageIt.next()).iterator();
                        }
                        return this.pageElemIt.next();
                    }
                };
            }
        };
    }

    @Nonnull
    public Iterable<Page<T>> pages() {
        return new Iterable<Page<T>>(){

            @Override
            public Iterator<Page<T>> iterator() {
                return new Iterator<Page<T>>(){
                    private Page<T> page = null;
                    private int seenElements = 0;

                    @Override
                    public boolean hasNext() {
                        if (this.page == null) {
                            return true;
                        }
                        return this.seenElements < this.page.totalSize() && !this.page.isEmpty();
                    }

                    @Override
                    public Page<T> next() {
                        int pageToFetch = this.page == null ? 0 : this.page.page() + 1;
                        try {
                            this.page = PagedFetcher.this.fetchAsync(pageToFetch, null).get();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (ExecutionException e) {
                            ApiException cause;
                            try {
                                cause = Utils.unwrapExecutionException(e);
                            }
                            catch (ApiException einner) {
                                cause = einner;
                            }
                            throw new RuntimeApiException(cause);
                        }
                        this.seenElements += this.page.size();
                        return this.page;
                    }
                };
            }
        };
    }
}

