/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms;

import com.sinch.xms.ConcurrentException;
import com.sinch.xms.ErrorResponseException;
import com.sinch.xms.NotFoundException;
import com.sinch.xms.UnauthorizedException;
import com.sinch.xms.UnexpectedResponseException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

public final class Utils {
    @Nonnull
    public static String join(String delim, String ... strings) {
        Utils.requireNonNull(strings, "strings");
        return Utils.join(delim, Arrays.asList(strings));
    }

    @Nonnull
    public static String join(String delim, Iterable<String> strings) {
        Utils.requireNonNull(delim, "delim");
        Utils.requireNonNull(strings, "strings");
        StringBuilder sb = new StringBuilder(50);
        Iterator<String> it = strings.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(delim).append(it.next());
            }
        }
        return sb.toString();
    }

    static <T> T requireNonNull(T o, String name) {
        if (o == null) {
            throw new NullPointerException(name);
        }
        return o;
    }

    static ConcurrentException unwrapExecutionException(ExecutionException e) throws ErrorResponseException, UnexpectedResponseException, UnauthorizedException, NotFoundException {
        if (e.getCause() instanceof RuntimeException) {
            throw (RuntimeException)e.getCause();
        }
        if (e.getCause() instanceof Error) {
            throw (Error)e.getCause();
        }
        if (e.getCause() instanceof ErrorResponseException) {
            throw (ErrorResponseException)e.getCause();
        }
        if (e.getCause() instanceof NotFoundException) {
            throw (NotFoundException)e.getCause();
        }
        if (e.getCause() instanceof UnexpectedResponseException) {
            throw (UnexpectedResponseException)e.getCause();
        }
        if (e.getCause() instanceof UnauthorizedException) {
            throw (UnauthorizedException)e.getCause();
        }
        return new ConcurrentException(e.getCause());
    }
}

