/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sinch.xms.api.ApiError;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class ApiErrorImpl
extends ApiError {
    private final String code;
    private final String text;

    private ApiErrorImpl(String code, String text) {
        this.code = ApiErrorImpl.requireNonNull(code, "code");
        this.text = ApiErrorImpl.requireNonNull(text, "text");
    }

    @Override
    @JsonProperty(value="code")
    public String code() {
        return this.code;
    }

    @Override
    @JsonProperty(value="text")
    public String text() {
        return this.text;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ApiErrorImpl && this.equalTo((ApiErrorImpl)another);
    }

    private boolean equalTo(ApiErrorImpl another) {
        return this.code.equals(another.code) && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.code.hashCode();
        h = h * 17 + this.text.hashCode();
        return h;
    }

    public String toString() {
        return "ApiError{code=" + this.code + ", text=" + this.text + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ApiErrorImpl fromJson(Json json) {
        ApiErrorImpl instance = (ApiErrorImpl)ApiErrorImpl.of(json.code, json.text);
        return instance;
    }

    public static ApiError of(String code, String text) {
        return new ApiErrorImpl(code, text);
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ApiError {
        @Nullable
        String code;
        @Nullable
        String text;

        Json() {
        }

        @JsonProperty(value="code")
        public void setCode(String code) {
            this.code = code;
        }

        @JsonProperty(value="text")
        public void setText(String text) {
            this.text = text;
        }

        @Override
        public String code() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String text() {
            throw new UnsupportedOperationException();
        }
    }
}

