/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.AutoUpdate;
import com.sinch.xms.api.KeywordPair;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class AutoUpdateImpl
extends AutoUpdate {
    private final String recipient;
    @Nullable
    private final KeywordPair add;
    @Nullable
    private final KeywordPair remove;

    private AutoUpdateImpl(String recipient, @Nullable KeywordPair add, @Nullable KeywordPair remove) {
        this.recipient = recipient;
        this.add = add;
        this.remove = remove;
    }

    @Override
    @JsonProperty(value="to")
    public String recipient() {
        return this.recipient;
    }

    @Override
    @JsonProperty(value="add")
    @Nullable
    public KeywordPair add() {
        return this.add;
    }

    @Override
    @JsonProperty(value="remove")
    @Nullable
    public KeywordPair remove() {
        return this.remove;
    }

    public final AutoUpdateImpl withRecipient(String value) {
        if (this.recipient.equals(value)) {
            return this;
        }
        String newValue = AutoUpdateImpl.requireNonNull(value, "recipient");
        return new AutoUpdateImpl(newValue, this.add, this.remove);
    }

    public final AutoUpdateImpl withAdd(@Nullable KeywordPair value) {
        if (this.add == value) {
            return this;
        }
        return new AutoUpdateImpl(this.recipient, value, this.remove);
    }

    public final AutoUpdateImpl withRemove(@Nullable KeywordPair value) {
        if (this.remove == value) {
            return this;
        }
        return new AutoUpdateImpl(this.recipient, this.add, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AutoUpdateImpl && this.equalTo((AutoUpdateImpl)another);
    }

    private boolean equalTo(AutoUpdateImpl another) {
        return this.recipient.equals(another.recipient) && AutoUpdateImpl.equals(this.add, another.add) && AutoUpdateImpl.equals(this.remove, another.remove);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.recipient.hashCode();
        h = h * 17 + AutoUpdateImpl.hashCode(this.add);
        h = h * 17 + AutoUpdateImpl.hashCode(this.remove);
        return h;
    }

    public String toString() {
        return "AutoUpdate{recipient=" + this.recipient + ", add=" + this.add + ", remove=" + this.remove + "}";
    }

    public static AutoUpdate copyOf(AutoUpdate instance) {
        if (instance instanceof AutoUpdateImpl) {
            return (AutoUpdateImpl)instance;
        }
        return new AutoUpdate.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_RECIPIENT = 1L;
        private long initBits = 1L;
        @Nullable
        private String recipient;
        @Nullable
        private KeywordPair add;
        @Nullable
        private KeywordPair remove;

        Builder() {
            if (!(this instanceof AutoUpdate.Builder)) {
                throw new UnsupportedOperationException("Use: new AutoUpdate.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final AutoUpdate.Builder using(AutoUpdate instance) {
            KeywordPair removeValue;
            AutoUpdateImpl.requireNonNull(instance, "instance");
            this.recipient(instance.recipient());
            KeywordPair addValue = instance.add();
            if (addValue != null) {
                this.add(addValue);
            }
            if ((removeValue = instance.remove()) != null) {
                this.remove(removeValue);
            }
            return (AutoUpdate.Builder)this;
        }

        @JsonProperty(value="to")
        @CanIgnoreReturnValue
        public final AutoUpdate.Builder recipient(String recipient) {
            this.recipient = (String)AutoUpdateImpl.requireNonNull(recipient, "recipient");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (AutoUpdate.Builder)this;
        }

        @JsonProperty(value="add")
        @CanIgnoreReturnValue
        public final AutoUpdate.Builder add(@Nullable KeywordPair add) {
            this.add = add;
            return (AutoUpdate.Builder)this;
        }

        @JsonProperty(value="remove")
        @CanIgnoreReturnValue
        public final AutoUpdate.Builder remove(@Nullable KeywordPair remove) {
            this.remove = remove;
            return (AutoUpdate.Builder)this;
        }

        public AutoUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AutoUpdateImpl(this.recipient, this.add, this.remove);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("recipient");
            }
            return "Cannot build AutoUpdate, some of required attributes are not set " + attributes;
        }
    }
}

