/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.BatchDeliveryReport;
import com.sinch.xms.api.BatchId;
import com.sinch.xms.api.DeliveryStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class BatchDeliveryReportImpl
extends BatchDeliveryReport {
    private final BatchId batchId;
    private final int totalMessageCount;
    private final List<BatchDeliveryReport.Status> statuses;
    @Nullable
    private final String clientReference;

    private BatchDeliveryReportImpl(BatchId batchId, int totalMessageCount, List<BatchDeliveryReport.Status> statuses, @Nullable String clientReference) {
        this.batchId = batchId;
        this.totalMessageCount = totalMessageCount;
        this.statuses = statuses;
        this.clientReference = clientReference;
    }

    @Override
    @JsonProperty(value="batch_id")
    public BatchId batchId() {
        return this.batchId;
    }

    @Override
    @JsonProperty(value="total_message_count")
    public int totalMessageCount() {
        return this.totalMessageCount;
    }

    @Override
    @JsonProperty(value="statuses")
    public List<BatchDeliveryReport.Status> statuses() {
        return this.statuses;
    }

    @Override
    @JsonProperty(value="client_reference")
    @Nullable
    public String clientReference() {
        return this.clientReference;
    }

    public final BatchDeliveryReportImpl withBatchId(BatchId value) {
        if (this.batchId == value) {
            return this;
        }
        BatchId newValue = BatchDeliveryReportImpl.requireNonNull(value, "batchId");
        return new BatchDeliveryReportImpl(newValue, this.totalMessageCount, this.statuses, this.clientReference);
    }

    public final BatchDeliveryReportImpl withTotalMessageCount(int value) {
        if (this.totalMessageCount == value) {
            return this;
        }
        return new BatchDeliveryReportImpl(this.batchId, value, this.statuses, this.clientReference);
    }

    public final BatchDeliveryReportImpl withStatuses(BatchDeliveryReport.Status ... elements) {
        List<BatchDeliveryReport.Status> newValue = BatchDeliveryReportImpl.createUnmodifiableList(false, BatchDeliveryReportImpl.createSafeList(Arrays.asList(elements), true, false));
        return new BatchDeliveryReportImpl(this.batchId, this.totalMessageCount, newValue, this.clientReference);
    }

    public final BatchDeliveryReportImpl withStatuses(Iterable<? extends BatchDeliveryReport.Status> elements) {
        if (this.statuses == elements) {
            return this;
        }
        List<BatchDeliveryReport.Status> newValue = BatchDeliveryReportImpl.createUnmodifiableList(false, BatchDeliveryReportImpl.createSafeList(elements, true, false));
        return new BatchDeliveryReportImpl(this.batchId, this.totalMessageCount, newValue, this.clientReference);
    }

    public final BatchDeliveryReportImpl withClientReference(@Nullable String value) {
        if (BatchDeliveryReportImpl.equals(this.clientReference, value)) {
            return this;
        }
        return new BatchDeliveryReportImpl(this.batchId, this.totalMessageCount, this.statuses, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BatchDeliveryReportImpl && this.equalTo((BatchDeliveryReportImpl)another);
    }

    private boolean equalTo(BatchDeliveryReportImpl another) {
        return this.batchId.equals(another.batchId) && this.totalMessageCount == another.totalMessageCount && this.statuses.equals(another.statuses) && BatchDeliveryReportImpl.equals(this.clientReference, another.clientReference);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.batchId.hashCode();
        h = h * 17 + this.totalMessageCount;
        h = h * 17 + this.statuses.hashCode();
        h = h * 17 + BatchDeliveryReportImpl.hashCode(this.clientReference);
        return h;
    }

    public String toString() {
        return "BatchDeliveryReport{batchId=" + this.batchId + ", totalMessageCount=" + this.totalMessageCount + ", statuses=" + this.statuses + ", clientReference=" + this.clientReference + "}";
    }

    public static BatchDeliveryReport copyOf(BatchDeliveryReport instance) {
        if (instance instanceof BatchDeliveryReportImpl) {
            return (BatchDeliveryReportImpl)instance;
        }
        return new BatchDeliveryReport.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                BatchDeliveryReportImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @CheckReturnValue
    @Immutable
    static final class Status
    extends BatchDeliveryReport.Status {
        private final int code;
        private final DeliveryStatus status;
        private final int count;
        private final List<String> recipients;

        private Status(int code, DeliveryStatus status, int count, List<String> recipients) {
            this.code = code;
            this.status = status;
            this.count = count;
            this.recipients = recipients;
        }

        @Override
        @JsonProperty(value="code")
        public int code() {
            return this.code;
        }

        @Override
        @JsonProperty(value="status")
        public DeliveryStatus status() {
            return this.status;
        }

        @Override
        @JsonProperty(value="count")
        public int count() {
            return this.count;
        }

        @Override
        @JsonProperty(value="recipients")
        public List<String> recipients() {
            return this.recipients;
        }

        public final Status withCode(int value) {
            if (this.code == value) {
                return this;
            }
            return new Status(value, this.status, this.count, this.recipients);
        }

        public final Status withStatus(DeliveryStatus value) {
            if (this.status == value) {
                return this;
            }
            DeliveryStatus newValue = (DeliveryStatus)BatchDeliveryReportImpl.requireNonNull(value, "status");
            return new Status(this.code, newValue, this.count, this.recipients);
        }

        public final Status withCount(int value) {
            if (this.count == value) {
                return this;
            }
            return new Status(this.code, this.status, value, this.recipients);
        }

        public final Status withRecipients(String ... elements) {
            List newValue = BatchDeliveryReportImpl.createUnmodifiableList(false, BatchDeliveryReportImpl.createSafeList(Arrays.asList(elements), true, false));
            return new Status(this.code, this.status, this.count, newValue);
        }

        public final Status withRecipients(Iterable<String> elements) {
            if (this.recipients == elements) {
                return this;
            }
            List newValue = BatchDeliveryReportImpl.createUnmodifiableList(false, BatchDeliveryReportImpl.createSafeList(elements, true, false));
            return new Status(this.code, this.status, this.count, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Status && this.equalTo((Status)another);
        }

        private boolean equalTo(Status another) {
            return this.code == another.code && this.status.equals(another.status) && this.count == another.count && this.recipients.equals(another.recipients);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.code;
            h = h * 17 + this.status.hashCode();
            h = h * 17 + this.count;
            h = h * 17 + this.recipients.hashCode();
            return h;
        }

        public String toString() {
            return "Status{code=" + this.code + ", status=" + this.status + ", count=" + this.count + ", recipients=" + this.recipients + "}";
        }

        public static BatchDeliveryReport.Status copyOf(BatchDeliveryReport.Status instance) {
            if (instance instanceof Status) {
                return (Status)instance;
            }
            return new BatchDeliveryReport.Status.Builder().using(instance).build();
        }

        @NotThreadSafe
        static class Builder {
            private static final long INIT_BIT_CODE = 1L;
            private static final long INIT_BIT_STATUS = 2L;
            private static final long INIT_BIT_COUNT = 4L;
            private long initBits = 7L;
            private int code;
            @Nullable
            private DeliveryStatus status;
            private int count;
            private List<String> recipients = new ArrayList<String>();

            Builder() {
                if (!(this instanceof BatchDeliveryReport.Status.Builder)) {
                    throw new UnsupportedOperationException("Use: new BatchDeliveryReport.Status.Builder()");
                }
            }

            @CanIgnoreReturnValue
            public final BatchDeliveryReport.Status.Builder using(BatchDeliveryReport.Status instance) {
                BatchDeliveryReportImpl.requireNonNull(instance, "instance");
                this.code(instance.code());
                this.status(instance.status());
                this.count(instance.count());
                this.addAllRecipients(instance.recipients());
                return (BatchDeliveryReport.Status.Builder)this;
            }

            @JsonProperty(value="code")
            @CanIgnoreReturnValue
            public final BatchDeliveryReport.Status.Builder code(int code) {
                this.code = code;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return (BatchDeliveryReport.Status.Builder)this;
            }

            @JsonProperty(value="status")
            @CanIgnoreReturnValue
            public final BatchDeliveryReport.Status.Builder status(DeliveryStatus status) {
                this.status = (DeliveryStatus)BatchDeliveryReportImpl.requireNonNull(status, "status");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return (BatchDeliveryReport.Status.Builder)this;
            }

            @JsonProperty(value="count")
            @CanIgnoreReturnValue
            public final BatchDeliveryReport.Status.Builder count(int count) {
                this.count = count;
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return (BatchDeliveryReport.Status.Builder)this;
            }

            @CanIgnoreReturnValue
            public final BatchDeliveryReport.Status.Builder addRecipient(String element) {
                this.recipients.add((String)BatchDeliveryReportImpl.requireNonNull(element, "recipients element"));
                return (BatchDeliveryReport.Status.Builder)this;
            }

            @CanIgnoreReturnValue
            public final BatchDeliveryReport.Status.Builder addRecipient(String ... elements) {
                for (String element : elements) {
                    this.recipients.add((String)BatchDeliveryReportImpl.requireNonNull(element, "recipients element"));
                }
                return (BatchDeliveryReport.Status.Builder)this;
            }

            @JsonProperty(value="recipients")
            @CanIgnoreReturnValue
            public final BatchDeliveryReport.Status.Builder recipients(Iterable<String> elements) {
                this.recipients.clear();
                return this.addAllRecipients(elements);
            }

            @CanIgnoreReturnValue
            public final BatchDeliveryReport.Status.Builder addAllRecipients(Iterable<String> elements) {
                for (String element : elements) {
                    this.recipients.add((String)BatchDeliveryReportImpl.requireNonNull(element, "recipients element"));
                }
                return (BatchDeliveryReport.Status.Builder)this;
            }

            public BatchDeliveryReport.Status build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Status(this.code, this.status, this.count, BatchDeliveryReportImpl.createUnmodifiableList(true, this.recipients));
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("code");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("status");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("count");
                }
                return "Cannot build Status, some of required attributes are not set " + attributes;
            }
        }
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_BATCH_ID = 1L;
        private static final long INIT_BIT_TOTAL_MESSAGE_COUNT = 2L;
        private long initBits = 3L;
        @Nullable
        private BatchId batchId;
        private int totalMessageCount;
        private List<BatchDeliveryReport.Status> statuses = new ArrayList<BatchDeliveryReport.Status>();
        @Nullable
        private String clientReference;

        Builder() {
            if (!(this instanceof BatchDeliveryReport.Builder)) {
                throw new UnsupportedOperationException("Use: new BatchDeliveryReport.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final BatchDeliveryReport.Builder using(BatchDeliveryReport instance) {
            BatchDeliveryReportImpl.requireNonNull(instance, "instance");
            this.batchId(instance.batchId());
            this.totalMessageCount(instance.totalMessageCount());
            this.addAllStatuses(instance.statuses());
            String clientReferenceValue = instance.clientReference();
            if (clientReferenceValue != null) {
                this.clientReference(clientReferenceValue);
            }
            return (BatchDeliveryReport.Builder)this;
        }

        @JsonProperty(value="batch_id")
        @CanIgnoreReturnValue
        public final BatchDeliveryReport.Builder batchId(BatchId batchId) {
            this.batchId = (BatchId)BatchDeliveryReportImpl.requireNonNull(batchId, "batchId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (BatchDeliveryReport.Builder)this;
        }

        @JsonProperty(value="total_message_count")
        @CanIgnoreReturnValue
        public final BatchDeliveryReport.Builder totalMessageCount(int totalMessageCount) {
            this.totalMessageCount = totalMessageCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (BatchDeliveryReport.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchDeliveryReport.Builder addStatus(BatchDeliveryReport.Status element) {
            this.statuses.add((BatchDeliveryReport.Status)BatchDeliveryReportImpl.requireNonNull(element, "statuses element"));
            return (BatchDeliveryReport.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BatchDeliveryReport.Builder addStatus(BatchDeliveryReport.Status ... elements) {
            for (BatchDeliveryReport.Status element : elements) {
                this.statuses.add((BatchDeliveryReport.Status)BatchDeliveryReportImpl.requireNonNull(element, "statuses element"));
            }
            return (BatchDeliveryReport.Builder)this;
        }

        @JsonProperty(value="statuses")
        @CanIgnoreReturnValue
        public final BatchDeliveryReport.Builder statuses(Iterable<? extends BatchDeliveryReport.Status> elements) {
            this.statuses.clear();
            return this.addAllStatuses(elements);
        }

        @CanIgnoreReturnValue
        public final BatchDeliveryReport.Builder addAllStatuses(Iterable<? extends BatchDeliveryReport.Status> elements) {
            for (BatchDeliveryReport.Status status : elements) {
                this.statuses.add((BatchDeliveryReport.Status)BatchDeliveryReportImpl.requireNonNull(status, "statuses element"));
            }
            return (BatchDeliveryReport.Builder)this;
        }

        @JsonProperty(value="client_reference")
        @CanIgnoreReturnValue
        public final BatchDeliveryReport.Builder clientReference(@Nullable String clientReference) {
            this.clientReference = clientReference;
            return (BatchDeliveryReport.Builder)this;
        }

        public BatchDeliveryReport build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new BatchDeliveryReportImpl(this.batchId, this.totalMessageCount, BatchDeliveryReportImpl.createUnmodifiableList(true, this.statuses), this.clientReference);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("batchId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("totalMessageCount");
            }
            return "Cannot build BatchDeliveryReport, some of required attributes are not set " + attributes;
        }
    }
}

