/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.FeedbackDeliveryCreate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class FeedbackDeliveryCreateImpl
extends FeedbackDeliveryCreate {
    private final List<String> recipients;

    private FeedbackDeliveryCreateImpl(List<String> recipients) {
        this.recipients = recipients;
    }

    @Override
    @JsonProperty(value="recipients")
    public List<String> recipients() {
        return this.recipients;
    }

    public final FeedbackDeliveryCreateImpl withRecipients(String ... elements) {
        List<String> newValue = FeedbackDeliveryCreateImpl.createUnmodifiableList(false, FeedbackDeliveryCreateImpl.createSafeList(Arrays.asList(elements), true, false));
        return new FeedbackDeliveryCreateImpl(newValue);
    }

    public final FeedbackDeliveryCreateImpl withRecipients(Iterable<String> elements) {
        if (this.recipients == elements) {
            return this;
        }
        List<String> newValue = FeedbackDeliveryCreateImpl.createUnmodifiableList(false, FeedbackDeliveryCreateImpl.createSafeList(elements, true, false));
        return new FeedbackDeliveryCreateImpl(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof FeedbackDeliveryCreateImpl && this.equalTo((FeedbackDeliveryCreateImpl)another);
    }

    private boolean equalTo(FeedbackDeliveryCreateImpl another) {
        return this.recipients.equals(another.recipients);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.recipients.hashCode();
        return h;
    }

    public String toString() {
        return "FeedbackDeliveryCreate{recipients=" + this.recipients + "}";
    }

    public static FeedbackDeliveryCreate copyOf(FeedbackDeliveryCreate instance) {
        if (instance instanceof FeedbackDeliveryCreateImpl) {
            return (FeedbackDeliveryCreateImpl)instance;
        }
        return new FeedbackDeliveryCreate.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                FeedbackDeliveryCreateImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    static class Builder {
        private List<String> recipients = new ArrayList<String>();

        Builder() {
            if (!(this instanceof FeedbackDeliveryCreate.Builder)) {
                throw new UnsupportedOperationException("Use: new FeedbackDeliveryCreate.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final FeedbackDeliveryCreate.Builder using(FeedbackDeliveryCreate instance) {
            FeedbackDeliveryCreateImpl.requireNonNull(instance, "instance");
            this.addAllRecipients(instance.recipients());
            return (FeedbackDeliveryCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final FeedbackDeliveryCreate.Builder addRecipient(String element) {
            this.recipients.add((String)FeedbackDeliveryCreateImpl.requireNonNull(element, "recipients element"));
            return (FeedbackDeliveryCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final FeedbackDeliveryCreate.Builder addRecipient(String ... elements) {
            for (String element : elements) {
                this.recipients.add((String)FeedbackDeliveryCreateImpl.requireNonNull(element, "recipients element"));
            }
            return (FeedbackDeliveryCreate.Builder)this;
        }

        @JsonProperty(value="recipients")
        @CanIgnoreReturnValue
        public final FeedbackDeliveryCreate.Builder recipients(Iterable<String> elements) {
            this.recipients.clear();
            return this.addAllRecipients(elements);
        }

        @CanIgnoreReturnValue
        public final FeedbackDeliveryCreate.Builder addAllRecipients(Iterable<String> elements) {
            for (String element : elements) {
                this.recipients.add((String)FeedbackDeliveryCreateImpl.requireNonNull(element, "recipients element"));
            }
            return (FeedbackDeliveryCreate.Builder)this;
        }

        public FeedbackDeliveryCreate build() {
            return new FeedbackDeliveryCreateImpl(FeedbackDeliveryCreateImpl.createUnmodifiableList(true, this.recipients));
        }
    }
}

