/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.AutoUpdate;
import com.sinch.xms.api.GroupCreate;
import com.sinch.xms.api.GroupId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class GroupCreateImpl
extends GroupCreate {
    @Nullable
    private final String name;
    private final Set<String> members;
    private final Set<GroupId> childGroups;
    @Nullable
    private final AutoUpdate autoUpdate;
    private final Set<String> tags;

    private GroupCreateImpl(@Nullable String name, Set<String> members, Set<GroupId> childGroups, @Nullable AutoUpdate autoUpdate, Set<String> tags) {
        this.name = name;
        this.members = members;
        this.childGroups = childGroups;
        this.autoUpdate = autoUpdate;
        this.tags = tags;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="members")
    public Set<String> members() {
        return this.members;
    }

    @Override
    @JsonProperty(value="child_groups")
    public Set<GroupId> childGroups() {
        return this.childGroups;
    }

    @Override
    @JsonProperty(value="auto_update")
    @Nullable
    public AutoUpdate autoUpdate() {
        return this.autoUpdate;
    }

    @Override
    @JsonProperty(value="tags")
    public Set<String> tags() {
        return this.tags;
    }

    public final GroupCreateImpl withName(@Nullable String value) {
        if (GroupCreateImpl.equals(this.name, value)) {
            return this;
        }
        return new GroupCreateImpl(value, this.members, this.childGroups, this.autoUpdate, this.tags);
    }

    public final GroupCreateImpl withMembers(String ... elements) {
        Set<String> newValue = GroupCreateImpl.createUnmodifiableSet(GroupCreateImpl.createSafeList(Arrays.asList(elements), true, false));
        return new GroupCreateImpl(this.name, newValue, this.childGroups, this.autoUpdate, this.tags);
    }

    public final GroupCreateImpl withMembers(Iterable<String> elements) {
        if (this.members == elements) {
            return this;
        }
        Set<String> newValue = GroupCreateImpl.createUnmodifiableSet(GroupCreateImpl.createSafeList(elements, true, false));
        return new GroupCreateImpl(this.name, newValue, this.childGroups, this.autoUpdate, this.tags);
    }

    public final GroupCreateImpl withChildGroups(GroupId ... elements) {
        Set<GroupId> newValue = GroupCreateImpl.createUnmodifiableSet(GroupCreateImpl.createSafeList(Arrays.asList(elements), true, false));
        return new GroupCreateImpl(this.name, this.members, newValue, this.autoUpdate, this.tags);
    }

    public final GroupCreateImpl withChildGroups(Iterable<? extends GroupId> elements) {
        if (this.childGroups == elements) {
            return this;
        }
        Set<GroupId> newValue = GroupCreateImpl.createUnmodifiableSet(GroupCreateImpl.createSafeList(elements, true, false));
        return new GroupCreateImpl(this.name, this.members, newValue, this.autoUpdate, this.tags);
    }

    public final GroupCreateImpl withAutoUpdate(@Nullable AutoUpdate value) {
        if (this.autoUpdate == value) {
            return this;
        }
        return new GroupCreateImpl(this.name, this.members, this.childGroups, value, this.tags);
    }

    public final GroupCreateImpl withTags(String ... elements) {
        Set<String> newValue = GroupCreateImpl.createUnmodifiableSet(GroupCreateImpl.createSafeList(Arrays.asList(elements), true, false));
        return new GroupCreateImpl(this.name, this.members, this.childGroups, this.autoUpdate, newValue);
    }

    public final GroupCreateImpl withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        Set<String> newValue = GroupCreateImpl.createUnmodifiableSet(GroupCreateImpl.createSafeList(elements, true, false));
        return new GroupCreateImpl(this.name, this.members, this.childGroups, this.autoUpdate, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GroupCreateImpl && this.equalTo((GroupCreateImpl)another);
    }

    private boolean equalTo(GroupCreateImpl another) {
        return GroupCreateImpl.equals(this.name, another.name) && this.members.equals(another.members) && this.childGroups.equals(another.childGroups) && GroupCreateImpl.equals(this.autoUpdate, another.autoUpdate) && this.tags.equals(another.tags);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + GroupCreateImpl.hashCode(this.name);
        h = h * 17 + this.members.hashCode();
        h = h * 17 + this.childGroups.hashCode();
        h = h * 17 + GroupCreateImpl.hashCode(this.autoUpdate);
        h = h * 17 + this.tags.hashCode();
        return h;
    }

    public String toString() {
        return "GroupCreate{name=" + this.name + ", members=" + this.members + ", childGroups=" + this.childGroups + ", autoUpdate=" + this.autoUpdate + ", tags=" + this.tags + "}";
    }

    public static GroupCreate copyOf(GroupCreate instance) {
        if (instance instanceof GroupCreateImpl) {
            return (GroupCreateImpl)instance;
        }
        return new GroupCreate.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                GroupCreateImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    static class Builder {
        @Nullable
        private String name;
        private List<String> members = new ArrayList<String>();
        private List<GroupId> childGroups = new ArrayList<GroupId>();
        @Nullable
        private AutoUpdate autoUpdate;
        private List<String> tags = new ArrayList<String>();

        Builder() {
            if (!(this instanceof GroupCreate.Builder)) {
                throw new UnsupportedOperationException("Use: new GroupCreate.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final GroupCreate.Builder using(GroupCreate instance) {
            GroupCreateImpl.requireNonNull(instance, "instance");
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            this.addAllMembers(instance.members());
            this.addAllChildGroups(instance.childGroups());
            AutoUpdate autoUpdateValue = instance.autoUpdate();
            if (autoUpdateValue != null) {
                this.autoUpdate(autoUpdateValue);
            }
            this.addAllTags(instance.tags());
            return (GroupCreate.Builder)this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final GroupCreate.Builder name(@Nullable String name) {
            this.name = name;
            return (GroupCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupCreate.Builder addMember(String element) {
            this.members.add((String)GroupCreateImpl.requireNonNull(element, "members element"));
            return (GroupCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupCreate.Builder addMember(String ... elements) {
            for (String element : elements) {
                this.members.add((String)GroupCreateImpl.requireNonNull(element, "members element"));
            }
            return (GroupCreate.Builder)this;
        }

        @JsonProperty(value="members")
        @CanIgnoreReturnValue
        public final GroupCreate.Builder members(Iterable<String> elements) {
            this.members.clear();
            return this.addAllMembers(elements);
        }

        @CanIgnoreReturnValue
        public final GroupCreate.Builder addAllMembers(Iterable<String> elements) {
            for (String element : elements) {
                this.members.add((String)GroupCreateImpl.requireNonNull(element, "members element"));
            }
            return (GroupCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupCreate.Builder addChildGroup(GroupId element) {
            this.childGroups.add((GroupId)GroupCreateImpl.requireNonNull(element, "childGroups element"));
            return (GroupCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupCreate.Builder addChildGroup(GroupId ... elements) {
            for (GroupId element : elements) {
                this.childGroups.add((GroupId)GroupCreateImpl.requireNonNull(element, "childGroups element"));
            }
            return (GroupCreate.Builder)this;
        }

        @JsonProperty(value="child_groups")
        @CanIgnoreReturnValue
        public final GroupCreate.Builder childGroups(Iterable<? extends GroupId> elements) {
            this.childGroups.clear();
            return this.addAllChildGroups(elements);
        }

        @CanIgnoreReturnValue
        public final GroupCreate.Builder addAllChildGroups(Iterable<? extends GroupId> elements) {
            for (GroupId groupId : elements) {
                this.childGroups.add((GroupId)GroupCreateImpl.requireNonNull(groupId, "childGroups element"));
            }
            return (GroupCreate.Builder)this;
        }

        @JsonProperty(value="auto_update")
        @CanIgnoreReturnValue
        public final GroupCreate.Builder autoUpdate(@Nullable AutoUpdate autoUpdate) {
            this.autoUpdate = autoUpdate;
            return (GroupCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupCreate.Builder addTag(String element) {
            this.tags.add((String)GroupCreateImpl.requireNonNull(element, "tags element"));
            return (GroupCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupCreate.Builder addTag(String ... elements) {
            for (String element : elements) {
                this.tags.add((String)GroupCreateImpl.requireNonNull(element, "tags element"));
            }
            return (GroupCreate.Builder)this;
        }

        @JsonProperty(value="tags")
        @CanIgnoreReturnValue
        public final GroupCreate.Builder tags(Iterable<String> elements) {
            this.tags.clear();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final GroupCreate.Builder addAllTags(Iterable<String> elements) {
            for (String element : elements) {
                this.tags.add((String)GroupCreateImpl.requireNonNull(element, "tags element"));
            }
            return (GroupCreate.Builder)this;
        }

        public GroupCreate build() {
            return new GroupCreateImpl(this.name, GroupCreateImpl.createUnmodifiableSet(this.members), GroupCreateImpl.createUnmodifiableSet(this.childGroups), this.autoUpdate, GroupCreateImpl.createUnmodifiableSet(this.tags));
        }
    }
}

