/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.AutoUpdate;
import com.sinch.xms.api.GroupId;
import com.sinch.xms.api.GroupResult;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class GroupResultImpl
extends GroupResult {
    private final GroupId id;
    @Nullable
    private final String name;
    private final int size;
    private final Set<GroupId> childGroups;
    @Nullable
    private final AutoUpdate autoUpdate;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime modifiedAt;

    private GroupResultImpl(GroupId id, @Nullable String name, int size, Set<GroupId> childGroups, @Nullable AutoUpdate autoUpdate, OffsetDateTime createdAt, OffsetDateTime modifiedAt) {
        this.id = id;
        this.name = name;
        this.size = size;
        this.childGroups = childGroups;
        this.autoUpdate = autoUpdate;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
    }

    @Override
    @JsonProperty(value="id")
    public GroupId id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="size")
    public int size() {
        return this.size;
    }

    @Override
    @JsonProperty(value="child_groups")
    public Set<GroupId> childGroups() {
        return this.childGroups;
    }

    @Override
    @JsonProperty(value="auto_update")
    @Nullable
    public AutoUpdate autoUpdate() {
        return this.autoUpdate;
    }

    @Override
    @JsonProperty(value="created_at")
    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="modified_at")
    public OffsetDateTime modifiedAt() {
        return this.modifiedAt;
    }

    public final GroupResultImpl withId(GroupId value) {
        if (this.id == value) {
            return this;
        }
        GroupId newValue = GroupResultImpl.requireNonNull(value, "id");
        return new GroupResultImpl(newValue, this.name, this.size, this.childGroups, this.autoUpdate, this.createdAt, this.modifiedAt);
    }

    public final GroupResultImpl withName(@Nullable String value) {
        if (GroupResultImpl.equals(this.name, value)) {
            return this;
        }
        return new GroupResultImpl(this.id, value, this.size, this.childGroups, this.autoUpdate, this.createdAt, this.modifiedAt);
    }

    public final GroupResultImpl withSize(int value) {
        if (this.size == value) {
            return this;
        }
        return new GroupResultImpl(this.id, this.name, value, this.childGroups, this.autoUpdate, this.createdAt, this.modifiedAt);
    }

    public final GroupResultImpl withChildGroups(GroupId ... elements) {
        Set<GroupId> newValue = GroupResultImpl.createUnmodifiableSet(GroupResultImpl.createSafeList(Arrays.asList(elements), true, false));
        return new GroupResultImpl(this.id, this.name, this.size, newValue, this.autoUpdate, this.createdAt, this.modifiedAt);
    }

    public final GroupResultImpl withChildGroups(Iterable<? extends GroupId> elements) {
        if (this.childGroups == elements) {
            return this;
        }
        Set<GroupId> newValue = GroupResultImpl.createUnmodifiableSet(GroupResultImpl.createSafeList(elements, true, false));
        return new GroupResultImpl(this.id, this.name, this.size, newValue, this.autoUpdate, this.createdAt, this.modifiedAt);
    }

    public final GroupResultImpl withAutoUpdate(@Nullable AutoUpdate value) {
        if (this.autoUpdate == value) {
            return this;
        }
        return new GroupResultImpl(this.id, this.name, this.size, this.childGroups, value, this.createdAt, this.modifiedAt);
    }

    public final GroupResultImpl withCreatedAt(OffsetDateTime value) {
        if (this.createdAt == value) {
            return this;
        }
        OffsetDateTime newValue = GroupResultImpl.requireNonNull(value, "createdAt");
        return new GroupResultImpl(this.id, this.name, this.size, this.childGroups, this.autoUpdate, newValue, this.modifiedAt);
    }

    public final GroupResultImpl withModifiedAt(OffsetDateTime value) {
        if (this.modifiedAt == value) {
            return this;
        }
        OffsetDateTime newValue = GroupResultImpl.requireNonNull(value, "modifiedAt");
        return new GroupResultImpl(this.id, this.name, this.size, this.childGroups, this.autoUpdate, this.createdAt, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GroupResultImpl && this.equalTo((GroupResultImpl)another);
    }

    private boolean equalTo(GroupResultImpl another) {
        return this.id.equals(another.id) && GroupResultImpl.equals(this.name, another.name) && this.size == another.size && this.childGroups.equals(another.childGroups) && GroupResultImpl.equals(this.autoUpdate, another.autoUpdate) && this.createdAt.equals(another.createdAt) && this.modifiedAt.equals(another.modifiedAt);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + GroupResultImpl.hashCode(this.name);
        h = h * 17 + this.size;
        h = h * 17 + this.childGroups.hashCode();
        h = h * 17 + GroupResultImpl.hashCode(this.autoUpdate);
        h = h * 17 + this.createdAt.hashCode();
        h = h * 17 + this.modifiedAt.hashCode();
        return h;
    }

    public String toString() {
        return "GroupResult{id=" + this.id + ", name=" + this.name + ", size=" + this.size + ", childGroups=" + this.childGroups + ", autoUpdate=" + this.autoUpdate + ", createdAt=" + this.createdAt + ", modifiedAt=" + this.modifiedAt + "}";
    }

    public static GroupResult copyOf(GroupResult instance) {
        if (instance instanceof GroupResultImpl) {
            return (GroupResultImpl)instance;
        }
        return new GroupResult.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                GroupResultImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SIZE = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_MODIFIED_AT = 8L;
        private long initBits = 15L;
        @Nullable
        private GroupId id;
        @Nullable
        private String name;
        private int size;
        private List<GroupId> childGroups = new ArrayList<GroupId>();
        @Nullable
        private AutoUpdate autoUpdate;
        @Nullable
        private OffsetDateTime createdAt;
        @Nullable
        private OffsetDateTime modifiedAt;

        Builder() {
            if (!(this instanceof GroupResult.Builder)) {
                throw new UnsupportedOperationException("Use: new GroupResult.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final GroupResult.Builder using(GroupResult instance) {
            GroupResultImpl.requireNonNull(instance, "instance");
            this.id(instance.id());
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            this.size(instance.size());
            this.addAllChildGroups(instance.childGroups());
            AutoUpdate autoUpdateValue = instance.autoUpdate();
            if (autoUpdateValue != null) {
                this.autoUpdate(autoUpdateValue);
            }
            this.createdAt(instance.createdAt());
            this.modifiedAt(instance.modifiedAt());
            return (GroupResult.Builder)this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final GroupResult.Builder id(GroupId id) {
            this.id = (GroupId)GroupResultImpl.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (GroupResult.Builder)this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final GroupResult.Builder name(@Nullable String name) {
            this.name = name;
            return (GroupResult.Builder)this;
        }

        @JsonProperty(value="size")
        @CanIgnoreReturnValue
        public final GroupResult.Builder size(int size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (GroupResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupResult.Builder addChildGroup(GroupId element) {
            this.childGroups.add((GroupId)GroupResultImpl.requireNonNull(element, "childGroups element"));
            return (GroupResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupResult.Builder addChildGroup(GroupId ... elements) {
            for (GroupId element : elements) {
                this.childGroups.add((GroupId)GroupResultImpl.requireNonNull(element, "childGroups element"));
            }
            return (GroupResult.Builder)this;
        }

        @JsonProperty(value="child_groups")
        @CanIgnoreReturnValue
        public final GroupResult.Builder childGroups(Iterable<? extends GroupId> elements) {
            this.childGroups.clear();
            return this.addAllChildGroups(elements);
        }

        @CanIgnoreReturnValue
        public final GroupResult.Builder addAllChildGroups(Iterable<? extends GroupId> elements) {
            for (GroupId groupId : elements) {
                this.childGroups.add((GroupId)GroupResultImpl.requireNonNull(groupId, "childGroups element"));
            }
            return (GroupResult.Builder)this;
        }

        @JsonProperty(value="auto_update")
        @CanIgnoreReturnValue
        public final GroupResult.Builder autoUpdate(@Nullable AutoUpdate autoUpdate) {
            this.autoUpdate = autoUpdate;
            return (GroupResult.Builder)this;
        }

        @JsonProperty(value="created_at")
        @CanIgnoreReturnValue
        public final GroupResult.Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = (OffsetDateTime)GroupResultImpl.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (GroupResult.Builder)this;
        }

        @JsonProperty(value="modified_at")
        @CanIgnoreReturnValue
        public final GroupResult.Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = (OffsetDateTime)GroupResultImpl.requireNonNull(modifiedAt, "modifiedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (GroupResult.Builder)this;
        }

        public GroupResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GroupResultImpl(this.id, this.name, this.size, GroupResultImpl.createUnmodifiableSet(this.childGroups), this.autoUpdate, this.createdAt, this.modifiedAt);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("modifiedAt");
            }
            return "Cannot build GroupResult, some of required attributes are not set " + attributes;
        }
    }
}

