/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.UpdateValue;
import com.sinch.xms.api.AutoUpdate;
import com.sinch.xms.api.GroupId;
import com.sinch.xms.api.GroupUpdate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class GroupUpdateImpl
extends GroupUpdate {
    @Nullable
    private final UpdateValue<String> name;
    private final Set<String> memberInsertions;
    private final Set<String> memberRemovals;
    private final Set<GroupId> childGroupInsertions;
    private final Set<GroupId> childGroupRemovals;
    @Nullable
    private final GroupId addFromGroup;
    @Nullable
    private final GroupId removeFromGroup;
    @Nullable
    private final UpdateValue<AutoUpdate> autoUpdate;

    private GroupUpdateImpl(@Nullable UpdateValue<String> name, Set<String> memberInsertions, Set<String> memberRemovals, Set<GroupId> childGroupInsertions, Set<GroupId> childGroupRemovals, @Nullable GroupId addFromGroup, @Nullable GroupId removeFromGroup, @Nullable UpdateValue<AutoUpdate> autoUpdate) {
        this.name = name;
        this.memberInsertions = memberInsertions;
        this.memberRemovals = memberRemovals;
        this.childGroupInsertions = childGroupInsertions;
        this.childGroupRemovals = childGroupRemovals;
        this.addFromGroup = addFromGroup;
        this.removeFromGroup = removeFromGroup;
        this.autoUpdate = autoUpdate;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public UpdateValue<String> name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="add")
    public Set<String> memberInsertions() {
        return this.memberInsertions;
    }

    @Override
    @JsonProperty(value="remove")
    public Set<String> memberRemovals() {
        return this.memberRemovals;
    }

    @Override
    @JsonProperty(value="child_groups_add")
    public Set<GroupId> childGroupInsertions() {
        return this.childGroupInsertions;
    }

    @Override
    @JsonProperty(value="child_groups_remove")
    public Set<GroupId> childGroupRemovals() {
        return this.childGroupRemovals;
    }

    @Override
    @JsonProperty(value="add_from_group")
    @Nullable
    public GroupId addFromGroup() {
        return this.addFromGroup;
    }

    @Override
    @JsonProperty(value="remove_from_group")
    @Nullable
    public GroupId removeFromGroup() {
        return this.removeFromGroup;
    }

    @Override
    @JsonProperty(value="auto_update")
    @Nullable
    public UpdateValue<AutoUpdate> autoUpdate() {
        return this.autoUpdate;
    }

    public final GroupUpdateImpl withName(@Nullable UpdateValue<String> value) {
        if (this.name == value) {
            return this;
        }
        return new GroupUpdateImpl(value, this.memberInsertions, this.memberRemovals, this.childGroupInsertions, this.childGroupRemovals, this.addFromGroup, this.removeFromGroup, this.autoUpdate);
    }

    public final GroupUpdateImpl withMemberInsertions(String ... elements) {
        Set<String> newValue = GroupUpdateImpl.createUnmodifiableSet(GroupUpdateImpl.createSafeList(Arrays.asList(elements), true, false));
        return new GroupUpdateImpl(this.name, newValue, this.memberRemovals, this.childGroupInsertions, this.childGroupRemovals, this.addFromGroup, this.removeFromGroup, this.autoUpdate);
    }

    public final GroupUpdateImpl withMemberInsertions(Iterable<String> elements) {
        if (this.memberInsertions == elements) {
            return this;
        }
        Set<String> newValue = GroupUpdateImpl.createUnmodifiableSet(GroupUpdateImpl.createSafeList(elements, true, false));
        return new GroupUpdateImpl(this.name, newValue, this.memberRemovals, this.childGroupInsertions, this.childGroupRemovals, this.addFromGroup, this.removeFromGroup, this.autoUpdate);
    }

    public final GroupUpdateImpl withMemberRemovals(String ... elements) {
        Set<String> newValue = GroupUpdateImpl.createUnmodifiableSet(GroupUpdateImpl.createSafeList(Arrays.asList(elements), true, false));
        return new GroupUpdateImpl(this.name, this.memberInsertions, newValue, this.childGroupInsertions, this.childGroupRemovals, this.addFromGroup, this.removeFromGroup, this.autoUpdate);
    }

    public final GroupUpdateImpl withMemberRemovals(Iterable<String> elements) {
        if (this.memberRemovals == elements) {
            return this;
        }
        Set<String> newValue = GroupUpdateImpl.createUnmodifiableSet(GroupUpdateImpl.createSafeList(elements, true, false));
        return new GroupUpdateImpl(this.name, this.memberInsertions, newValue, this.childGroupInsertions, this.childGroupRemovals, this.addFromGroup, this.removeFromGroup, this.autoUpdate);
    }

    public final GroupUpdateImpl withChildGroupInsertions(GroupId ... elements) {
        Set<GroupId> newValue = GroupUpdateImpl.createUnmodifiableSet(GroupUpdateImpl.createSafeList(Arrays.asList(elements), true, false));
        return new GroupUpdateImpl(this.name, this.memberInsertions, this.memberRemovals, newValue, this.childGroupRemovals, this.addFromGroup, this.removeFromGroup, this.autoUpdate);
    }

    public final GroupUpdateImpl withChildGroupInsertions(Iterable<? extends GroupId> elements) {
        if (this.childGroupInsertions == elements) {
            return this;
        }
        Set<GroupId> newValue = GroupUpdateImpl.createUnmodifiableSet(GroupUpdateImpl.createSafeList(elements, true, false));
        return new GroupUpdateImpl(this.name, this.memberInsertions, this.memberRemovals, newValue, this.childGroupRemovals, this.addFromGroup, this.removeFromGroup, this.autoUpdate);
    }

    public final GroupUpdateImpl withChildGroupRemovals(GroupId ... elements) {
        Set<GroupId> newValue = GroupUpdateImpl.createUnmodifiableSet(GroupUpdateImpl.createSafeList(Arrays.asList(elements), true, false));
        return new GroupUpdateImpl(this.name, this.memberInsertions, this.memberRemovals, this.childGroupInsertions, newValue, this.addFromGroup, this.removeFromGroup, this.autoUpdate);
    }

    public final GroupUpdateImpl withChildGroupRemovals(Iterable<? extends GroupId> elements) {
        if (this.childGroupRemovals == elements) {
            return this;
        }
        Set<GroupId> newValue = GroupUpdateImpl.createUnmodifiableSet(GroupUpdateImpl.createSafeList(elements, true, false));
        return new GroupUpdateImpl(this.name, this.memberInsertions, this.memberRemovals, this.childGroupInsertions, newValue, this.addFromGroup, this.removeFromGroup, this.autoUpdate);
    }

    public final GroupUpdateImpl withAddFromGroup(@Nullable GroupId value) {
        if (this.addFromGroup == value) {
            return this;
        }
        return new GroupUpdateImpl(this.name, this.memberInsertions, this.memberRemovals, this.childGroupInsertions, this.childGroupRemovals, value, this.removeFromGroup, this.autoUpdate);
    }

    public final GroupUpdateImpl withRemoveFromGroup(@Nullable GroupId value) {
        if (this.removeFromGroup == value) {
            return this;
        }
        return new GroupUpdateImpl(this.name, this.memberInsertions, this.memberRemovals, this.childGroupInsertions, this.childGroupRemovals, this.addFromGroup, value, this.autoUpdate);
    }

    public final GroupUpdateImpl withAutoUpdate(@Nullable UpdateValue<AutoUpdate> value) {
        if (this.autoUpdate == value) {
            return this;
        }
        return new GroupUpdateImpl(this.name, this.memberInsertions, this.memberRemovals, this.childGroupInsertions, this.childGroupRemovals, this.addFromGroup, this.removeFromGroup, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GroupUpdateImpl && this.equalTo((GroupUpdateImpl)another);
    }

    private boolean equalTo(GroupUpdateImpl another) {
        return GroupUpdateImpl.equals(this.name, another.name) && this.memberInsertions.equals(another.memberInsertions) && this.memberRemovals.equals(another.memberRemovals) && this.childGroupInsertions.equals(another.childGroupInsertions) && this.childGroupRemovals.equals(another.childGroupRemovals) && GroupUpdateImpl.equals(this.addFromGroup, another.addFromGroup) && GroupUpdateImpl.equals(this.removeFromGroup, another.removeFromGroup) && GroupUpdateImpl.equals(this.autoUpdate, another.autoUpdate);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + GroupUpdateImpl.hashCode(this.name);
        h = h * 17 + this.memberInsertions.hashCode();
        h = h * 17 + this.memberRemovals.hashCode();
        h = h * 17 + this.childGroupInsertions.hashCode();
        h = h * 17 + this.childGroupRemovals.hashCode();
        h = h * 17 + GroupUpdateImpl.hashCode(this.addFromGroup);
        h = h * 17 + GroupUpdateImpl.hashCode(this.removeFromGroup);
        h = h * 17 + GroupUpdateImpl.hashCode(this.autoUpdate);
        return h;
    }

    public String toString() {
        return "GroupUpdate{name=" + this.name + ", memberInsertions=" + this.memberInsertions + ", memberRemovals=" + this.memberRemovals + ", childGroupInsertions=" + this.childGroupInsertions + ", childGroupRemovals=" + this.childGroupRemovals + ", addFromGroup=" + this.addFromGroup + ", removeFromGroup=" + this.removeFromGroup + ", autoUpdate=" + this.autoUpdate + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GroupUpdateImpl fromJson(Json json) {
        GroupUpdate.Builder builder = new GroupUpdate.Builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.memberInsertions != null) {
            builder.addAllMemberInsertions(json.memberInsertions);
        }
        if (json.memberRemovals != null) {
            builder.addAllMemberRemovals(json.memberRemovals);
        }
        if (json.childGroupInsertions != null) {
            builder.addAllChildGroupInsertions(json.childGroupInsertions);
        }
        if (json.childGroupRemovals != null) {
            builder.addAllChildGroupRemovals(json.childGroupRemovals);
        }
        if (json.addFromGroup != null) {
            builder.addFromGroup(json.addFromGroup);
        }
        if (json.removeFromGroup != null) {
            builder.removeFromGroup(json.removeFromGroup);
        }
        if (json.autoUpdate != null) {
            builder.autoUpdate(json.autoUpdate);
        }
        return (GroupUpdateImpl)builder.build();
    }

    public static GroupUpdate copyOf(GroupUpdate instance) {
        if (instance instanceof GroupUpdateImpl) {
            return (GroupUpdateImpl)instance;
        }
        return new GroupUpdate.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                GroupUpdateImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    static class Builder {
        @Nullable
        private UpdateValue<String> name;
        private List<String> memberInsertions = new ArrayList<String>();
        private List<String> memberRemovals = new ArrayList<String>();
        private List<GroupId> childGroupInsertions = new ArrayList<GroupId>();
        private List<GroupId> childGroupRemovals = new ArrayList<GroupId>();
        @Nullable
        private GroupId addFromGroup;
        @Nullable
        private GroupId removeFromGroup;
        @Nullable
        private UpdateValue<AutoUpdate> autoUpdate;

        Builder() {
            if (!(this instanceof GroupUpdate.Builder)) {
                throw new UnsupportedOperationException("Use: new GroupUpdate.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final GroupUpdate.Builder using(GroupUpdate instance) {
            UpdateValue<AutoUpdate> autoUpdateValue;
            GroupId removeFromGroupValue;
            GroupUpdateImpl.requireNonNull(instance, "instance");
            UpdateValue<String> nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            this.addAllMemberInsertions(instance.memberInsertions());
            this.addAllMemberRemovals(instance.memberRemovals());
            this.addAllChildGroupInsertions(instance.childGroupInsertions());
            this.addAllChildGroupRemovals(instance.childGroupRemovals());
            GroupId addFromGroupValue = instance.addFromGroup();
            if (addFromGroupValue != null) {
                this.addFromGroup(addFromGroupValue);
            }
            if ((removeFromGroupValue = instance.removeFromGroup()) != null) {
                this.removeFromGroup(removeFromGroupValue);
            }
            if ((autoUpdateValue = instance.autoUpdate()) != null) {
                this.autoUpdate(autoUpdateValue);
            }
            return (GroupUpdate.Builder)this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final GroupUpdate.Builder name(@Nullable UpdateValue<String> name) {
            this.name = name;
            return (GroupUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupUpdate.Builder addMemberInsertion(String element) {
            this.memberInsertions.add((String)GroupUpdateImpl.requireNonNull(element, "memberInsertions element"));
            return (GroupUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupUpdate.Builder addMemberInsertion(String ... elements) {
            for (String element : elements) {
                this.memberInsertions.add((String)GroupUpdateImpl.requireNonNull(element, "memberInsertions element"));
            }
            return (GroupUpdate.Builder)this;
        }

        @JsonProperty(value="add")
        @CanIgnoreReturnValue
        public final GroupUpdate.Builder memberInsertions(Iterable<String> elements) {
            this.memberInsertions.clear();
            return this.addAllMemberInsertions(elements);
        }

        @CanIgnoreReturnValue
        public final GroupUpdate.Builder addAllMemberInsertions(Iterable<String> elements) {
            for (String element : elements) {
                this.memberInsertions.add((String)GroupUpdateImpl.requireNonNull(element, "memberInsertions element"));
            }
            return (GroupUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupUpdate.Builder addMemberRemoval(String element) {
            this.memberRemovals.add((String)GroupUpdateImpl.requireNonNull(element, "memberRemovals element"));
            return (GroupUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupUpdate.Builder addMemberRemoval(String ... elements) {
            for (String element : elements) {
                this.memberRemovals.add((String)GroupUpdateImpl.requireNonNull(element, "memberRemovals element"));
            }
            return (GroupUpdate.Builder)this;
        }

        @JsonProperty(value="remove")
        @CanIgnoreReturnValue
        public final GroupUpdate.Builder memberRemovals(Iterable<String> elements) {
            this.memberRemovals.clear();
            return this.addAllMemberRemovals(elements);
        }

        @CanIgnoreReturnValue
        public final GroupUpdate.Builder addAllMemberRemovals(Iterable<String> elements) {
            for (String element : elements) {
                this.memberRemovals.add((String)GroupUpdateImpl.requireNonNull(element, "memberRemovals element"));
            }
            return (GroupUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupUpdate.Builder addChildGroupInsertion(GroupId element) {
            this.childGroupInsertions.add((GroupId)GroupUpdateImpl.requireNonNull(element, "childGroupInsertions element"));
            return (GroupUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupUpdate.Builder addChildGroupInsertion(GroupId ... elements) {
            for (GroupId element : elements) {
                this.childGroupInsertions.add((GroupId)GroupUpdateImpl.requireNonNull(element, "childGroupInsertions element"));
            }
            return (GroupUpdate.Builder)this;
        }

        @JsonProperty(value="child_groups_add")
        @CanIgnoreReturnValue
        public final GroupUpdate.Builder childGroupInsertions(Iterable<? extends GroupId> elements) {
            this.childGroupInsertions.clear();
            return this.addAllChildGroupInsertions(elements);
        }

        @CanIgnoreReturnValue
        public final GroupUpdate.Builder addAllChildGroupInsertions(Iterable<? extends GroupId> elements) {
            for (GroupId groupId : elements) {
                this.childGroupInsertions.add((GroupId)GroupUpdateImpl.requireNonNull(groupId, "childGroupInsertions element"));
            }
            return (GroupUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupUpdate.Builder addChildGroupRemoval(GroupId element) {
            this.childGroupRemovals.add((GroupId)GroupUpdateImpl.requireNonNull(element, "childGroupRemovals element"));
            return (GroupUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GroupUpdate.Builder addChildGroupRemoval(GroupId ... elements) {
            for (GroupId element : elements) {
                this.childGroupRemovals.add((GroupId)GroupUpdateImpl.requireNonNull(element, "childGroupRemovals element"));
            }
            return (GroupUpdate.Builder)this;
        }

        @JsonProperty(value="child_groups_remove")
        @CanIgnoreReturnValue
        public final GroupUpdate.Builder childGroupRemovals(Iterable<? extends GroupId> elements) {
            this.childGroupRemovals.clear();
            return this.addAllChildGroupRemovals(elements);
        }

        @CanIgnoreReturnValue
        public final GroupUpdate.Builder addAllChildGroupRemovals(Iterable<? extends GroupId> elements) {
            for (GroupId groupId : elements) {
                this.childGroupRemovals.add((GroupId)GroupUpdateImpl.requireNonNull(groupId, "childGroupRemovals element"));
            }
            return (GroupUpdate.Builder)this;
        }

        @JsonProperty(value="add_from_group")
        @CanIgnoreReturnValue
        public final GroupUpdate.Builder addFromGroup(@Nullable GroupId addFromGroup) {
            this.addFromGroup = addFromGroup;
            return (GroupUpdate.Builder)this;
        }

        @JsonProperty(value="remove_from_group")
        @CanIgnoreReturnValue
        public final GroupUpdate.Builder removeFromGroup(@Nullable GroupId removeFromGroup) {
            this.removeFromGroup = removeFromGroup;
            return (GroupUpdate.Builder)this;
        }

        @JsonProperty(value="auto_update")
        @CanIgnoreReturnValue
        public final GroupUpdate.Builder autoUpdate(@Nullable UpdateValue<AutoUpdate> autoUpdate) {
            this.autoUpdate = autoUpdate;
            return (GroupUpdate.Builder)this;
        }

        public GroupUpdate build() {
            return new GroupUpdateImpl(this.name, GroupUpdateImpl.createUnmodifiableSet(this.memberInsertions), GroupUpdateImpl.createUnmodifiableSet(this.memberRemovals), GroupUpdateImpl.createUnmodifiableSet(this.childGroupInsertions), GroupUpdateImpl.createUnmodifiableSet(this.childGroupRemovals), this.addFromGroup, this.removeFromGroup, this.autoUpdate);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends GroupUpdate {
        @Nullable
        UpdateValue<String> name;
        Set<String> memberInsertions = Collections.emptySet();
        Set<String> memberRemovals = Collections.emptySet();
        Set<GroupId> childGroupInsertions = Collections.emptySet();
        Set<GroupId> childGroupRemovals = Collections.emptySet();
        @Nullable
        GroupId addFromGroup;
        @Nullable
        GroupId removeFromGroup;
        @Nullable
        UpdateValue<AutoUpdate> autoUpdate;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(@Nullable UpdateValue<String> name) {
            this.name = name;
        }

        @JsonProperty(value="add")
        public void setMemberInsertions(Set<String> memberInsertions) {
            this.memberInsertions = memberInsertions;
        }

        @JsonProperty(value="remove")
        public void setMemberRemovals(Set<String> memberRemovals) {
            this.memberRemovals = memberRemovals;
        }

        @JsonProperty(value="child_groups_add")
        public void setChildGroupInsertions(Set<GroupId> childGroupInsertions) {
            this.childGroupInsertions = childGroupInsertions;
        }

        @JsonProperty(value="child_groups_remove")
        public void setChildGroupRemovals(Set<GroupId> childGroupRemovals) {
            this.childGroupRemovals = childGroupRemovals;
        }

        @JsonProperty(value="add_from_group")
        public void setAddFromGroup(@Nullable GroupId addFromGroup) {
            this.addFromGroup = addFromGroup;
        }

        @JsonProperty(value="remove_from_group")
        public void setRemoveFromGroup(@Nullable GroupId removeFromGroup) {
            this.removeFromGroup = removeFromGroup;
        }

        @JsonProperty(value="auto_update")
        public void setAutoUpdate(@Nullable UpdateValue<AutoUpdate> autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public UpdateValue<String> name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> memberInsertions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> memberRemovals() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<GroupId> childGroupInsertions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<GroupId> childGroupRemovals() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GroupId addFromGroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GroupId removeFromGroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UpdateValue<AutoUpdate> autoUpdate() {
            throw new UnsupportedOperationException();
        }
    }
}

